"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class QueryParamAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class QueryParamAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: Annotated[str, FieldMetadata(query=True)]
    r"""A three-character ISO 4217 currency code."""

    value: Annotated[str, FieldMetadata(query=True)]
    r"""A string containing an exact monetary amount in the given currency."""


class ListMethodsRequestTypedDict(TypedDict):
    sequence_type: NotRequired[str]
    r"""Set this parameter to `first` to only return the enabled methods that can be used for the first payment of a recurring sequence.

    Set it to `recurring` to only return enabled methods that can be used for recurring payments or subscriptions.

    Possible values: `oneoff` `first` `recurring` (default: `oneoff`)
    """
    locale: NotRequired[str]
    r"""Passing a locale will sort the payment methods in the preferred order for the country, and translate the payment method names in the corresponding language.

    Possible values: `en_US` `en_GB` `nl_NL` `nl_BE` `de_DE` `de_AT` `de_CH` `fr_FR` `fr_BE` `es_ES` `ca_ES` `pt_PT` `it_IT` `nb_NO` `sv_SE` `fi_FI` `da_DK` `is_IS` `hu_HU` `pl_PL` `lv_LV` `lt_LT`
    """
    amount: NotRequired[QueryParamAmountTypedDict]
    r"""If supplied, only payment methods that support the amount and currency are returned.

    Example: `/v2/methods?amount[value]=100.00&amount[currency]=USD`
    """
    resource: NotRequired[str]
    r"""Indicate if you will use the result for the [Create order](create-order) or the [Create payment](create-payment) endpoint.

    When passing the value `orders`, the result will include payment methods that are only available for payments created via the Orders API.

    Possible values: `payments` `orders` (default: `payments`)
    """
    billing_country: NotRequired[str]
    r"""The country taken from your customer's billing address in ISO 3166-1 alpha-2 format. This parameter can be used to check whether your customer is eligible for certain payment methods, for example for Klarna.

    Example: `/v2/methods?resource=orders&billingCountry=DE`
    """
    include_wallets: NotRequired[str]
    r"""A comma-separated list of the wallets you support in your checkout. Wallets often require wallet specific code to check if they are available on the shoppers device, hence the need to indicate your support.

    Possible values: `applepay`
    """
    order_line_categories: NotRequired[str]
    r"""A comma-separated list of the order line categories you support in your checkout. The available categories can be found in the [Create order endpoint](create-order) documentation.

    Example: `/v2/methods?resource=orders&orderLineCategories=eco,meal`
    """
    profile_id: NotRequired[str]
    r"""The identifier referring to the [profile](get-profile) you wish to retrieve the payment methods for.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
    """
    include: NotRequired[Nullable[str]]
    r"""This endpoint allows you to include additional information via the `include` query string parameter.

    * `issuers`: Include issuer details such as which iDEAL or gift card issuers are available.
    * `pricing`: **⚠️ Deprecated: for up-to-date pricing data, use [List all methods](list-all-methods).⚠️** <br /> Include pricing information for each payment method, based on a snapshot of data last updated in November 2023.
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class ListMethodsRequest(BaseModel):
    sequence_type: Annotated[
        Optional[str],
        pydantic.Field(alias="sequenceType"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Set this parameter to `first` to only return the enabled methods that can be used for the first payment of a recurring sequence.

    Set it to `recurring` to only return enabled methods that can be used for recurring payments or subscriptions.

    Possible values: `oneoff` `first` `recurring` (default: `oneoff`)
    """

    locale: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Passing a locale will sort the payment methods in the preferred order for the country, and translate the payment method names in the corresponding language.

    Possible values: `en_US` `en_GB` `nl_NL` `nl_BE` `de_DE` `de_AT` `de_CH` `fr_FR` `fr_BE` `es_ES` `ca_ES` `pt_PT` `it_IT` `nb_NO` `sv_SE` `fi_FI` `da_DK` `is_IS` `hu_HU` `pl_PL` `lv_LV` `lt_LT`
    """

    amount: Annotated[
        Optional[QueryParamAmount],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""If supplied, only payment methods that support the amount and currency are returned.

    Example: `/v2/methods?amount[value]=100.00&amount[currency]=USD`
    """

    resource: Annotated[
        Optional[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Indicate if you will use the result for the [Create order](create-order) or the [Create payment](create-payment) endpoint.

    When passing the value `orders`, the result will include payment methods that are only available for payments created via the Orders API.

    Possible values: `payments` `orders` (default: `payments`)
    """

    billing_country: Annotated[
        Optional[str],
        pydantic.Field(alias="billingCountry"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The country taken from your customer's billing address in ISO 3166-1 alpha-2 format. This parameter can be used to check whether your customer is eligible for certain payment methods, for example for Klarna.

    Example: `/v2/methods?resource=orders&billingCountry=DE`
    """

    include_wallets: Annotated[
        Optional[str],
        pydantic.Field(alias="includeWallets"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""A comma-separated list of the wallets you support in your checkout. Wallets often require wallet specific code to check if they are available on the shoppers device, hence the need to indicate your support.

    Possible values: `applepay`
    """

    order_line_categories: Annotated[
        Optional[str],
        pydantic.Field(alias="orderLineCategories"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""A comma-separated list of the order line categories you support in your checkout. The available categories can be found in the [Create order endpoint](create-order) documentation.

    Example: `/v2/methods?resource=orders&orderLineCategories=eco,meal`
    """

    profile_id: Annotated[
        Optional[str],
        pydantic.Field(alias="profileId"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""The identifier referring to the [profile](get-profile) you wish to retrieve the payment methods for.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is required.
    """

    include: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""This endpoint allows you to include additional information via the `include` query string parameter.

    * `issuers`: Include issuer details such as which iDEAL or gift card issuers are available.
    * `pricing`: **⚠️ Deprecated: for up-to-date pricing data, use [List all methods](list-all-methods).⚠️** <br /> Include pricing information for each payment method, based on a snapshot of data last updated in November 2023.
    """

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = False
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sequenceType",
            "locale",
            "amount",
            "resource",
            "billingCountry",
            "includeWallets",
            "orderLineCategories",
            "profileId",
            "include",
            "testmode",
        ]
        nullable_fields = ["include", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListMethodsMethodsDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class ListMethodsMethodsDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class ListMethodsMethodsLinksTypedDict(TypedDict):
    documentation: NotRequired[ListMethodsMethodsDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class ListMethodsMethodsLinks(BaseModel):
    documentation: Optional[ListMethodsMethodsDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class ListMethodsMethodsResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[ListMethodsMethodsLinks], pydantic.Field(alias="_links")
    ] = None


class ListMethodsMethodsResponseBody(Exception):
    r"""An error response object."""

    data: ListMethodsMethodsResponseBodyData

    def __init__(self, data: ListMethodsMethodsResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, ListMethodsMethodsResponseBodyData)


class ListMethodsMethodsTypedDict(TypedDict):
    pass


class ListMethodsMethods(BaseModel):
    pass


class ListMethodsEmbeddedTypedDict(TypedDict):
    methods: NotRequired[List[ListMethodsMethodsTypedDict]]
    r"""An array of payment method objects. For a complete reference of the payment method object, refer to the [Get payment method endpoint](get-method) documentation."""


class ListMethodsEmbedded(BaseModel):
    methods: Optional[List[ListMethodsMethods]] = None
    r"""An array of payment method objects. For a complete reference of the payment method object, refer to the [Get payment method endpoint](get-method) documentation."""


class ListMethodsSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListMethodsSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListMethodsDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListMethodsDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListMethodsLinksTypedDict(TypedDict):
    self_: NotRequired[ListMethodsSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[ListMethodsDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListMethodsLinks(BaseModel):
    self_: Annotated[Optional[ListMethodsSelf], pydantic.Field(alias="self")] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[ListMethodsDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListMethodsResponseBodyTypedDict(TypedDict):
    r"""A list of payment method objects. For a complete reference of the payment method object, refer to the [Get payment method endpoint](get-method) documentation."""

    count: NotRequired[int]
    r"""The number of payment method objects in this result set. Results are **not** paginated."""
    embedded: NotRequired[ListMethodsEmbeddedTypedDict]
    links: NotRequired[ListMethodsLinksTypedDict]


class ListMethodsResponseBody(BaseModel):
    r"""A list of payment method objects. For a complete reference of the payment method object, refer to the [Get payment method endpoint](get-method) documentation."""

    count: Optional[int] = None
    r"""The number of payment method objects in this result set. Results are **not** paginated."""

    embedded: Annotated[
        Optional[ListMethodsEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[Optional[ListMethodsLinks], pydantic.Field(alias="_links")] = None
