"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie import utils
from mollie.types import BaseModel, OptionalNullable, UNSET
import pydantic
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListPermissionsPermissionsDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class ListPermissionsPermissionsDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class ListPermissionsPermissionsLinksTypedDict(TypedDict):
    documentation: NotRequired[ListPermissionsPermissionsDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class ListPermissionsPermissionsLinks(BaseModel):
    documentation: Optional[ListPermissionsPermissionsDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class ListPermissionsPermissionsResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[ListPermissionsPermissionsLinks], pydantic.Field(alias="_links")
    ] = None


class ListPermissionsPermissionsResponseBody(Exception):
    r"""An error response object."""

    data: ListPermissionsPermissionsResponseBodyData

    def __init__(self, data: ListPermissionsPermissionsResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, ListPermissionsPermissionsResponseBodyData)


class ListPermissionsPermissionsTypedDict(TypedDict):
    pass


class ListPermissionsPermissions(BaseModel):
    pass


class ListPermissionsEmbeddedTypedDict(TypedDict):
    permissions: NotRequired[List[ListPermissionsPermissionsTypedDict]]
    r"""An array of permission objects. For a complete reference of the permission object, refer to the [Get permission endpoint](get-permission) documentation."""


class ListPermissionsEmbedded(BaseModel):
    permissions: Optional[List[ListPermissionsPermissions]] = None
    r"""An array of permission objects. For a complete reference of the permission object, refer to the [Get permission endpoint](get-permission) documentation."""


class ListPermissionsSelfTypedDict(TypedDict):
    r"""The URL to the current set of items."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListPermissionsSelf(BaseModel):
    r"""The URL to the current set of items."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListPermissionsDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListPermissionsDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListPermissionsLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[ListPermissionsSelfTypedDict]
    r"""The URL to the current set of items."""
    documentation: NotRequired[ListPermissionsDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListPermissionsLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[ListPermissionsSelf], pydantic.Field(alias="self")] = None
    r"""The URL to the current set of items."""

    documentation: Optional[ListPermissionsDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListPermissionsResponseBodyTypedDict(TypedDict):
    r"""A list of permission objects. For a complete reference of the permission object, refer to the [Get permission endpoint](get-permission) documentation."""

    count: NotRequired[int]
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default limit is 50 items.
    """
    embedded: NotRequired[ListPermissionsEmbeddedTypedDict]
    links: NotRequired[ListPermissionsLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class ListPermissionsResponseBody(BaseModel):
    r"""A list of permission objects. For a complete reference of the permission object, refer to the [Get permission endpoint](get-permission) documentation."""

    count: Optional[int] = None
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default limit is 50 items.
    """

    embedded: Annotated[
        Optional[ListPermissionsEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[Optional[ListPermissionsLinks], pydantic.Field(alias="_links")] = (
        None
    )
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
