"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListRefundsRequestTypedDict(TypedDict):
    payment_id: str
    r"""Provide the ID of the related payment."""
    from_: NotRequired[str]
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the result set."""
    limit: NotRequired[Nullable[int]]
    r"""The maximum number of items to return. Defaults to 50 items."""
    include: NotRequired[Nullable[str]]
    r"""This endpoint allows you to include additional information via the `include` query string parameter.

    * `payment`: Include the payments that the refunds were created for.
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class ListRefundsRequest(BaseModel):
    payment_id: Annotated[
        str,
        pydantic.Field(alias="paymentId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related payment."""

    from_: Annotated[
        Optional[str],
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the result set."""

    limit: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 50
    r"""The maximum number of items to return. Defaults to 50 items."""

    include: Annotated[
        OptionalNullable[str],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""This endpoint allows you to include additional information via the `include` query string parameter.

    * `payment`: Include the payments that the refunds were created for.
    """

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = False
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["from", "limit", "include", "testmode"]
        nullable_fields = ["limit", "include", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListRefundsRefundsResponseDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class ListRefundsRefundsResponseDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class ListRefundsRefundsResponseLinksTypedDict(TypedDict):
    documentation: NotRequired[ListRefundsRefundsResponseDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class ListRefundsRefundsResponseLinks(BaseModel):
    documentation: Optional[ListRefundsRefundsResponseDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class ListRefundsRefundsResponseResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[ListRefundsRefundsResponseLinks], pydantic.Field(alias="_links")
    ] = None


class ListRefundsRefundsResponseResponseBody(Exception):
    r"""An error response object."""

    data: ListRefundsRefundsResponseResponseBodyData

    def __init__(self, data: ListRefundsRefundsResponseResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, ListRefundsRefundsResponseResponseBodyData)


class ListRefundsRefundsDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class ListRefundsRefundsDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class ListRefundsRefundsLinksTypedDict(TypedDict):
    documentation: NotRequired[ListRefundsRefundsDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class ListRefundsRefundsLinks(BaseModel):
    documentation: Optional[ListRefundsRefundsDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class ListRefundsRefundsResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[ListRefundsRefundsLinks], pydantic.Field(alias="_links")
    ] = None


class ListRefundsRefundsResponseBody(Exception):
    r"""An error response object."""

    data: ListRefundsRefundsResponseBodyData

    def __init__(self, data: ListRefundsRefundsResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, ListRefundsRefundsResponseBodyData)


class ListRefundsRefundsTypedDict(TypedDict):
    pass


class ListRefundsRefunds(BaseModel):
    pass


class ListRefundsEmbeddedTypedDict(TypedDict):
    refunds: NotRequired[List[ListRefundsRefundsTypedDict]]
    r"""An array of refund objects. For a complete reference of the refund object, refer to the [Get refund endpoint](get-refund) documentation."""


class ListRefundsEmbedded(BaseModel):
    refunds: Optional[List[ListRefundsRefunds]] = None
    r"""An array of refund objects. For a complete reference of the refund object, refer to the [Get refund endpoint](get-refund) documentation."""


class ListRefundsSelfTypedDict(TypedDict):
    r"""The URL to the current set of items."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListRefundsSelf(BaseModel):
    r"""The URL to the current set of items."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListRefundsPreviousTypedDict(TypedDict):
    r"""The previous set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListRefundsPrevious(BaseModel):
    r"""The previous set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListRefundsNextTypedDict(TypedDict):
    r"""The next set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListRefundsNext(BaseModel):
    r"""The next set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListRefundsDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListRefundsDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListRefundsLinksTypedDict(TypedDict):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[ListRefundsSelfTypedDict]
    r"""The URL to the current set of items."""
    previous: NotRequired[Nullable[ListRefundsPreviousTypedDict]]
    r"""The previous set of items, if available."""
    next: NotRequired[Nullable[ListRefundsNextTypedDict]]
    r"""The next set of items, if available."""
    documentation: NotRequired[ListRefundsDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListRefundsLinks(BaseModel):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[ListRefundsSelf], pydantic.Field(alias="self")] = None
    r"""The URL to the current set of items."""

    previous: OptionalNullable[ListRefundsPrevious] = UNSET
    r"""The previous set of items, if available."""

    next: OptionalNullable[ListRefundsNext] = UNSET
    r"""The next set of items, if available."""

    documentation: Optional[ListRefundsDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["self", "previous", "next", "documentation"]
        nullable_fields = ["previous", "next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListRefundsResponseBodyTypedDict(TypedDict):
    r"""A list of refund objects. For a complete reference of the refund object, refer to the [Get refund endpoint](get-refund) documentation."""

    count: NotRequired[int]
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default limit is 50 items.
    """
    embedded: NotRequired[ListRefundsEmbeddedTypedDict]
    links: NotRequired[ListRefundsLinksTypedDict]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class ListRefundsResponseBody(BaseModel):
    r"""A list of refund objects. For a complete reference of the refund object, refer to the [Get refund endpoint](get-refund) documentation."""

    count: Optional[int] = None
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default limit is 50 items.
    """

    embedded: Annotated[
        Optional[ListRefundsEmbedded], pydantic.Field(alias="_embedded")
    ] = None

    links: Annotated[Optional[ListRefundsLinks], pydantic.Field(alias="_links")] = None
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
