"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ManageOrderLinesAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ManageOrderLinesAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class DataTypedDict(TypedDict):
    r"""Operation data depending on the type of operation.

    For an `add` operation, provide the fields for the new order line in the same format as in the [Create order](create-order) endpoint.

    For an `update` operation, provide the `id` of the order line, along with any fields you would like to update.

    For a `cancel` operation, provide the `id` of the order line. Optionally, a `quantity` or `amount` can be provided to only partially cancel an order line.
    """

    id: NotRequired[Nullable[str]]
    r"""Required for `update` and `cancel` operations. For example: `odl_dgtxyl`."""
    quantity: NotRequired[Nullable[int]]
    amount: NotRequired[Nullable[ManageOrderLinesAmountTypedDict]]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""


class Data(BaseModel):
    r"""Operation data depending on the type of operation.

    For an `add` operation, provide the fields for the new order line in the same format as in the [Create order](create-order) endpoint.

    For an `update` operation, provide the `id` of the order line, along with any fields you would like to update.

    For a `cancel` operation, provide the `id` of the order line. Optionally, a `quantity` or `amount` can be provided to only partially cancel an order line.
    """

    id: OptionalNullable[str] = UNSET
    r"""Required for `update` and `cancel` operations. For example: `odl_dgtxyl`."""

    quantity: OptionalNullable[int] = UNSET

    amount: OptionalNullable[ManageOrderLinesAmount] = UNSET
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "quantity", "amount"]
        nullable_fields = ["id", "quantity", "amount"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class OperationsTypedDict(TypedDict):
    operation: str
    r"""Type of operation.

    Possible values: `add` `update` `cancel`
    """
    data: DataTypedDict
    r"""Operation data depending on the type of operation.

    For an `add` operation, provide the fields for the new order line in the same format as in the [Create order](create-order) endpoint.

    For an `update` operation, provide the `id` of the order line, along with any fields you would like to update.

    For a `cancel` operation, provide the `id` of the order line. Optionally, a `quantity` or `amount` can be provided to only partially cancel an order line.
    """


class Operations(BaseModel):
    operation: str
    r"""Type of operation.

    Possible values: `add` `update` `cancel`
    """

    data: Data
    r"""Operation data depending on the type of operation.

    For an `add` operation, provide the fields for the new order line in the same format as in the [Create order](create-order) endpoint.

    For an `update` operation, provide the `id` of the order line, along with any fields you would like to update.

    For a `cancel` operation, provide the `id` of the order line. Optionally, a `quantity` or `amount` can be provided to only partially cancel an order line.
    """


class ManageOrderLinesRequestBodyTypedDict(TypedDict):
    operations: List[OperationsTypedDict]
    r"""List of operations to be performed on the order's line items."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class ManageOrderLinesRequestBody(BaseModel):
    operations: List[Operations]
    r"""List of operations to be performed on the order's line items."""

    testmode: OptionalNullable[bool] = False
    r"""Most API credentials are specifically created for either live mode or test mode. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["testmode"]
        nullable_fields = ["testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ManageOrderLinesRequestTypedDict(TypedDict):
    order_id: str
    r"""Provide the ID of the related order."""
    request_body: NotRequired[ManageOrderLinesRequestBodyTypedDict]


class ManageOrderLinesRequest(BaseModel):
    order_id: Annotated[
        str,
        pydantic.Field(alias="orderId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related order."""

    request_body: Annotated[
        Optional[ManageOrderLinesRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None


class ManageOrderLinesDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class ManageOrderLinesDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class ManageOrderLinesLinksTypedDict(TypedDict):
    documentation: NotRequired[ManageOrderLinesDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class ManageOrderLinesLinks(BaseModel):
    documentation: Optional[ManageOrderLinesDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class ManageOrderLinesResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[ManageOrderLinesLinks], pydantic.Field(alias="_links")
    ] = None


class ManageOrderLinesResponseBody(Exception):
    r"""An error response object."""

    data: ManageOrderLinesResponseBodyData

    def __init__(self, data: ManageOrderLinesResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, ManageOrderLinesResponseBodyData)
