"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdateOrderLineUnitPriceTypedDict(TypedDict):
    r"""Required when a `quantity`, `discountAmount`, `totalAmount`, `vatAmount`, or `vatRate` is also provided in the same request."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class UpdateOrderLineUnitPrice(BaseModel):
    r"""Required when a `quantity`, `discountAmount`, `totalAmount`, `vatAmount`, or `vatRate` is also provided in the same request."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class UpdateOrderLineDiscountAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class UpdateOrderLineDiscountAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class UpdateOrderLineTotalAmountTypedDict(TypedDict):
    r"""Required when a `quantity`, `unitPrice`, `discountAmount`, `vatAmount`, or `vatRate` is also provided in the same request."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class UpdateOrderLineTotalAmount(BaseModel):
    r"""Required when a `quantity`, `unitPrice`, `discountAmount`, `vatAmount`, or `vatRate` is also provided in the same request."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class UpdateOrderLineVatAmountTypedDict(TypedDict):
    r"""Required when a `quantity`, `unitPrice`, `discountAmount`, `totalAmount`, or `vatRate` is also provided in the same request."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class UpdateOrderLineVatAmount(BaseModel):
    r"""Required when a `quantity`, `unitPrice`, `discountAmount`, `totalAmount`, or `vatRate` is also provided in the same request."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class UpdateOrderLineRequestBodyTypedDict(TypedDict):
    name: NotRequired[Nullable[str]]
    image_url: NotRequired[Nullable[str]]
    product_url: NotRequired[Nullable[str]]
    sku: NotRequired[Nullable[str]]
    metadata: NotRequired[Nullable[str]]
    quantity: NotRequired[Nullable[int]]
    r"""Required when a `unitPrice`, `discountAmount`, `totalAmount`, `vatAmount`, or `vatRate` is also provided in the same request."""
    unit_price: NotRequired[Nullable[UpdateOrderLineUnitPriceTypedDict]]
    r"""Required when a `quantity`, `discountAmount`, `totalAmount`, `vatAmount`, or `vatRate` is also provided in the same request."""
    discount_amount: NotRequired[Nullable[UpdateOrderLineDiscountAmountTypedDict]]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    total_amount: NotRequired[Nullable[UpdateOrderLineTotalAmountTypedDict]]
    r"""Required when a `quantity`, `unitPrice`, `discountAmount`, `vatAmount`, or `vatRate` is also provided in the same request."""
    vat_amount: NotRequired[Nullable[UpdateOrderLineVatAmountTypedDict]]
    r"""Required when a `quantity`, `unitPrice`, `discountAmount`, `totalAmount`, or `vatRate` is also provided in the same request."""
    vat_rate: NotRequired[Nullable[str]]
    r"""Required when a `quantity`, `unitPrice`, `discountAmount`, `totalAmount`, or `vatAmount` is also provided in the same request."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class UpdateOrderLineRequestBody(BaseModel):
    name: OptionalNullable[str] = UNSET

    image_url: Annotated[OptionalNullable[str], pydantic.Field(alias="imageUrl")] = (
        UNSET
    )

    product_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="productUrl")
    ] = UNSET

    sku: OptionalNullable[str] = UNSET

    metadata: OptionalNullable[str] = UNSET

    quantity: OptionalNullable[int] = UNSET
    r"""Required when a `unitPrice`, `discountAmount`, `totalAmount`, `vatAmount`, or `vatRate` is also provided in the same request."""

    unit_price: Annotated[
        OptionalNullable[UpdateOrderLineUnitPrice], pydantic.Field(alias="unitPrice")
    ] = UNSET
    r"""Required when a `quantity`, `discountAmount`, `totalAmount`, `vatAmount`, or `vatRate` is also provided in the same request."""

    discount_amount: Annotated[
        OptionalNullable[UpdateOrderLineDiscountAmount],
        pydantic.Field(alias="discountAmount"),
    ] = UNSET
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    total_amount: Annotated[
        OptionalNullable[UpdateOrderLineTotalAmount],
        pydantic.Field(alias="totalAmount"),
    ] = UNSET
    r"""Required when a `quantity`, `unitPrice`, `discountAmount`, `vatAmount`, or `vatRate` is also provided in the same request."""

    vat_amount: Annotated[
        OptionalNullable[UpdateOrderLineVatAmount], pydantic.Field(alias="vatAmount")
    ] = UNSET
    r"""Required when a `quantity`, `unitPrice`, `discountAmount`, `totalAmount`, or `vatRate` is also provided in the same request."""

    vat_rate: Annotated[OptionalNullable[str], pydantic.Field(alias="vatRate")] = UNSET
    r"""Required when a `quantity`, `unitPrice`, `discountAmount`, `totalAmount`, or `vatAmount` is also provided in the same request."""

    testmode: OptionalNullable[bool] = False
    r"""Most API credentials are specifically created for either live mode or test mode. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "name",
            "imageUrl",
            "productUrl",
            "sku",
            "metadata",
            "quantity",
            "unitPrice",
            "discountAmount",
            "totalAmount",
            "vatAmount",
            "vatRate",
            "testmode",
        ]
        nullable_fields = [
            "name",
            "imageUrl",
            "productUrl",
            "sku",
            "metadata",
            "quantity",
            "unitPrice",
            "discountAmount",
            "totalAmount",
            "vatAmount",
            "vatRate",
            "testmode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class UpdateOrderLineRequestTypedDict(TypedDict):
    order_id: str
    r"""Provide the ID of the related order."""
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""
    request_body: NotRequired[UpdateOrderLineRequestBodyTypedDict]


class UpdateOrderLineRequest(BaseModel):
    order_id: Annotated[
        str,
        pydantic.Field(alias="orderId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related order."""

    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""

    request_body: Annotated[
        Optional[UpdateOrderLineRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None


class UpdateOrderLineOrdersDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class UpdateOrderLineOrdersDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class UpdateOrderLineOrdersLinksTypedDict(TypedDict):
    documentation: NotRequired[UpdateOrderLineOrdersDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateOrderLineOrdersLinks(BaseModel):
    documentation: Optional[UpdateOrderLineOrdersDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateOrderLineOrdersResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[UpdateOrderLineOrdersLinks], pydantic.Field(alias="_links")
    ] = None


class UpdateOrderLineOrdersResponseBody(Exception):
    r"""An error response object."""

    data: UpdateOrderLineOrdersResponseBodyData

    def __init__(self, data: UpdateOrderLineOrdersResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, UpdateOrderLineOrdersResponseBodyData)


class UpdateOrderLineDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class UpdateOrderLineDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class UpdateOrderLineLinksTypedDict(TypedDict):
    documentation: NotRequired[UpdateOrderLineDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateOrderLineLinks(BaseModel):
    documentation: Optional[UpdateOrderLineDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateOrderLineResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[Optional[UpdateOrderLineLinks], pydantic.Field(alias="_links")] = (
        None
    )


class UpdateOrderLineResponseBody(Exception):
    r"""An error response object."""

    data: UpdateOrderLineResponseBodyData

    def __init__(self, data: UpdateOrderLineResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, UpdateOrderLineResponseBodyData)
