"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from pydantic import model_serializer
from typing import Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdatePaymentRequestBodyTypedDict(TypedDict):
    description: NotRequired[Nullable[str]]
    redirect_url: NotRequired[Nullable[str]]
    r"""Can be updated while the payment is in an `open` state."""
    cancel_url: NotRequired[Nullable[str]]
    r"""Can be updated while the payment is in an `open` state."""
    webhook_url: NotRequired[Nullable[str]]
    metadata: NotRequired[Nullable[str]]
    method: NotRequired[Nullable[str]]
    r"""Can be updated while no payment method has been chosen yet."""
    locale: NotRequired[Nullable[str]]
    restrict_payment_methods_to_country: NotRequired[Nullable[str]]
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class UpdatePaymentRequestBody(BaseModel):
    description: OptionalNullable[str] = UNSET

    redirect_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="redirectUrl")
    ] = UNSET
    r"""Can be updated while the payment is in an `open` state."""

    cancel_url: Annotated[OptionalNullable[str], pydantic.Field(alias="cancelUrl")] = (
        UNSET
    )
    r"""Can be updated while the payment is in an `open` state."""

    webhook_url: Annotated[
        OptionalNullable[str], pydantic.Field(alias="webhookUrl")
    ] = UNSET

    metadata: OptionalNullable[str] = UNSET

    method: OptionalNullable[str] = UNSET
    r"""Can be updated while no payment method has been chosen yet."""

    locale: OptionalNullable[str] = UNSET

    restrict_payment_methods_to_country: Annotated[
        OptionalNullable[str], pydantic.Field(alias="restrictPaymentMethodsToCountry")
    ] = UNSET

    testmode: OptionalNullable[bool] = False
    r"""Most API credentials are specifically created for either live mode or test mode. For organization-level credentials such as OAuth access tokens, you can enable test mode by setting `testmode` to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "description",
            "redirectUrl",
            "cancelUrl",
            "webhookUrl",
            "metadata",
            "method",
            "locale",
            "restrictPaymentMethodsToCountry",
            "testmode",
        ]
        nullable_fields = [
            "description",
            "redirectUrl",
            "cancelUrl",
            "webhookUrl",
            "metadata",
            "method",
            "locale",
            "restrictPaymentMethodsToCountry",
            "testmode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class UpdatePaymentRequestTypedDict(TypedDict):
    payment_id: str
    r"""Provide the ID of the related payment."""
    request_body: NotRequired[UpdatePaymentRequestBodyTypedDict]


class UpdatePaymentRequest(BaseModel):
    payment_id: Annotated[
        str,
        pydantic.Field(alias="paymentId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related payment."""

    request_body: Annotated[
        Optional[UpdatePaymentRequestBody],
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ] = None


class UpdatePaymentPaymentsDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class UpdatePaymentPaymentsDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class UpdatePaymentPaymentsLinksTypedDict(TypedDict):
    documentation: NotRequired[UpdatePaymentPaymentsDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class UpdatePaymentPaymentsLinks(BaseModel):
    documentation: Optional[UpdatePaymentPaymentsDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class UpdatePaymentPaymentsResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[UpdatePaymentPaymentsLinks], pydantic.Field(alias="_links")
    ] = None


class UpdatePaymentPaymentsResponseBody(Exception):
    r"""An error response object."""

    data: UpdatePaymentPaymentsResponseBodyData

    def __init__(self, data: UpdatePaymentPaymentsResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, UpdatePaymentPaymentsResponseBodyData)


class UpdatePaymentDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class UpdatePaymentDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class UpdatePaymentLinksTypedDict(TypedDict):
    documentation: NotRequired[UpdatePaymentDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class UpdatePaymentLinks(BaseModel):
    documentation: Optional[UpdatePaymentDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class UpdatePaymentResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[Optional[UpdatePaymentLinks], pydantic.Field(alias="_links")] = (
        None
    )


class UpdatePaymentResponseBody(Exception):
    r"""An error response object."""

    data: UpdatePaymentResponseBodyData

    def __init__(self, data: UpdatePaymentResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, UpdatePaymentResponseBodyData)
