"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from mollie import utils
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, RequestMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class UpdateProfileRequestBodyTypedDict(TypedDict):
    name: NotRequired[Nullable[str]]
    r"""The profile's name, this will usually reflect the trade name or brand name of the profile's website or application."""
    website: NotRequired[Nullable[str]]
    r"""The URL to the profile's website or application. Only `https` or `http` URLs are allowed. No `@` signs are allowed."""
    email: NotRequired[Nullable[str]]
    r"""The email address associated with the profile's trade name or brand."""
    phone: NotRequired[Nullable[str]]
    r"""The phone number associated with the profile's trade name or brand."""
    description: NotRequired[Nullable[str]]
    r"""The products or services offered by the profile's website or application."""
    countries_of_activity: NotRequired[Nullable[List[str]]]
    r"""A list of countries where you expect that the majority of the profile's customers reside, in ISO 3166-1 alpha-2 format."""
    business_category: NotRequired[Nullable[str]]
    r"""The industry associated with the profile's trade name or brand. Please refer to the [business category list](common-data-types) for all possible options."""
    mode: NotRequired[Nullable[str]]
    r"""Updating a profile from `test` mode to `live` mode will trigger a verification process, where we review the profile before it can start accepting payments.

    Possible values: `live` `test`
    """


class UpdateProfileRequestBody(BaseModel):
    name: OptionalNullable[str] = UNSET
    r"""The profile's name, this will usually reflect the trade name or brand name of the profile's website or application."""

    website: OptionalNullable[str] = UNSET
    r"""The URL to the profile's website or application. Only `https` or `http` URLs are allowed. No `@` signs are allowed."""

    email: OptionalNullable[str] = UNSET
    r"""The email address associated with the profile's trade name or brand."""

    phone: OptionalNullable[str] = UNSET
    r"""The phone number associated with the profile's trade name or brand."""

    description: OptionalNullable[str] = UNSET
    r"""The products or services offered by the profile's website or application."""

    countries_of_activity: Annotated[
        OptionalNullable[List[str]], pydantic.Field(alias="countriesOfActivity")
    ] = UNSET
    r"""A list of countries where you expect that the majority of the profile's customers reside, in ISO 3166-1 alpha-2 format."""

    business_category: Annotated[
        OptionalNullable[str], pydantic.Field(alias="businessCategory")
    ] = UNSET
    r"""The industry associated with the profile's trade name or brand. Please refer to the [business category list](common-data-types) for all possible options."""

    mode: OptionalNullable[str] = UNSET
    r"""Updating a profile from `test` mode to `live` mode will trigger a verification process, where we review the profile before it can start accepting payments.

    Possible values: `live` `test`
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "name",
            "website",
            "email",
            "phone",
            "description",
            "countriesOfActivity",
            "businessCategory",
            "mode",
        ]
        nullable_fields = [
            "name",
            "website",
            "email",
            "phone",
            "description",
            "countriesOfActivity",
            "businessCategory",
            "mode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in self.model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class UpdateProfileRequestTypedDict(TypedDict):
    id: str
    r"""Provide the ID of the item you want to perform this operation on."""
    request_body: UpdateProfileRequestBodyTypedDict


class UpdateProfileRequest(BaseModel):
    id: Annotated[
        str, FieldMetadata(path=PathParamMetadata(style="simple", explode=False))
    ]
    r"""Provide the ID of the item you want to perform this operation on."""

    request_body: Annotated[
        UpdateProfileRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]


class UpdateProfileProfilesResponseDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class UpdateProfileProfilesResponseDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class UpdateProfileProfilesResponseLinksTypedDict(TypedDict):
    documentation: NotRequired[UpdateProfileProfilesResponseDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateProfileProfilesResponseLinks(BaseModel):
    documentation: Optional[UpdateProfileProfilesResponseDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateProfileProfilesResponseResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[UpdateProfileProfilesResponseLinks], pydantic.Field(alias="_links")
    ] = None


class UpdateProfileProfilesResponseResponseBody(Exception):
    r"""An error response object."""

    data: UpdateProfileProfilesResponseResponseBodyData

    def __init__(self, data: UpdateProfileProfilesResponseResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(
            self.data, UpdateProfileProfilesResponseResponseBodyData
        )


class UpdateProfileProfilesDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class UpdateProfileProfilesDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class UpdateProfileProfilesLinksTypedDict(TypedDict):
    documentation: NotRequired[UpdateProfileProfilesDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateProfileProfilesLinks(BaseModel):
    documentation: Optional[UpdateProfileProfilesDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateProfileProfilesResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[
        Optional[UpdateProfileProfilesLinks], pydantic.Field(alias="_links")
    ] = None


class UpdateProfileProfilesResponseBody(Exception):
    r"""An error response object."""

    data: UpdateProfileProfilesResponseBodyData

    def __init__(self, data: UpdateProfileProfilesResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, UpdateProfileProfilesResponseBodyData)


class UpdateProfileDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: NotRequired[str]
    type: NotRequired[str]


class UpdateProfileDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: Optional[str] = "https://docs.mollie.com/errors"

    type: Optional[str] = "text/html"


class UpdateProfileLinksTypedDict(TypedDict):
    documentation: NotRequired[UpdateProfileDocumentationTypedDict]
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateProfileLinks(BaseModel):
    documentation: Optional[UpdateProfileDocumentation] = None
    r"""The URL to the generic Mollie API error handling guide."""


class UpdateProfileResponseBodyData(BaseModel):
    status: Optional[int] = None
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: Optional[str] = None
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: Optional[str] = None
    r"""A detailed human-readable description of the error that occurred."""

    field: OptionalNullable[str] = UNSET
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name of the field that caused the issue."""

    links: Annotated[Optional[UpdateProfileLinks], pydantic.Field(alias="_links")] = (
        None
    )


class UpdateProfileResponseBody(Exception):
    r"""An error response object."""

    data: UpdateProfileResponseBodyData

    def __init__(self, data: UpdateProfileResponseBodyData):
        self.data = data

    def __str__(self) -> str:
        return utils.marshal_json(self.data, UpdateProfileResponseBodyData)
