/*
 * Decompiled with CFR 0.152.
 */
package log;

import config.Config;
import config.DevMode;
import java.io.OutputStreamWriter;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import log.ArtifactManagerFactory;
import log.ILogger;
import log.Logger;
import log.LoggerLevels;
import log.LoggerTypes;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import utils.OutPrinter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J \u0010\u0014\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J \u0010\u0019\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\b\u0010\u001a\u001a\u00020\u0006H\u0016J(\u0010\u001b\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u001c\u001a\u00020\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J \u0010\u001d\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001f"}, d2={"Llog/Logger;", "Llog/ILogger;", "type", "Llog/LoggerTypes;", "(Llog/LoggerTypes;)V", "consoleLogExceptions", "", "logger", "Lmu/KLogger;", "getLogger", "()Lmu/KLogger;", "getType", "()Llog/LoggerTypes;", "debug", "", "t", "", "msg", "Lkotlin/Function0;", "", "error", "formatMessage", "", "level", "Llog/LoggerLevels;", "info", "isEnabled", "outPrintLog", "trace", "warn", "Companion", "Shared"})
@SourceDebugExtension(value={"SMAP\nLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Logger.kt\nlog/Logger\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,286:1\n1#2:287\n*E\n"})
public final class Logger
implements ILogger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LoggerTypes type;
    private final boolean consoleLogExceptions;
    @NotNull
    private final KLogger logger;
    @NotNull
    public static final String unitTestingModePropertyName = "UNIT_TESTING";
    @NotNull
    private static final String slf4jPrefix = "org.slf4j.simpleLogger.log.";
    @NotNull
    private static final Logger underlyingLogger = new Logger(LoggerTypes.ALWAYS);
    @NotNull
    private static final Lazy<OutputStreamWriter> regressionFile$delegate = LazyKt.lazy(Companion.regressionFile.2.INSTANCE);

    public Logger(@NotNull LoggerTypes type2) {
        String levelString;
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        this.type = type2;
        String levelProp = this.type.toLevelProp();
        String level = System.getProperty(levelProp);
        String verboseProp = this.type.toVerboseProp();
        String string = level != null ? level : (levelString = System.getProperty(verboseProp) != null ? "DEBUG" : null);
        if (levelString != null) {
            System.setProperty(slf4jPrefix + this.type, levelString);
            if (System.getProperty(this.type.toTopicProp()) == null) {
                System.setProperty(this.type.toTopicProp(), "1");
            }
        }
        this.consoleLogExceptions = DevMode.INSTANCE.isDevMode() && !Intrinsics.areEqual(System.getProperty(unitTestingModePropertyName), "1");
        this.logger = KotlinLogging.INSTANCE.logger(this.type.toString());
    }

    @NotNull
    public final LoggerTypes getType() {
        return this.type;
    }

    @Override
    @NotNull
    public KLogger getLogger() {
        return this.logger;
    }

    @Override
    public boolean isEnabled() {
        return Config.INSTANCE.isEnabledLogger(this.type);
    }

    private final String formatMessage(LoggerLevels level, Function0<? extends Object> msg) {
        return "[" + Thread.currentThread().getName() + "] " + level.name() + " " + this.type + " - " + msg.invoke();
    }

    private final void outPrintLog(Throwable t, Function0<? extends Object> msg, LoggerLevels level) {
        OutPrinter.INSTANCE.printInfo(this.formatMessage(level, msg));
        if (t != null) {
            OutPrinter.INSTANCE.printStacktrace(t);
        }
    }

    @Override
    public void error(@Nullable Throwable t, @NotNull Function0<? extends Object> msg) {
        block2: {
            Throwable throwable;
            Intrinsics.checkNotNullParameter(msg, "msg");
            this.outPrintLog(t, msg, LoggerLevels.ERROR);
            KLogger kLogger = this.getLogger();
            Throwable throwable2 = t;
            if (throwable2 != null) {
                Throwable throwable3;
                Throwable throwable4 = throwable3 = throwable2;
                KLogger kLogger2 = kLogger;
                boolean bl = false;
                boolean bl2 = this.consoleLogExceptions;
                kLogger = kLogger2;
                throwable = bl2 ? throwable3 : null;
            } else {
                throwable = null;
            }
            kLogger.error(throwable, msg);
            Companion.regression(msg, false);
            Object object = t;
            if (object == null || (object = ((Throwable)object).getMessage()) == null) break block2;
            Object it = object;
            boolean bl = false;
            Companion.regression((Function0<? extends Object>)new Function0<Object>((String)it){
                final /* synthetic */ String $it;
                {
                    this.$it = $it;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return this.$it;
                }
            });
        }
    }

    @Override
    public void warn(@Nullable Throwable t, @NotNull Function0<? extends Object> msg) {
        block2: {
            Throwable throwable;
            Intrinsics.checkNotNullParameter(msg, "msg");
            this.outPrintLog(t, msg, LoggerLevels.WARN);
            KLogger kLogger = this.getLogger();
            Throwable throwable2 = t;
            if (throwable2 != null) {
                Throwable throwable3;
                Throwable throwable4 = throwable3 = throwable2;
                KLogger kLogger2 = kLogger;
                boolean bl = false;
                boolean bl2 = this.consoleLogExceptions;
                kLogger = kLogger2;
                throwable = bl2 ? throwable3 : null;
            } else {
                throwable = null;
            }
            kLogger.warn(throwable, msg);
            Companion.regression(msg, false);
            Object object = t;
            if (object == null || (object = ((Throwable)object).getMessage()) == null) break block2;
            Object it = object;
            boolean bl = false;
            Companion.regression((Function0<? extends Object>)new Function0<Object>((String)it){
                final /* synthetic */ String $it;
                {
                    this.$it = $it;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return this.$it;
                }
            });
        }
    }

    @Override
    public void info(@Nullable Throwable t, @NotNull Function0<? extends Object> msg) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter(msg, "msg");
        if (this.getLogger().isInfoEnabled()) {
            this.outPrintLog(t, msg, LoggerLevels.INFO);
        }
        KLogger kLogger = this.getLogger();
        Throwable throwable2 = t;
        if (throwable2 != null) {
            Throwable throwable3;
            Throwable throwable4 = throwable3 = throwable2;
            KLogger kLogger2 = kLogger;
            boolean bl = false;
            boolean bl2 = this.consoleLogExceptions;
            kLogger = kLogger2;
            throwable = bl2 ? throwable3 : null;
        } else {
            throwable = null;
        }
        kLogger.info(throwable, msg);
    }

    @Override
    public void debug(@Nullable Throwable t, @NotNull Function0<? extends Object> msg) {
        Throwable throwable;
        Intrinsics.checkNotNullParameter(msg, "msg");
        if (this.getLogger().isDebugEnabled()) {
            this.outPrintLog(null, msg, LoggerLevels.DEBUG);
        }
        KLogger kLogger = this.getLogger();
        Throwable throwable2 = t;
        if (throwable2 != null) {
            Throwable throwable3;
            Throwable throwable4 = throwable3 = throwable2;
            KLogger kLogger2 = kLogger;
            boolean bl = false;
            boolean bl2 = this.consoleLogExceptions;
            kLogger = kLogger2;
            throwable = bl2 ? throwable3 : null;
        } else {
            throwable = null;
        }
        kLogger.debug(throwable, msg);
    }

    @Override
    public void trace(@NotNull Function0<? extends Object> msg) {
        Intrinsics.checkNotNullParameter(msg, "msg");
        if (this.getLogger().isTraceEnabled()) {
            this.outPrintLog(null, msg, LoggerLevels.TRACE);
        }
        this.getLogger().trace(msg);
    }

    @Override
    public void error(@NotNull Function0<? extends Object> msg) {
        ILogger.DefaultImpls.error((ILogger)this, msg);
    }

    @Override
    public void error(@NotNull String msg) {
        ILogger.DefaultImpls.error((ILogger)this, msg);
    }

    @Override
    public void error(@Nullable Throwable t, @NotNull String msg) {
        ILogger.DefaultImpls.error((ILogger)this, t, msg);
    }

    @Override
    public void warn(@NotNull Function0<? extends Object> msg) {
        ILogger.DefaultImpls.warn(this, msg);
    }

    @Override
    public void info(@NotNull Function0<? extends Object> msg) {
        ILogger.DefaultImpls.info(this, msg);
    }

    @Override
    public void debug(@NotNull Function0<? extends Object> msg) {
        ILogger.DefaultImpls.debug(this, msg);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nJ\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nJ\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0018\u001a\u00020\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u001aJ\u001c\u0010\u0018\u001a\u00020\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0012R\u001d\u0010\u0003\u001a\u0004\u0018\u00010\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Llog/Logger$Companion;", "", "()V", "regressionFile", "Ljava/io/OutputStreamWriter;", "getRegressionFile", "()Ljava/io/OutputStreamWriter;", "regressionFile$delegate", "Lkotlin/Lazy;", "slf4jPrefix", "", "underlyingLogger", "Llog/Logger;", "unitTestingModePropertyName", "always", "", "s", "respectQuiet", "", "alwaysError", "t", "", "alwaysWarn", "devError", "regression", "str", "Lkotlin/Function0;", "toOutFile", "Shared"})
    public static final class Companion {
        private Companion() {
        }

        private final OutputStreamWriter getRegressionFile() {
            Lazy lazy = regressionFile$delegate;
            return (OutputStreamWriter)lazy.getValue();
        }

        public final void always(@NotNull String s, boolean respectQuiet) {
            Intrinsics.checkNotNullParameter(s, "s");
            boolean beQuiet = respectQuiet && (Boolean)Config.INSTANCE.getQuietMode().get() != false;
            OutPrinter.INSTANCE.print(s, false, false, !beQuiet);
            underlyingLogger.info((Function0<? extends Object>)new Function0<Object>(s){
                final /* synthetic */ String $s;
                {
                    this.$s = $s;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return this.$s;
                }
            });
        }

        public final void alwaysError(@NotNull String s) {
            Intrinsics.checkNotNullParameter(s, "s");
            this.alwaysError(s, null);
        }

        public final void alwaysError(@NotNull String s, @Nullable Throwable t) {
            Intrinsics.checkNotNullParameter(s, "s");
            OutPrinter.INSTANCE.printErrorToScreen(s);
            underlyingLogger.error(t, s);
        }

        public final void devError(@NotNull Throwable t) {
            Intrinsics.checkNotNullParameter(t, "t");
            if (DevMode.INSTANCE.isDevMode()) {
                Companion.alwaysError("Exception details:", t);
            }
        }

        public final void alwaysWarn(@NotNull String s, @Nullable Throwable t) {
            Intrinsics.checkNotNullParameter(s, "s");
            OutPrinter.INSTANCE.printWarningToScreen(s);
            underlyingLogger.warn(t, (Function0<? extends Object>)new Function0<Object>(s){
                final /* synthetic */ String $s;
                {
                    this.$s = $s;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return this.$s;
                }
            });
        }

        public final void alwaysWarn(@NotNull String s) {
            Intrinsics.checkNotNullParameter(s, "s");
            this.alwaysWarn(s, null);
        }

        public final void regression(@NotNull Function0<? extends Object> str2) {
            Intrinsics.checkNotNullParameter(str2, "str");
            this.regression(str2, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void regression(@NotNull Function0<? extends Object> str2, boolean toOutFile) {
            Intrinsics.checkNotNullParameter(str2, "str");
            Companion companion = this;
            synchronized (companion) {
                boolean doRegressionFileOutput;
                boolean bl = false;
                String logMsg = "";
                boolean bl2 = doRegressionFileOutput = (Boolean)Config.INSTANCE.getRegressionTest().get() != false && ArtifactManagerFactory.INSTANCE.isEnabled();
                if (toOutFile || doRegressionFileOutput) {
                    logMsg = str2.invoke().toString();
                }
                if (toOutFile) {
                    OutPrinter.INSTANCE.print(logMsg, false, false, false);
                }
                if (doRegressionFileOutput) {
                    Appendable appendable;
                    OutputStreamWriter outputStreamWriter = Companion.getRegressionFile();
                    if (outputStreamWriter != null) {
                        Appendable appendable2 = ((Appendable)outputStreamWriter).append(logMsg);
                        Intrinsics.checkNotNullExpressionValue(appendable2, "append(value)");
                        Appendable appendable3 = appendable2.append('\n');
                        appendable = appendable3;
                        Intrinsics.checkNotNullExpressionValue(appendable3, "append('\\n')");
                    } else {
                        appendable = null;
                    }
                    OutputStreamWriter outputStreamWriter2 = Companion.getRegressionFile();
                    if (outputStreamWriter2 != null) {
                        outputStreamWriter2.flush();
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

