# -*- coding: utf-8 -*-

################################################################################
## Generated by alexpdev
##
## PySide6
##
## THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
## IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
## FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
## AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
## LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
## OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
## SOFTWARE.
################################################################################
import json
import sys

try:
    from PySide6.QtCore import *
    from PySide6.QtGui import *
    from PySide6.QtWidgets import *
    from multitool.wordle import decypher_input, filter_word, filter_words


    class Solver:
        def __init__(self, l):
            self.word_length = l
            self.words = [i for i in json.load(open("Words_Length.json")) if len(i) == l]
            self.hints = set()
            self.wrong = set()
            self.correct = ["" for _ in range(l)]
            self.pos = {i: "" for i in range(l)}

        def decypher(self, guess, result):
            decypher_input(self.hints, self.wrong, self.correct, self.pos, guess, result)

        def filter_words(self):
            for word in self.words[::-1]:
                if not filter_word(
                    word,
                    self.hints,
                    self.pos,
                    self.wrong,
                    self.correct,
                ):
                    self.words.remove(word)
            return self.words


    class Window(QMainWindow):

        style = """
        QWidget {
            background-color: #333;
            color: white;
            font-size: 11pt;
        }
        QListWidget {
            background-color: #124;
            color: white;
        }
        QPushButton {
            border: 1px solid white;
            background-color: #242;
            color: white;
            margin-top: 5px;
            padding: 3px;
        }
        QSpinBox {
            background-color: #124;
            color: white;
            border: #999997 1px solid;
        }
        QToolButton {
            border: 1px solid white;
            background-color: #242;
            color: white;
        }
        QLineEdit {
            background-color: #368;
            color: white;
            border: #aaaaaa solid 1px;
        }
        """

        def __init__(self, parent=None):
            super().__init__(parent=parent)
            self.resize(354, 600)
            self.setStyleSheet(self.style)
            self.word_length = 5
            self.solver = Solver(self.word_length)
            self.central = QWidget(parent=self)
            self.setWindowTitle("Wordle Helper")
            self.setWindowIcon(QIcon("./assets/NYT-Wordle-Icon-32.png"))
            self.setCentralWidget(self.central)
            self.layout = QVBoxLayout()
            self.central.setLayout(self.layout)
            self.listwidget = QListWidget(parent=self)
            self.toolbutton = QToolButton(parent=self)
            self.toolbutton.setText("Start")
            self.spinBox = SpinBox(parent=self)
            self.word_length_label = QLabel("Word Length")
            self.button = QPushButton("Submit")
            self.hlayout1 = QHBoxLayout()
            self.hlayout1.addWidget(self.word_length_label)
            self.hlayout1.addWidget(self.spinBox)
            self.layout.addLayout(self.hlayout1)
            self.layout.addWidget(self.listwidget)
            self.hlayout1.addWidget(self.toolbutton)
            self.hlayout2 = QHBoxLayout()
            self.char_edits = []
            for i in range(self.word_length):
                char_edit = CharEdit(parent=self, position=i)
                char_edit.setMaxLength(1)
                self.char_edits.append(char_edit)
                self.hlayout2.addWidget(char_edit)
            self.layout.addLayout(self.hlayout2)
            self.layout.addWidget(self.button)
            self.menubar = QMenuBar(parent=self)
            self.menubar.setGeometry(QRect(0, 0, 354, 22))
            self.setMenuBar(self.menubar)
            self.statusbar = QStatusBar(parent=self)
            self.setStatusBar(self.statusbar)
            self.menubar.setObjectName("menubar")
            self.setObjectName("MainWindow")
            self.central.setObjectName("centralwidget")
            self.layout.setObjectName("verticalLayout")
            self.word_length_label.setObjectName("wordlengthlable")
            self.hlayout1.setObjectName("horizontalLayout")
            self.spinBox.setObjectName("spinBox")
            self.listwidget.setObjectName("listWidget")
            self.hlayout2.setObjectName("hlayout2")
            self.button.setObjectName("pushButton")
            self.statusbar.setObjectName("statusbar")
            self.toolbutton.pressed.connect(self.start_wordle)
            self.button.pressed.connect(self.filter_results)

        def start_wordle(self):
            starters = filter_words(self.word_length)
            self.solver = Solver(self.word_length)
            self.listwidget.addItems(starters)

        def filter_results(self):
            items = self.listwidget.selectedItems()
            if len(items) != 1:
                return
            guess = items[0].text()
            result = ""
            for inp in self.char_edits:
                t = inp.text()
                if not t or t == " ":
                    return
                result += t.upper()
            self.solver.decypher(guess, result)
            words = self.solver.filter_words()
            self.listwidget.clear()
            self.listwidget.addItems(words)
            for box in self.char_edits:
                box.clear()


    class SpinBox(QSpinBox):
        def __init__(self, parent=None):
            super().__init__(parent=parent)
            self.window = parent
            self.setMaximum(15)
            self.setMinimum(3)
            self.setValue(self.window.word_length)
            self.valueChanged.connect(self.edit_inputs)

        def edit_inputs(self, val):
            if val < self.window.word_length:
                print(self.window.word_length)
                diff = self.window.word_length - val
                while diff > 0:
                    diff -= 1
                    print(diff, val, self.window.word_length)
                    widget = self.window.char_edits[-1]
                    self.window.char_edits = self.window.char_edits[:-1]
                    self.window.hlayout2.removeWidget(widget)
                    widget.hide()
                    del widget
                    self.window.word_length = len(self.window.char_edits)
            else:
                diff = val - self.window.word_length
                while diff > 0:
                    lineedit = CharEdit(self.window)
                    self.window.char_edits.append(lineedit)
                    self.window.hlayout2.addWidget(lineedit)
                    self.window.word_length += 1
                    diff -= 1
            self.window.solver = Solver(self.window.word_length)


    class CharEdit(QLineEdit):
        def __init__(self, parent=None, position=0):
            super().__init__(parent=parent)
            self.window = parent
            self.position = position
            self.setMaxLength(1)
            self.textEdited.connect(self.select_next)

        def grab_focus(self, i):
            if self.position == i:
                self.home(0)
                self.selectAll()

        def select_next(self, text):
            if text == "":
                return
            self.focusNextChild()


    def start_gui():
        app = QApplication(sys.argv)
        window = Window()
        window.show()
        app.exec()

except ImportError:

    def start_gui():
        print("You must install Pyside6 in order to run the Wordle GUI")
        return
