import datetime
from importlib.metadata import version

from jinja2_simple_tags import StandaloneTag


class VersionTag(StandaloneTag):
    tags = {"version_info"}

    def render(self):
        format = "%Y-%m-%d %H:%M:%S"
        time = datetime.datetime.now().strftime(format)
        return f"Generated by platform-helper {version('dbt-platform-helper')} / {time}"
