"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LoadBalancerTarget = void 0;
/**
 * Use an ELBv2 as an alias record target
 */
class LoadBalancerTarget {
    constructor(loadBalancer) {
        this.loadBalancer = loadBalancer;
    }
    bind(_record) {
        return {
            hostedZoneId: this.loadBalancer.loadBalancerCanonicalHostedZoneId,
            dnsName: `dualstack.${this.loadBalancer.loadBalancerDnsName}`,
        };
    }
}
exports.LoadBalancerTarget = LoadBalancerTarget;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibG9hZC1iYWxhbmNlci10YXJnZXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJsb2FkLWJhbGFuY2VyLXRhcmdldC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFHQTs7R0FFRztBQUNILE1BQWEsa0JBQWtCO0lBQzdCLFlBQTZCLFlBQW1DO1FBQW5DLGlCQUFZLEdBQVosWUFBWSxDQUF1QjtJQUNoRSxDQUFDO0lBRU0sSUFBSSxDQUFDLE9BQTJCO1FBQ3JDLE9BQU87WUFDTCxZQUFZLEVBQUUsSUFBSSxDQUFDLFlBQVksQ0FBQyxpQ0FBaUM7WUFDakUsT0FBTyxFQUFFLGFBQWEsSUFBSSxDQUFDLFlBQVksQ0FBQyxtQkFBbUIsRUFBRTtTQUM5RCxDQUFDO0lBQ0osQ0FBQztDQUNGO0FBVkQsZ0RBVUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBlbGJ2MiBmcm9tICdAYXdzLWNkay9hd3MtZWxhc3RpY2xvYWRiYWxhbmNpbmd2Mic7XG5pbXBvcnQgKiBhcyByb3V0ZTUzIGZyb20gJ0Bhd3MtY2RrL2F3cy1yb3V0ZTUzJztcblxuLyoqXG4gKiBVc2UgYW4gRUxCdjIgYXMgYW4gYWxpYXMgcmVjb3JkIHRhcmdldFxuICovXG5leHBvcnQgY2xhc3MgTG9hZEJhbGFuY2VyVGFyZ2V0IGltcGxlbWVudHMgcm91dGU1My5JQWxpYXNSZWNvcmRUYXJnZXQge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IGxvYWRCYWxhbmNlcjogZWxidjIuSUxvYWRCYWxhbmNlclYyKSB7XG4gIH1cblxuICBwdWJsaWMgYmluZChfcmVjb3JkOiByb3V0ZTUzLklSZWNvcmRTZXQpOiByb3V0ZTUzLkFsaWFzUmVjb3JkVGFyZ2V0Q29uZmlnIHtcbiAgICByZXR1cm4ge1xuICAgICAgaG9zdGVkWm9uZUlkOiB0aGlzLmxvYWRCYWxhbmNlci5sb2FkQmFsYW5jZXJDYW5vbmljYWxIb3N0ZWRab25lSWQsXG4gICAgICBkbnNOYW1lOiBgZHVhbHN0YWNrLiR7dGhpcy5sb2FkQmFsYW5jZXIubG9hZEJhbGFuY2VyRG5zTmFtZX1gLFxuICAgIH07XG4gIH1cbn1cbiJdfQ==