from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkIOExport

class WebGLObjectTypes(int): ...

VTK_ONLYCAMERA:int
VTK_ONLYWIDGET:int
VTK_PARSEALL:int
wLINES:'WebGLObjectTypes'
wPOINTS:'WebGLObjectTypes'
wTRIANGLES:'WebGLObjectTypes'

class vtkPVWebGLExporter(vtkmodules.vtkIOExport.vtkExporter):
    def GetFileName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkPVWebGLExporter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkPVWebGLExporter: ...
    def SetFileName(self, _arg:str) -> None: ...

class vtkWebGLDataSet(vtkmodules.vtkCommonCore.vtkObject):
    def GenerateBinaryData(self) -> None: ...
    def GetBinaryData(self) -> Pointer: ...
    def GetBinarySize(self) -> int: ...
    def GetMD5(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def HasChanged(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkWebGLDataSet: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkWebGLDataSet: ...
    def SetColors(self, c:[int, ...]) -> None: ...
    def SetIndexes(self, i:[int, ...], size:int) -> None: ...
    def SetMatrix(self, m:[float, ...]) -> None: ...
    def SetNormals(self, n:[float, ...]) -> None: ...
    def SetPoints(self, p:[float, ...], size:int) -> None: ...
    def SetTCoords(self, t:[float, ...]) -> None: ...
    def SetType(self, t:WebGLObjectTypes) -> None: ...
    def SetVertices(self, v:[float, ...], size:int) -> None: ...

class vtkWebGLExporter(vtkmodules.vtkCommonCore.vtkObject):
    @staticmethod
    def ComputeMD5(content:(int, ...), size:int, hash:str) -> None: ...
    def GenerateMetadata(self) -> str: ...
    def GetId(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfObjects(self) -> int: ...
    def GetWebGLObject(self, index:int) -> vtkWebGLObject: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkWebGLExporter: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkWebGLExporter: ...
    def SetCenterOfRotation(self, a1:float, a2:float, a3:float) -> None: ...
    @overload
    def SetMaxAllowedSize(self, mesh:int, lines:int) -> None: ...
    @overload
    def SetMaxAllowedSize(self, size:int) -> None: ...
    def exportStaticScene(self, renderers:vtkRendererCollection, width:int, height:int, path:str) -> None: ...
    def hasChanged(self) -> bool: ...
    def parseScene(self, renderers:vtkRendererCollection, viewId:str, parseType:int) -> None: ...

class vtkWebGLObject(vtkmodules.vtkCommonCore.vtkObject):
    def GenerateBinaryData(self) -> None: ...
    @overload
    def GetBinaryData(self, part:int) -> Pointer: ...
    @overload
    def GetBinaryData(self, part:int, buffer:vtkUnsignedCharArray) -> None: ...
    def GetBinarySize(self, part:int) -> int: ...
    def GetId(self) -> str: ...
    def GetLayer(self) -> int: ...
    def GetMD5(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfParts(self) -> int: ...
    def GetRendererId(self) -> int: ...
    def HasChanged(self) -> bool: ...
    def HasTransparency(self) -> bool: ...
    def InteractAtServer(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkWebGLObject: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkWebGLObject: ...
    def SetHasTransparency(self, t:bool) -> None: ...
    def SetId(self, i:str) -> None: ...
    def SetInteractAtServer(self, i:bool) -> None: ...
    def SetIsWidget(self, w:bool) -> None: ...
    def SetLayer(self, l:int) -> None: ...
    def SetRendererId(self, i:int) -> None: ...
    def SetTransformationMatrix(self, m:vtkMatrix4x4) -> None: ...
    def SetType(self, t:WebGLObjectTypes) -> None: ...
    def SetVisibility(self, vis:bool) -> None: ...
    def SetWireframeMode(self, wireframe:bool) -> None: ...
    def isVisible(self) -> bool: ...
    def isWidget(self) -> bool: ...
    def isWireframeMode(self) -> bool: ...

class vtkWebGLPolyData(vtkWebGLObject):
    def GenerateBinaryData(self) -> None: ...
    def GetBinaryData(self, part:int) -> Pointer: ...
    def GetBinarySize(self, part:int) -> int: ...
    def GetColorsFromPointData(self, color:[int, ...], pointdata:vtkPointData, polydata:vtkPolyData, actor:vtkActor) -> None: ...
    def GetColorsFromPolyData(self, color:[int, ...], polydata:vtkPolyData, actor:vtkActor) -> None: ...
    def GetLines(self, polydata:vtkTriangleFilter, actor:vtkActor, lineMaxSize:int) -> None: ...
    def GetLinesFromPolygon(self, mapper:vtkMapper, actor:vtkActor, lineMaxSize:int, edgeColor:[float, ...]) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfParts(self) -> int: ...
    def GetPoints(self, polydata:vtkTriangleFilter, actor:vtkActor, maxSize:int) -> None: ...
    def GetPolygonsFromCellData(self, polydata:vtkTriangleFilter, actor:vtkActor, maxSize:int) -> None: ...
    def GetPolygonsFromPointData(self, polydata:vtkTriangleFilter, actor:vtkActor, maxSize:int) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkWebGLPolyData: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkWebGLPolyData: ...
    def SetLine(self, _points:[float, ...], _numberOfPoints:int, _index:[int, ...], _numberOfIndex:int, _colors:[int, ...], maxSize:int) -> None: ...
    def SetMesh(self, _vertices:[float, ...], _numberOfVertices:int, _index:[int, ...], _numberOfIndexes:int, _normals:[float, ...], _colors:[int, ...], _tcoords:[float, ...], maxSize:int) -> None: ...
    def SetPoints(self, points:[float, ...], numberOfPoints:int, colors:[int, ...], maxSize:int) -> None: ...
    def SetTransformationMatrix(self, m:vtkMatrix4x4) -> None: ...

class vtkWebGLWidget(vtkWebGLObject):
    def GenerateBinaryData(self) -> None: ...
    def GetBinaryData(self, part:int) -> Pointer: ...
    def GetBinarySize(self, part:int) -> int: ...
    def GetDataFromColorMap(self, actor:vtkActor2D) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetNumberOfParts(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkWebGLWidget: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkWebGLWidget: ...

