# generated by datamodel-codegen:
#   filename:  core/dataspec.json
#   timestamp: 2024-05-17T07:49:31+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from oceanum.eidos._basemodel import EidosModel
from pydantic import ConfigDict, Field, RootModel, constr

from .. import features, oceanql


class EidosDataSpecification(RootModel[Any]):
    root: Any = Field(..., title='EIDOS data specification')
    """
    EIDOS data specification
    """


class DataType(str, Enum):
    oceanumDatamesh = 'oceanumDatamesh'
    inlineDataset = 'inlineDataset'
    featureCollection = 'featureCollection'


class InlineDataset(EidosModel):
    """
    Inline dataset
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    name: Optional[str] = None
    attrs: Optional[Dict[str, Any]] = None
    coords: Dict[str, Any]
    data_vars: Dict[str, Any]
    dims: Dict[str, Any]
    coordkeys: Dict[str, Any]


class Transform(EidosModel):
    """
    Specification for data transform.
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    id: constr(pattern=r'^[A-Za-z0-9_]*$')
    name: Optional[str] = None
    """
    Human readable name of this transform instance
    """
    libraries: Optional[Dict[str, Any]] = None
    """
    Libraries to add as key:<Library URL>
    """
    inputs: Optional[List[constr(pattern=r'^[A-Za-z0-9_]*$')]] = None
    """
    List of input data sources
    """
    code: Optional[str] = Field(None, title='Transform code')
    """
    Transform code as body of function
    """


class FeatureCollection(EidosModel):
    """
    Feature collection
    """

    id: Optional[str] = None
    features: List[features.Feature]
    coordkeys: Optional[Dict[str, Any]] = None


class Datasource(EidosModel):
    """
    Specification for EIDOS data source
    """

    id: constr(pattern=r'^[A-Za-z0-9_]+$')
    """
    Unique ID of the datasource
    """
    dataType: DataType
    dataSpec: Union[InlineDataset, FeatureCollection, oceanql.OceanQuery]
