# generated by datamodel-codegen:
#   filename:  core/node.json
#   timestamp: 2024-05-17T07:49:31+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, List, Optional, Union

from oceanum.eidos._basemodel import EidosModel
from pydantic import ConfigDict, Field, RootModel

from ..viewnodes import document, plot, world


class EidosNodeSpecification(RootModel[Any]):
    root: Any = Field(..., title='EIDOS node specification')
    """
    EIDOS node specifications
    """


class NodeType(str, Enum):
    world = 'world'
    plot = 'plot'
    document = 'document'
    grid = 'grid'


class GridLayout(EidosModel):
    """
    Positioning of node in grid layout
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    w: int
    """
    Width in columns
    """
    h: int
    """
    height in rows
    """
    x: int
    """
    Origin in columns
    """
    y: int
    """
    Origin in rows from top
    """


class TabLayout(EidosModel):
    """
    Configuration of nodes in tab layout
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    label: str
    """
    Tab title label
    """
    icon: Optional[str] = None
    """
    Tab title icon
    """


class GridSize(EidosModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    cols: int
    """
    Number of columns in grid
    """
    rows: int
    """
    Number of rows in grid
    """


class Node(EidosModel):
    id: str
    """
    Unique ID of the node
    """
    nodeType: NodeType
    nodeSpec: Union[
        world.WorldView, plot.PlotView, document.DocumentView, GridNode, TabNode
    ]
    """
    Spec for node (worldview, plotable, document or grid/modal)
    """
    gridLayout: Optional[GridLayout] = None
    """
    Positioning of node in grid layout
    """
    tabLayout: Optional[TabLayout] = None
    """
    Configuration of nodes in tab layout
    """


class Children(RootModel[List[Node]]):
    root: List[Node]


class GridNode(EidosModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    gridSize: GridSize
    children: List[Node]


class TabNode(EidosModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    activeTab: Optional[str] = None
    children: List[Node]


class ModalNode(Node):
    """
    Spec for modal node (worldview, plotable, document or grid)
    """

    trigger: str
    """
    event ID that triggers modal
    """
    height: Optional[int] = 100
    """
    Height of modal dialog (pixels)
    """
    width: Optional[Union[int, str]] = None
    title: Optional[str] = None


Node.model_rebuild()
ModalNode.model_rebuild()
