# generated by datamodel-codegen:
#   filename:  core/root.json
#   timestamp: 2024-05-17T07:49:31+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from oceanum.eidos._basemodel import EidosModel
from pydantic import ConfigDict, Field, constr

from . import dataspec, node


class Logo(EidosModel):
    light: Optional[str] = None
    dark: Optional[str] = None


class ColorScheme(str, Enum):
    """
    Color scheme for the view
    """

    light = 'light'
    dark = 'dark'


class Theme(EidosModel):
    colorScheme: Optional[ColorScheme] = 'light'
    """
    Color scheme for the view
    """


class EidosSpecification(EidosModel):
    """
    Top level specification for Oceanum Dataview display and interaction
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    id: constr(pattern=r'^[a-z0-9-_]+$')
    """
    Unique id of the specification
    """
    name: str
    """
    Human readable name of the specification
    """
    description: Optional[str] = ''
    """
    Description of the specification
    """
    title: Optional[str] = None
    """
    Title displayed at top of screen
    """
    logo: Optional[Logo] = None
    theme: Optional[Theme] = None
    data: List[dataspec.Datasource] = Field(..., title='Data')
    transforms: Optional[List[dataspec.Transform]] = Field(
        None, title='Data Transforms'
    )
    rootNode: node.Node
    modalNodes: Optional[List[node.ModalNode]] = None


EidosSpecification.model_rebuild()
