# generated by datamodel-codegen:
#   filename:  core/state.json
#   timestamp: 2024-05-17T07:49:31+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional

from oceanum.eidos._basemodel import EidosModel
from pydantic import Field, RootModel


class EidosState(RootModel[Any]):
    root: Any = Field(..., title='Eidos state')


class CurrentTime(RootModel[str]):
    root: str
    """
    Time of for current view
    """


class CurrentContext(EidosModel):
    """
    Context of for current view
    """


class TimeControl(EidosModel):
    global_: Optional[bool] = Field(True, alias='global', title='Set global time')
    """
    Sets the global time select
    """
    range: Optional[List[str]] = Field(None, max_length=2, min_length=2)
    """
    Maximum time range of time contorl
    """
    increment: Optional[float] = Field(None, title='TIme selector increments')
    """
    Size in seconds of the time selector increments
    """


class Mode(str, Enum):
    nearest = 'nearest'
    exact = 'exact'
    range = 'range'


class Aggregate(str, Enum):
    """
    Aggregation method for time range
    """

    last = 'last'
    first = 'first'
    sum = 'sum'
    mean = 'mean'
    max = 'max'
    min = 'min'


class TimeSelect(EidosModel):
    mode: Mode
    toleration: Optional[str] = None
    aggregate: Optional[Aggregate] = Field('last', title='Time aggregation')
    """
    Aggregation method for time range
    """
    groupby: Optional[str] = None
    """
    Data field to group by
    """


class ContextControl(RootModel[List[Dict[str, Any]]]):
    """
    Context selector for current view
    """

    root: List[Dict[str, Any]]
    """
    Context selector for current view
    """
