# generated by datamodel-codegen:
#   filename:  features.json
#   timestamp: 2024-05-17T07:49:31+00:00

from __future__ import annotations

from enum import Enum
from typing import Any, Dict, List, Optional, Union

from oceanum.eidos._basemodel import EidosModel
from pydantic import Field, RootModel
from typing_extensions import Literal


class Features(EidosModel):
    """
    GeoJSON schemas
    """


class Point(EidosModel):
    """
    Point Model
    """

    coordinates: List[Union[float, int]] = Field(..., title='Coordinates')
    type: Literal['Point'] = Field('Point', title='Type')


class MultiPoint(EidosModel):
    """
    MultiPoint Model
    """

    coordinates: List[List[Union[float, int]]] = Field(
        ..., min_length=1, title='Coordinates'
    )
    type: Literal['MultiPoint'] = Field('MultiPoint', title='Type')


class LineString(EidosModel):
    """
    LineString Model
    """

    coordinates: List[List[Union[float, int]]] = Field(
        ..., min_length=2, title='Coordinates'
    )
    type: Literal['LineString'] = Field('LineString', title='Type')


class Coordinate(RootModel[List[Any]]):
    root: List[Any]


class MultiLineString(EidosModel):
    """
    MultiLineString Model
    """

    coordinates: List[Coordinate] = Field(..., min_length=1, title='Coordinates')
    type: Literal['MultiLineString'] = Field('MultiLineString', title='Type')


class Polygon(EidosModel):
    """
    Polygon Model
    """

    coordinates: List[Coordinate] = Field(..., min_length=1, title='Coordinates')
    type: Literal['Polygon'] = Field('Polygon', title='Type')


class MultiPolygon(EidosModel):
    """
    MultiPolygon Model
    """

    coordinates: List[Coordinate] = Field(..., min_length=1, title='Coordinates')
    type: Literal['MultiPolygon'] = Field('MultiPolygon', title='Type')


class GeometryCollection(EidosModel):
    """
    GeometryCollection Model
    """

    type: Literal['GeometryCollection'] = Field('GeometryCollection', title='Type')
    geometries: List[
        Union[Point, MultiPoint, LineString, MultiLineString, Polygon, MultiPolygon]
    ] = Field(..., title='Geometries')


class Type(str, Enum):
    Feature = 'Feature'


class Feature(EidosModel):
    """
    Feature Model
    """

    type: Optional[Type] = Field(None, title='Type')
    geometry: Optional[
        Union[
            Point,
            MultiPoint,
            LineString,
            MultiLineString,
            Polygon,
            MultiPolygon,
            GeometryCollection,
        ]
    ] = Field(None, title='Geometry')
    properties: Optional[Dict[str, Any]] = Field(None, title='Properties')
    id: Optional[str] = Field(None, title='Id')
    bbox: Optional[List[Union[float, int]]] = Field(None, title='Bbox')


class Type1(str, Enum):
    FeatureCollection = 'FeatureCollection'


class FeatureCollection(EidosModel):
    name: Optional[str] = None
    type: Type1
    features: List[Feature] = Field(..., title='Feature array')
