# generated by datamodel-codegen:
#   filename:  worldlayers/label.json
#   timestamp: 2024-05-17T07:49:31+00:00

from __future__ import annotations

from typing import Optional, Union

from oceanum.eidos._basemodel import EidosModel
from pydantic import ConfigDict

from ..core import state
from ..viewnodes import world
from ..viewnodes.world import LayerSpec


class Style(EidosModel):
    lineColor: Optional[str] = 'rgba(255, 255, 255, 255)'
    """
    Color of the lines
    """
    backgroundColor: Optional[Union[str, world.Colormap]] = None
    """
    Background color of the label
    """
    fontColor: Optional[Union[str, world.Colormap]] = None
    """
    Font color of the label
    """
    lineWidth: Optional[int] = 1
    """
    Width of the lines
    """
    padding: Optional[int] = 2
    """
    Padding around the label
    """
    fontSize: Optional[int] = 14
    """
    Font size of the label
    """
    fontFamily: Optional[str] = 'Monaco, monospace'
    """
    Font family of the label
    """
    fontWeight: Optional[str] = 'normal'
    """
    Font weight of the label
    """
    iconURL: Optional[str] = ''
    """
    URL of icon to prepend to label
    """


class LabelLayerSpec(LayerSpec):
    """
    Specification for Label overlay layer
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    hoverInfo: Optional[world.HoverInfo] = None
    timeSelect: Optional[state.TimeSelect] = None
    geometry: Optional[world.Geometry] = None
    labelTemplate: str
    """
    Label format string as Handlebars template. See https://handlebarsjs.com/guide/#simple-expressions
    """
    colormap: Optional[world.Colormap] = None
    style: Optional[Style] = None
    numberOfLabels: Optional[int] = 20
    """
    Number of labels to show
    """
    lineLength: Optional[int] = 1
    """
    Length of the anchor line
    """
    labelAngle: Optional[int] = 40
    """
    Angle of the label anchor
    """
