# generated by datamodel-codegen:
#   filename:  worldlayers/scenegraph.json
#   timestamp: 2024-05-17T07:49:31+00:00

from __future__ import annotations

from typing import Any, Dict, Optional

from oceanum.eidos._basemodel import EidosModel
from pydantic import ConfigDict, Field, RootModel

from .. import features
from ..core import state
from ..viewnodes import world
from ..viewnodes.world import LayerSpec


class Gltf(EidosModel):
    """
    name or URLs of GLTF model keyed to data property
    """

    model_config = ConfigDict(
        extra='allow',
    )
    field_default: str = Field(..., alias='_default')


class Scenegraph(EidosModel):
    key: Optional[str] = Field(None, title='Scenegraph key')
    """
    Data field to use as key for scenegraph model
    """
    gltf: Gltf = Field(..., title='GLTF models')
    """
    name or URLs of GLTF model keyed to data property
    """


class ScenegraphLayerDatakeys(RootModel[Any]):
    root: Any


class ScenegraphLayerSpec(LayerSpec):
    """
    Specification for Scenegraph layer
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    dataKeys: ScenegraphLayerDatakeys
    hoverInfo: Optional[world.HoverInfo] = None
    timeSelect: Optional[state.TimeSelect] = None
    geometry: Optional[features.Feature] = None
    colormap: Optional[world.Colormap] = None
    scenegraph: Optional[Scenegraph] = None
    style: Optional[Dict[str, Any]] = None
