# generated by datamodel-codegen:
#   filename:  worldlayers/sea_surface.json
#   timestamp: 2024-05-17T07:49:31+00:00

from __future__ import annotations

from typing import Any, List, Optional

from pydantic import ConfigDict, Field, RootModel

from ..viewnodes.world import LayerSpec


class SeaSurfaceLayerDatakeys(RootModel[Any]):
    root: Any


class Floater(RootModel[Any]):
    root: Any


class SeaSurfaceLayerSpec(LayerSpec):
    """
    Specification for Sea surface layer
    """

    model_config = ConfigDict(
        extra='forbid',
    )
    dataKeys: SeaSurfaceLayerDatakeys
    minzoom: Optional[float] = Field(13, title='Minimum zoom')
    """
    Minimum zoom to show sea surface
    """
    zscale: Optional[float] = Field(1, title='Vertical scale')
    """
    Vertical scale exageration
    """
    elevation: Optional[float] = Field(0, title='Sea level elevation')
    """
    Elevation of mean sea level in metres
    """
    floaters: Optional[List[Floater]] = Field([], title='Floaters')
    """
    List of floating objects
    """
