export declare class PipelineService {
    /**
     * Returns a list of external runtime configurations available as
     * `runtimes metadata`. This is used to submit the pipeline to be
     * executed on these runtimes.
     */
    static getRuntimes(): Promise<any>;
    /**
     * Return a list of configured docker images that are used as runtimes environments
     * to run the pipeline nodes.
     */
    static getRuntimeImages(): Promise<any>;
    /**
     * Submit the pipeline to be executed on an external runtime (e.g. Kbeflow Pipelines)
     *
     * @param pipeline
     * @param runtime_config
     */
    static submitPipeline(pipeline: any, runtime_config: string): Promise<any>;
    /**
     * Export a pipeline to different formats (e.g. DSL, YAML, etc). These formats
     * are understood by a given runtime.
     *
     * @param pipeline
     * @param pipeline_export_format
     * @param pipeline_export_path
     * @param overwrite
     */
    static exportPipeline(pipeline: any, pipeline_export_format: string, pipeline_export_path: string, overwrite: boolean): Promise<any>;
    /**
     * Verify if the given pipeline is "current" by looking on it's version, and perform
     * any conversion if needed.
     *
     * @param pipelineDefinition
     */
    static convertPipeline(pipelineDefinition: any): any;
    private static convertPipelineV0toV1;
}
