import { ISubmitNotebookOptions } from './SubmitNotebook';
/**
 * A utilities class for static functions.
 */
export default class Utils {
    static getUUID(): any;
    /**
     * Utility to create a one node pipeline to submit a single Notebook as a pipeline
     */
    static generateNotebookPipeline(filename: string, options: ISubmitNotebookOptions): any;
    /**
     * Read the version of a Pipeline. If no version is found return 0
     */
    static getPipelineVersion(pipelineDefinition: any): number;
    /**
     * Read an application specific field from the pipeline definition
     * (e.g. pipelines[0][app_data][fieldName])
     */
    static getPipelineAppdataField(node: any, fieldName: string): string;
    /**
     * Check if an application specific field from the pipeline defintion exists
     * (e.g. pipelines[0][app_data][fieldName])
     */
    static hasPipelineAppdataField(node: any, fieldName: string): boolean;
    /**
     * Delete an application specific field from the pipeline definition
     * (e.g. pipelines[0][app_data][fieldName])
     */
    static deletePipelineAppdataField(node: any, fieldName: string): void;
    /**
     * Rename an application specific field from the pepileine definition if it exists by
     * by copying the field value to the new field name and then deleting the previously
     * existing field
     */
    static renamePipelineAppdataField(node: any, currentFieldName: string, newFieldName: string): void;
}
