import '../style/index.css';
import { ReactWidget } from '@jupyterlab/apputils';
import { IDocumentManager } from '@jupyterlab/docmanager';
import { IRenderMimeRegistry } from '@jupyterlab/rendermime';
import { Message } from '@lumino/messaging';
import { Signal } from '@lumino/signaling';
import { Widget } from '@lumino/widgets';
import React from 'react';
import { CodeSnippetService, ICodeSnippet } from './CodeSnippetService';
/**
 * A widget for Code Snippets.
 */
export declare class CodeSnippetWidget extends ReactWidget {
    codeSnippetManager: CodeSnippetService;
    renderCodeSnippetsSignal: Signal<this, ICodeSnippet[]>;
    getCurrentWidget: () => Widget;
    constructor(getCurrentWidget: () => Widget);
    fetchData(): Promise<ICodeSnippet[]>;
    onAfterShow(msg: Message): void;
    render(): React.ReactElement;
}
/**
 * A namespace for CodeSnippet statics.
 */
export declare namespace CodeSnippetWidget {
    /**
     * Interface describing table of contents widget options.
     */
    interface IOptions {
        /**
         * Application document manager.
         */
        docmanager: IDocumentManager;
        /**
         * Application rendered MIME type.
         */
        rendermime: IRenderMimeRegistry;
    }
}
