/*
 * Copyright 2018-2020 IBM Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
import { FrontendServices } from '@elyra/application';
export class CodeSnippetService {
    async findAll() {
        const codeSnippetsResponse = await FrontendServices.getMetadata('code-snippets');
        const allCodeSnippets = [];
        for (const codeSnippetKey in codeSnippetsResponse) {
            const jsonCodeSnippet = codeSnippetsResponse[codeSnippetKey];
            const codeSnippet = {
                name: jsonCodeSnippet.name,
                displayName: jsonCodeSnippet.display_name,
                description: jsonCodeSnippet.metadata.description,
                language: jsonCodeSnippet.metadata.language,
                code: jsonCodeSnippet.metadata.code
            };
            allCodeSnippets.push(codeSnippet);
        }
        return allCodeSnippets;
    }
    // TODO: Test this function
    async findByLanguage(language) {
        const allCodeSnippets = await this.findAll();
        const codeSnippetsByLanguage = [];
        for (const codeSnippet of allCodeSnippets) {
            if (codeSnippet.language === language) {
                codeSnippetsByLanguage.push(codeSnippet);
            }
        }
        return codeSnippetsByLanguage;
    }
}
//# sourceMappingURL=CodeSnippetService.js.map