import * as React from 'react';
import { ISettingRegistry } from '@jupyterlab/settingregistry';
import { IRenderMimeRegistry } from '@jupyterlab/rendermime';
import { GitExtension } from '../model';
import { Git } from '../tokens';
/** Interface for GitPanel component state */
export interface IGitSessionNodeState {
    branches: Git.IBranch[];
    currentBranch: string;
    files: Git.IStatusFile[];
    inGitRepository: boolean;
    pastCommits: Git.ISingleCommitInfo[];
    tab: number;
}
/** Interface for GitPanel component props */
export interface IGitSessionNodeProps {
    model: GitExtension;
    renderMime: IRenderMimeRegistry;
    settings: ISettingRegistry.ISettings;
}
/** A React component for the git extension's main display */
export declare class GitPanel extends React.Component<IGitSessionNodeProps, IGitSessionNodeState> {
    constructor(props: IGitSessionNodeProps);
    componentDidMount(): void;
    refreshBranch: () => Promise<void>;
    refreshHistory: () => Promise<void>;
    refreshStatus: () => Promise<void>;
    /**
     * Refresh widget, update all content
     */
    refresh: () => Promise<void>;
    /**
     * Commits all marked files.
     *
     * @param message - commit message
     * @returns a promise which commits the files
     */
    commitMarkedFiles: (message: string) => Promise<void>;
    /**
     * Commits all staged files.
     *
     * @param message - commit message
     * @returns a promise which commits the files
     */
    commitStagedFiles: (message: string) => Promise<void>;
    /**
     * Renders the component.
     *
     * @returns React element
     */
    render(): React.ReactElement;
    /**
     * Renders a toolbar.
     *
     * @returns React element
     */
    private _renderToolbar;
    /**
     * Renders the main panel.
     *
     * @returns React element
     */
    private _renderMain;
    /**
     * Renders panel tabs.
     *
     * @returns React element
     */
    private _renderTabs;
    /**
     * Renders a panel for viewing and committing file changes.
     *
     * @returns React element
     */
    private _renderChanges;
    /**
     * Renders a panel for viewing commit history.
     *
     * @returns React element
     */
    private _renderHistory;
    /**
     * Renders a panel for prompting a user to find a Git repository.
     *
     * @returns React element
     */
    private _renderWarning;
    /**
     * Callback invoked upon changing the active panel tab.
     *
     * @param event - event object
     * @param tab - tab number
     */
    private _onTabChange;
    /**
     * Callback invoked upon refreshing a repository.
     *
     * @returns promise which refreshes a repository
     */
    private _onRefresh;
    /**
     * Determines whether a user has a known Git identity.
     *
     * @param path - repository path
     * @returns a promise which returns a success status
     */
    private _hasIdentity;
    private _hasStagedFile;
    private _hasUnStagedFile;
    /**
     * List of marked files.
     */
    private get _markedFiles();
    /**
     * List of sorted modified files.
     */
    private get _sortedFiles();
    private _previousRepoPath;
}
