/*
 * Decompiled with CFR 0.152.
 */
package log;

import allocator.Allocator;
import config.Config;
import config.ConfigType;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import log.ArtifactLocation;
import log.ArtifactManager;
import log.ArtifactManagerFactory;
import log.Logger;
import log.LoggerTypes;
import log.RuleOutputArtifactsKey;
import log.VersionedArtifact;
import org.apache.commons.lang3.SystemUtils;
import org.codehaus.plexus.util.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tac.DebuggableProgram;
import tac.DumpTime;
import tac.DumpType;
import tac.TACFile;
import utils.ArtifactFileUtils;
import utils.CertoraFileCache;
import utils.ExtStdlibKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 I2\u00020\u0001:\u0001IB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u00042\b\u0010\u001d\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001b\u001a\u00020\u0004H\u0002J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004H\u0016J\u0016\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0004J2\u0010$\u001a\u0004\u0018\u00010%\"\b\b\u0000\u0010&*\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H&0)2\u0006\u0010*\u001a\u00020\u00132\u0006\u0010+\u001a\u00020\u0004H\u0016J?\u0010,\u001a\u0004\u0018\u00010%\"\b\b\u0000\u0010&*\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H&0)2\u0006\u0010-\u001a\u0002H&2\u0006\u0010*\u001a\u00020\u00132\u0006\u0010.\u001a\u00020/H\u0016\u00a2\u0006\u0002\u00100J5\u0010,\u001a\u0004\u0018\u00010%\"\b\b\u0000\u0010&*\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H&0)2\u0006\u0010-\u001a\u0002H&2\u0006\u0010.\u001a\u00020/\u00a2\u0006\u0002\u00101J(\u0010,\u001a\u0004\u0018\u00010%\"\b\b\u0000\u0010&*\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H&0)2\u0006\u0010.\u001a\u00020/J=\u00102\u001a\u00020%\"\b\b\u0000\u0010&*\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u0002H&0)2\u0006\u0010-\u001a\u0002H&2\u0006\u0010*\u001a\u00020\u00132\u0006\u0010.\u001a\u00020/H\u0016\u00a2\u0006\u0002\u00100J\u0014\u00103\u001a\u0002042\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000406J\u0010\u00103\u001a\u0002042\u0006\u0010\u001b\u001a\u00020\u0004H\u0016J\u0010\u00107\u001a\u0002082\u0006\u0010\u001b\u001a\u00020\u0004H\u0016J\u0010\u00109\u001a\u0004\u0018\u00010\u00042\u0006\u0010:\u001a\u00020\u0015J&\u0010;\u001a\u00020\u0004\"\b\b\u0000\u0010&*\u00020<2\f\u00105\u001a\b\u0012\u0004\u0012\u0002H&062\u0006\u0010=\u001a\u00020>J\u0014\u0010;\u001a\u00020\u00042\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000406J\u000e\u0010;\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0004J\u0016\u0010;\u001a\u00020\u00042\u0006\u0010?\u001a\u00020<2\u0006\u0010=\u001a\u00020>J\u0010\u0010@\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001b\u001a\u00020\u0004J\u0010\u0010@\u001a\u0004\u0018\u00010\u00042\u0006\u0010:\u001a\u00020\u0015J\u0018\u0010@\u001a\u0004\u0018\u00010\u00042\u0006\u0010?\u001a\u00020<2\u0006\u0010=\u001a\u00020>J\u0010\u0010A\u001a\u00020\u00042\u0006\u0010B\u001a\u00020\u0013H\u0004J,\u0010C\u001a\u00020\u001f2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u0004062\u0016\b\u0002\u0010D\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001f\u0018\u00010EJ0\u0010C\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u00042\b\b\u0002\u0010*\u001a\u00020\u00132\u0016\b\u0002\u0010D\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001f\u0018\u00010EJ0\u0010C\u001a\u00020\u001f2\u0006\u0010?\u001a\u00020<2\b\b\u0002\u0010*\u001a\u00020\u00132\u0016\b\u0002\u0010D\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001f\u0018\u00010EJ\u000e\u0010F\u001a\u00020\u001f2\u0006\u0010:\u001a\u00020\u0015J(\u0010G\u001a\u00020\u001f2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u0004062\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001f0EJ$\u0010G\u001a\u00020\u001f2\u0006\u0010\u001b\u001a\u00020\u00042\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001f0EH\u0016J\"\u0010G\u001a\u00020\u001f2\u0006\u0010:\u001a\u00020\u00152\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001f0EJ,\u0010G\u001a\u00020\u001f2\u0006\u0010?\u001a\u00020<2\u0006\u0010=\u001a\u00020>2\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001f0EH\u0016J\"\u0010H\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u00042\u0012\u0010D\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001f0ER\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u0006R\u0012\u0010\u000b\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00040\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\f\u0012\u0004\b\u0017\u0010\u0002\u001a\u0004\b\u0018\u0010\u0006\u00a8\u0006J"}, d2={"Llog/ArtifactManager;", "", "()V", "debugDir", "", "getDebugDir", "()Ljava/lang/String;", "formulasDir", "getFormulasDir", "inputsDir", "getInputsDir", "mainPath", "getMainPath", "mainReportsDir", "getMainReportsDir", "outputDir", "getOutputDir", "registeredArtifacts", "Ljava/util/concurrent/ConcurrentMap;", "Llog/ArtifactLocation;", "rulesToRegisteredOutputArtifacts", "Llog/RuleOutputArtifactsKey;", "treeViewReportsDir", "getTreeViewReportsDir$annotations", "getTreeViewReportsDir", "artifactPathOf", "loc", "name", "artifactPathOfOrNull", "locOrNull", "backup", "", "fileName", "backupFileName", "copyArtifact", "dstLoc", "dumpBinary", "Ltac/TACFile;", "T", "Ltac/DumpType;", "p", "Ltac/DebuggableProgram;", "location", "label", "dumpCodeArtifacts", "dumpType", "time", "Ltac/DumpTime;", "(Ltac/DebuggableProgram;Ltac/DumpType;Llog/ArtifactLocation;Ltac/DumpTime;)Ltac/TACFile;", "(Ltac/DebuggableProgram;Ltac/DumpType;Ltac/DumpTime;)Ltac/TACFile;", "dumpMandatoryCodeArtifacts", "getArtifactHandle", "Ljava/io/OutputStreamWriter;", "conf", "Lconfig/ConfigType;", "getArtifactHandleStream", "Ljava/io/OutputStream;", "getRegisteredArtifactNameOrNull", "ruleOutputArtifactsKey", "getRegisteredArtifactPath", "Llog/VersionedArtifact;", "version", "", "versionedArtifact", "getRegisteredArtifactPathOrNull", "getWhere", "l", "registerArtifact", "action", "Lkotlin/Function1;", "registerRuleOutputArtifact", "useArtifact", "useTempArtifact", "Companion", "Shared"})
@SourceDebugExtension(value={"SMAP\nArtifactManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArtifactManager.kt\nlog/ArtifactManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,454:1\n1#2:455\n*E\n"})
public abstract class ArtifactManager {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final ConcurrentMap<String, ArtifactLocation> registeredArtifacts = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentMap<RuleOutputArtifactsKey, String> rulesToRegisteredOutputArtifacts = new ConcurrentHashMap();
    @Nullable
    private static final Integer maxFilenameLength;
    @NotNull
    private static final String RULE_OUTPUT_BASE_NAME = "rule_output_";
    @NotNull
    private static final Logger logger;

    @NotNull
    public abstract String getMainPath();

    @NotNull
    protected final String getWhere(@NotNull ArtifactLocation l) {
        String string;
        Intrinsics.checkNotNullParameter((Object)l, "l");
        if (WhenMappings.$EnumSwitchMapping$0[l.ordinal()] == 1) {
            String string2 = System.getProperty("user.dir");
            string = string2;
            Intrinsics.checkNotNullExpressionValue(string2, "getProperty(\"user.dir\")");
        } else {
            String string3;
            if (l.isDefault()) {
                string3 = l.get(this.getMainPath());
            } else {
                File f = new File(l.get());
                boolean bl = false;
                string3 = f.isAbsolute() ? f.getAbsolutePath() : l.get(".");
            }
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "if (l.isDefault()) {\n   \u2026}\n            }\n        }");
        }
        return string;
    }

    @NotNull
    public String getMainReportsDir() {
        return this.getWhere(ArtifactLocation.REPORTS);
    }

    @NotNull
    public String getTreeViewReportsDir() {
        return this.getWhere(ArtifactLocation.TREE_VIEW_REPORTS);
    }

    public static /* synthetic */ void getTreeViewReportsDir$annotations() {
    }

    @NotNull
    public String getOutputDir() {
        return this.getWhere(ArtifactLocation.OUTPUTS);
    }

    @NotNull
    public String getDebugDir() {
        return this.getWhere(ArtifactLocation.DEBUGS);
    }

    @NotNull
    public String getFormulasDir() {
        return this.getWhere(ArtifactLocation.FORMULAS);
    }

    @NotNull
    public String getInputsDir() {
        return this.getWhere(ArtifactLocation.INPUT);
    }

    @Nullable
    public final <T extends DumpType> TACFile dumpCodeArtifacts(@NotNull DebuggableProgram<T> p, @NotNull DumpTime time) {
        Intrinsics.checkNotNullParameter(p, "p");
        Intrinsics.checkNotNullParameter((Object)time, "time");
        return this.dumpCodeArtifacts(p, p.getDefaultType(), time);
    }

    @Nullable
    public final <T extends DumpType> TACFile dumpCodeArtifacts(@NotNull DebuggableProgram<T> p, @NotNull T dumpType, @NotNull DumpTime time) {
        Intrinsics.checkNotNullParameter(p, "p");
        Intrinsics.checkNotNullParameter(dumpType, "dumpType");
        Intrinsics.checkNotNullParameter((Object)time, "time");
        return this.dumpCodeArtifacts(p, dumpType, ArtifactLocation.DEBUGS, time);
    }

    @Nullable
    public <T extends DumpType> TACFile dumpCodeArtifacts(@NotNull DebuggableProgram<T> p, @NotNull T dumpType, @NotNull ArtifactLocation location, @NotNull DumpTime time) {
        Intrinsics.checkNotNullParameter(p, "p");
        Intrinsics.checkNotNullParameter(dumpType, "dumpType");
        Intrinsics.checkNotNullParameter((Object)location, "location");
        Intrinsics.checkNotNullParameter((Object)time, "time");
        return (Boolean)Config.INSTANCE.getLowFootprint().get() == false && dumpType.isEnabled() ? p.dump(dumpType, this.getWhere(location), time) : null;
    }

    @NotNull
    public <T extends DumpType> TACFile dumpMandatoryCodeArtifacts(@NotNull DebuggableProgram<T> p, @NotNull T dumpType, @NotNull ArtifactLocation location, @NotNull DumpTime time) {
        Intrinsics.checkNotNullParameter(p, "p");
        Intrinsics.checkNotNullParameter(dumpType, "dumpType");
        Intrinsics.checkNotNullParameter((Object)location, "location");
        Intrinsics.checkNotNullParameter((Object)time, "time");
        return p.dump(dumpType, this.getWhere(location), time);
    }

    @Nullable
    public <T extends DumpType> TACFile dumpBinary(@NotNull DebuggableProgram<T> p, @NotNull ArtifactLocation location, @NotNull String label) {
        Intrinsics.checkNotNullParameter(p, "p");
        Intrinsics.checkNotNullParameter((Object)location, "location");
        Intrinsics.checkNotNullParameter(label, "label");
        return p.dumpBinary(this.getWhere(location), label);
    }

    private final String artifactPathOf(ArtifactLocation loc, String name) {
        return this.getWhere(loc) + File.separator + name;
    }

    private final String artifactPathOfOrNull(ArtifactLocation locOrNull, String name) {
        String string;
        ArtifactLocation artifactLocation = locOrNull;
        if (artifactLocation != null) {
            ArtifactLocation loc = artifactLocation;
            boolean bl = false;
            string = this.artifactPathOf(loc, name);
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public final String getRegisteredArtifactPathOrNull(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.artifactPathOfOrNull((ArtifactLocation)((Object)this.registeredArtifacts.get(name)), name);
    }

    @Nullable
    public final String getRegisteredArtifactPathOrNull(@NotNull VersionedArtifact versionedArtifact, int version) {
        Intrinsics.checkNotNullParameter(versionedArtifact, "versionedArtifact");
        return this.artifactPathOfOrNull((ArtifactLocation)((Object)this.registeredArtifacts.get(versionedArtifact.getUnversionedName())), versionedArtifact.getVersionedNameBuilder().invoke(version));
    }

    @NotNull
    public final String getRegisteredArtifactPath(@NotNull ConfigType<String> conf) {
        Intrinsics.checkNotNullParameter(conf, "conf");
        return this.getRegisteredArtifactPath(conf.get());
    }

    @NotNull
    public final <T extends VersionedArtifact> String getRegisteredArtifactPath(@NotNull ConfigType<T> conf, int version) {
        Intrinsics.checkNotNullParameter(conf, "conf");
        return this.getRegisteredArtifactPath((VersionedArtifact)conf.get(), version);
    }

    @NotNull
    public final String getRegisteredArtifactPath(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        String string = this.getRegisteredArtifactPathOrNull(name);
        if (string == null) {
            string = "N/A";
        }
        return string;
    }

    @NotNull
    public final String getRegisteredArtifactPath(@NotNull VersionedArtifact versionedArtifact, int version) {
        Intrinsics.checkNotNullParameter(versionedArtifact, "versionedArtifact");
        String string = this.getRegisteredArtifactPathOrNull(versionedArtifact, version);
        if (string == null) {
            string = "N/A";
        }
        return string;
    }

    public final void registerArtifact(@NotNull ConfigType<String> conf, @Nullable Function1<? super String, Unit> action) {
        Intrinsics.checkNotNullParameter(conf, "conf");
        this.registerArtifact(conf.get(), !Intrinsics.areEqual(conf.get(), conf.getDefault()) ? ArtifactLocation.CWD : ArtifactLocation.REPORTS, action);
    }

    public static /* synthetic */ void registerArtifact$default(ArtifactManager artifactManager, ConfigType configType, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: registerArtifact");
        }
        if ((n & 2) != 0) {
            function1 = null;
        }
        artifactManager.registerArtifact(configType, function1);
    }

    public final void registerArtifact(@NotNull String name, @NotNull ArtifactLocation location, @Nullable Function1<? super String, Unit> action) {
        block1: {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter((Object)location, "location");
            if (this.registeredArtifacts.containsKey(name)) {
                logger.warn((Function0<? extends Object>)new Function0<Object>(name, this){
                    final /* synthetic */ String $name;
                    final /* synthetic */ ArtifactManager this$0;
                    {
                        this.$name = $name;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    @NotNull
                    public final Object invoke() {
                        return "Artifact " + this.$name + " already registered in " + ArtifactManager.access$getRegisteredArtifacts$p(this.this$0).get(this.$name);
                    }
                });
            }
            this.registeredArtifacts.putIfAbsent(name, location);
            Function1<? super String, Unit> function1 = action;
            if (function1 == null) break block1;
            Function1<? super String, Unit> it = function1;
            boolean bl = false;
            this.useArtifact(name, it);
        }
    }

    public static /* synthetic */ void registerArtifact$default(ArtifactManager artifactManager, String string, ArtifactLocation artifactLocation, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: registerArtifact");
        }
        if ((n & 2) != 0) {
            artifactLocation = ArtifactLocation.REPORTS;
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        artifactManager.registerArtifact(string, artifactLocation, (Function1<? super String, Unit>)function1);
    }

    public final void registerArtifact(@NotNull VersionedArtifact versionedArtifact, @NotNull ArtifactLocation location, @Nullable Function1<? super String, Unit> action) {
        Intrinsics.checkNotNullParameter(versionedArtifact, "versionedArtifact");
        Intrinsics.checkNotNullParameter((Object)location, "location");
        this.registerArtifact(versionedArtifact.getUnversionedName(), location, action);
    }

    public static /* synthetic */ void registerArtifact$default(ArtifactManager artifactManager, VersionedArtifact versionedArtifact, ArtifactLocation artifactLocation, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: registerArtifact");
        }
        if ((n & 2) != 0) {
            artifactLocation = ArtifactLocation.REPORTS;
        }
        if ((n & 4) != 0) {
            function1 = null;
        }
        artifactManager.registerArtifact(versionedArtifact, artifactLocation, (Function1<? super String, Unit>)function1);
    }

    public final void registerRuleOutputArtifact(@NotNull RuleOutputArtifactsKey ruleOutputArtifactsKey) {
        Intrinsics.checkNotNullParameter(ruleOutputArtifactsKey, "ruleOutputArtifactsKey");
        if (!((Map)this.rulesToRegisteredOutputArtifacts).containsKey(ruleOutputArtifactsKey)) {
            String outputFilename = RULE_OUTPUT_BASE_NAME + Allocator.INSTANCE.getFreshId(Allocator.Id.RULE_OUTPUT) + ".json";
            ((Map)this.rulesToRegisteredOutputArtifacts).put(ruleOutputArtifactsKey, outputFilename);
            this.registeredArtifacts.putIfAbsent(outputFilename, ArtifactLocation.TREE_VIEW_REPORTS);
        }
    }

    @Nullable
    public final String getRegisteredArtifactPathOrNull(@NotNull RuleOutputArtifactsKey ruleOutputArtifactsKey) {
        String string;
        Intrinsics.checkNotNullParameter(ruleOutputArtifactsKey, "ruleOutputArtifactsKey");
        String string2 = this.getRegisteredArtifactNameOrNull(ruleOutputArtifactsKey);
        if (string2 != null) {
            String p0 = string2;
            boolean bl = false;
            string = this.getRegisteredArtifactPathOrNull(p0);
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public final String getRegisteredArtifactNameOrNull(@NotNull RuleOutputArtifactsKey ruleOutputArtifactsKey) {
        Intrinsics.checkNotNullParameter(ruleOutputArtifactsKey, "ruleOutputArtifactsKey");
        return (String)this.rulesToRegisteredOutputArtifacts.get(ruleOutputArtifactsKey);
    }

    public final void useArtifact(@NotNull RuleOutputArtifactsKey ruleOutputArtifactsKey, @NotNull Function1<? super String, Unit> action) {
        Intrinsics.checkNotNullParameter(ruleOutputArtifactsKey, "ruleOutputArtifactsKey");
        Intrinsics.checkNotNullParameter(action, "action");
        String ruleOutputPath = this.getRegisteredArtifactPathOrNull(ruleOutputArtifactsKey);
        if (ruleOutputPath == null) {
            logger.warn((Function0<? extends Object>)new Function0<Object>(ruleOutputArtifactsKey){
                final /* synthetic */ RuleOutputArtifactsKey $ruleOutputArtifactsKey;
                {
                    this.$ruleOutputArtifactsKey = $ruleOutputArtifactsKey;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return "Could not use output artifact for rule " + this.$ruleOutputArtifactsKey.getRule().getDeclarationId() + ", since this rule has not been registered.";
                }
            });
            return;
        }
        action.invoke(ruleOutputPath);
    }

    public final void useArtifact(@NotNull ConfigType<String> conf, @NotNull Function1<? super String, Unit> action) {
        Intrinsics.checkNotNullParameter(conf, "conf");
        Intrinsics.checkNotNullParameter(action, "action");
        this.useArtifact(conf.get(), action);
    }

    public void useArtifact(@NotNull VersionedArtifact versionedArtifact, int version, @NotNull Function1<? super String, Unit> action) {
        Intrinsics.checkNotNullParameter(versionedArtifact, "versionedArtifact");
        Intrinsics.checkNotNullParameter(action, "action");
        String fullPath = this.getRegisteredArtifactPathOrNull(versionedArtifact, version);
        if (fullPath == null) {
            logger.warn((Function0<? extends Object>)new Function0<Object>(version, versionedArtifact){
                final /* synthetic */ int $version;
                final /* synthetic */ VersionedArtifact $versionedArtifact;
                {
                    this.$version = $version;
                    this.$versionedArtifact = $versionedArtifact;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return "Could not use versioned artifact (version=" + this.$version + "), since " + this.$versionedArtifact.getUnversionedName() + " is not a valid file name.";
                }
            });
            return;
        }
        action.invoke(fullPath);
    }

    public void useArtifact(@NotNull String name, @NotNull Function1<? super String, Unit> action) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(action, "action");
        String fullPath = this.getRegisteredArtifactPathOrNull(name);
        if (fullPath == null) {
            logger.warn((Function0<? extends Object>)new Function0<Object>(name){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return "Could not use artifact, since " + this.$name + " is not a valid file name.";
                }
            });
            return;
        }
        action.invoke(fullPath);
    }

    @NotNull
    public final OutputStreamWriter getArtifactHandle(@NotNull ConfigType<String> conf) {
        Intrinsics.checkNotNullParameter(conf, "conf");
        return this.getArtifactHandle(conf.get());
    }

    @NotNull
    public OutputStreamWriter getArtifactHandle(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return new OutputStreamWriter(this.getArtifactHandleStream(name));
    }

    @NotNull
    public OutputStream getArtifactHandleStream(@NotNull String name) {
        Intrinsics.checkNotNullParameter(name, "name");
        String fullPath = this.getRegisteredArtifactPathOrNull(name);
        if (fullPath == null) {
            throw new IllegalStateException(("Non existing artifact " + name).toString());
        }
        return new FileOutputStream(fullPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backup(@NotNull String fileName, @NotNull String backupFileName) {
        Intrinsics.checkNotNullParameter(fileName, "fileName");
        Intrinsics.checkNotNullParameter(backupFileName, "backupFileName");
        try {
            Reader reader = CertoraFileCache.INSTANCE.getContentReader(Config.INSTANCE.prependInternalDir(fileName));
            Closeable closeable = reader;
            Throwable throwable = null;
            try {
                long l;
                Reader it = (Reader)closeable;
                boolean bl = false;
                File backupFileDir = new File(FileUtils.dirname(backupFileName));
                backupFileDir.mkdirs();
                Object object = new File(backupFileName);
                Object object2 = Charsets.UTF_8;
                int n = 8192;
                Object object3 = object;
                object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
                BufferedWriter writer = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
                object = writer;
                object2 = null;
                try {
                    BufferedWriter it2 = (BufferedWriter)object;
                    boolean bl2 = false;
                    l = TextStreamsKt.copyTo$default(reader, writer, 0, 2, null);
                }
                catch (Throwable throwable2) {
                    object2 = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                }
                long l2 = l;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
        }
        catch (Exception e) {
            Logger.Companion.alwaysError("Received exception " + e + "; Failed to backup " + fileName, e);
        }
    }

    @NotNull
    public final String useTempArtifact(@NotNull String name, @NotNull Function1<? super String, Unit> action) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(action, "action");
        File tmpFile = File.createTempFile(name, null);
        tmpFile.deleteOnExit();
        String string = tmpFile.getPath();
        Intrinsics.checkNotNullExpressionValue(string, "tmpFile.path");
        action.invoke(string);
        String string2 = tmpFile.getPath();
        Intrinsics.checkNotNullExpressionValue(string2, "tmpFile.path");
        return string2;
    }

    public final void copyArtifact(@NotNull ArtifactLocation dstLoc, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)dstLoc, "dstLoc");
        Intrinsics.checkNotNullParameter(name, "name");
        String src = this.getRegisteredArtifactPath(name);
        String dst = this.artifactPathOf(dstLoc, name);
        if (Intrinsics.areEqual(src, dst)) {
            logger.warn((Function0<? extends Object>)new Function0<Object>(name, src, dst){
                final /* synthetic */ String $name;
                final /* synthetic */ String $src;
                final /* synthetic */ String $dst;
                {
                    this.$name = $name;
                    this.$src = $src;
                    this.$dst = $dst;
                    super(0);
                }

                @NotNull
                public final Object invoke() {
                    return "Trivial copy of an artifact " + this.$name + " from " + this.$src + " to " + this.$dst + ", skipping";
                }
            });
        }
        Files.copy(new File(src).toPath(), new File(dst).toPath(), new CopyOption[0]);
    }

    public static final /* synthetic */ ConcurrentMap access$getRegisteredArtifacts$p(ArtifactManager $this) {
        return $this.registeredArtifacts;
    }

    static {
        Integer n;
        Companion = new Companion(null);
        String string = System.getenv("CERTORA_MAX_FILENAME");
        if (string != null) {
            String p0 = string;
            boolean bl = false;
            n = Integer.parseInt(p0);
        } else {
            n = null;
        }
        maxFilenameLength = n;
        logger = new Logger(LoggerTypes.COMMON);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\rJ\u0016\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J\u000e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J\u001a\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\t\u00a8\u0006\u0015"}, d2={"Llog/ArtifactManager$Companion;", "", "()V", "RULE_OUTPUT_BASE_NAME", "", "logger", "Llog/Logger;", "maxFilenameLength", "", "Ljava/lang/Integer;", "copyInputsToRootOfOutputDir", "", "filenames", "", "fitFileLength", "name", "suffix", "getCmdErrorFilepath", "getCmdOutputFilepath", "getFilePathForSmtQuery", "subdir", "Shared"})
    @SourceDebugExtension(value={"SMAP\nArtifactManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArtifactManager.kt\nlog/ArtifactManager$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,454:1\n1855#2:455\n1856#2:457\n1#3:456\n*S KotlinDebug\n*F\n+ 1 ArtifactManager.kt\nlog/ArtifactManager$Companion\n*L\n337#1:455\n337#1:457\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String fitFileLength(@NotNull String name, @NotNull String suffix) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(suffix, "suffix");
            if (maxFilenameLength == null) {
                return name;
            }
            if (name.length() <= maxFilenameLength) {
                return name;
            }
            int truncation = maxFilenameLength - suffix.length() - 9;
            byte[] byArray = ExtStdlibKt.digestStream((Function1<? super ObjectOutputStream, Unit>)new Function1<ObjectOutputStream, Unit>(name){
                final /* synthetic */ String $name;
                {
                    this.$name = $name;
                    super(1);
                }

                public final void invoke(@NotNull ObjectOutputStream it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    it.writeObject(this.$name);
                }
            }).digest();
            Intrinsics.checkNotNullExpressionValue(byArray, "name: String, suffix: St\u2026e)\n            }.digest()");
            String string = ArraysKt.joinToString$default(byArray, (CharSequence)"", null, null, 0, null, (Function1)fitFileLength.hash.2.INSTANCE, 30, null);
            int n = 0;
            int n2 = 8;
            String string2 = string.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            String hash2 = string2;
            String string3 = name.substring(0, truncation);
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            String newName = string3 + "-" + hash2 + suffix;
            if (!(newName.length() <= maxFilenameLength)) {
                String string4 = "Check failed.";
                throw new IllegalStateException(string4.toString());
            }
            return newName;
        }

        @NotNull
        public final String getCmdOutputFilepath(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            String trunc = this.fitFileLength("Cmd_" + name + ".out.txt", ".out.txt");
            return ArtifactManagerFactory.INSTANCE.invoke().getDebugDir() + File.separator + trunc;
        }

        @NotNull
        public final String getCmdErrorFilepath(@NotNull String name) {
            Intrinsics.checkNotNullParameter(name, "name");
            String trunc = this.fitFileLength("Cmd_" + name + ".err.txt", ".err.txt");
            return ArtifactManagerFactory.INSTANCE.invoke().getDebugDir() + File.separator + trunc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void copyInputsToRootOfOutputDir(@NotNull List<String> filenames) {
            Intrinsics.checkNotNullParameter(filenames, "filenames");
            if (ArtifactManagerFactory.INSTANCE.isEnabled()) {
                String target = ArtifactManagerFactory.INSTANCE.invoke().getMainPath();
                try {
                    Iterable $this$forEach$iv = filenames;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String filename = (String)element$iv;
                        boolean bl = false;
                        String targetFile = target + File.separator + ArtifactFileUtils.INSTANCE.getBasenameOnly(filename) + "." + FileUtils.extension(filename);
                        Reader reader = CertoraFileCache.INSTANCE.getContentReader(filename);
                        Closeable closeable = reader;
                        Throwable throwable = null;
                        try {
                            Reader it = (Reader)closeable;
                            boolean bl2 = false;
                            Object object = new File(targetFile);
                            Object object2 = Charsets.UTF_8;
                            int n = 8192;
                            Object object3 = object;
                            object3 = new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2);
                            BufferedWriter writer = object3 instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
                            object = writer;
                            object2 = null;
                            try {
                                BufferedWriter it2 = (BufferedWriter)object;
                                boolean bl3 = false;
                                TextStreamsKt.copyTo$default(reader, it2, 0, 2, null);
                                Unit unit = Unit.INSTANCE;
                            }
                            catch (Throwable throwable2) {
                                object2 = throwable2;
                                throw throwable2;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                        catch (Throwable throwable3) {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        finally {
                            CloseableKt.closeFinally(closeable, throwable);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("Failed to copy some inputs files " + filenames + ", got error: " + e.getMessage());
                }
            }
        }

        @NotNull
        public final String getFilePathForSmtQuery(@NotNull String name, @Nullable String subdir) {
            Object object;
            String subdirString;
            block8: {
                Object object2;
                block7: {
                    Intrinsics.checkNotNullParameter(name, "name");
                    object2 = subdir;
                    if (object2 == null) break block7;
                    String it = object2;
                    boolean bl = false;
                    String string = File.separator + it;
                    object2 = string;
                    if (string != null) break block8;
                }
                object2 = subdirString = "";
            }
            if (!ArtifactManagerFactory.INSTANCE.isEnabled()) {
                object = ArtifactManagerFactory.INSTANCE.invoke().useTempArtifact(Config.INSTANCE.getFormulaFileBasename().get() + subdirString, getFilePathForSmtQuery.1.INSTANCE);
            } else {
                String baseDir = ArtifactManagerFactory.INSTANCE.invoke().getFormulasDir() + subdirString;
                String basePathPrefix = baseDir + File.separator + Config.INSTANCE.getFormulaFileBasename().get() + "_" + Allocator.INSTANCE.getFreshNumber() + "_";
                String smt2file = basePathPrefix + name + ".smt2";
                int fileLengthLimitWindows = 250;
                if (SystemUtils.IS_OS_WINDOWS && smt2file.length() > fileLengthLimitWindows) {
                    logger.warn((Function0<? extends Object>)new Function0<Object>(name, fileLengthLimitWindows){
                        final /* synthetic */ String $name;
                        final /* synthetic */ int $fileLengthLimitWindows;
                        {
                            this.$name = $name;
                            this.$fileLengthLimitWindows = $fileLengthLimitWindows;
                            super(0);
                        }

                        @NotNull
                        public final Object invoke() {
                            return "Cannot dump .smt2 file for " + this.$name + ", since we're on Windows and file namewould be too long. (assumed length limit: " + this.$fileLengthLimitWindows + ")";
                        }
                    });
                    return "";
                }
                File baseDirFile = new File(baseDir);
                if (!baseDirFile.exists() && !baseDirFile.mkdirs()) {
                    logger.error("Failed to create formulas directory " + baseDirFile);
                }
                object = smt2file;
            }
            return object;
        }

        public static /* synthetic */ String getFilePathForSmtQuery$default(Companion companion, String string, String string2, int n, Object object) {
            if ((n & 2) != 0) {
                string2 = null;
            }
            return companion.getFilePathForSmtQuery(string, string2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ArtifactLocation.values().length];
            try {
                nArray[ArtifactLocation.CWD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

