"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElasticFileSystemAddOn = exports.BucketSyncAddOn = exports.InstanceFirewallAddOn = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const commands_1 = require("./commands");
/**
 * An add-on that configures an on-instance firewall.
 */
class InstanceFirewallAddOn {
    /**
     * An add-on that configures an on-instance firewall.
     *
     * @param rules - The instance firewall rules
     * @param props - Optional configuration properties
     */
    constructor(rules, props) {
        this.rules = rules;
        this.props = props;
    }
    configure(starter) {
        starter.addScript(this.props?.priority ?? 0, ...this.rules.buildCommands());
    }
}
exports.InstanceFirewallAddOn = InstanceFirewallAddOn;
_a = JSII_RTTI_SYMBOL_1;
InstanceFirewallAddOn[_a] = { fqn: "shady-island.configuration.InstanceFirewallAddOn", version: "0.1.35" };
/**
 * An add-on that synchronizes files from S3 to directories on the instance.
 *
 * This add-on also grants read access to the bucket.
 */
class BucketSyncAddOn {
    /**
     * An add-on that synchronizes files from S3 to directories on the instance.
     *
     * This add-on also grants read access to the bucket.
     *
     * @param bucket - The S3 bucket from which files can be downloaded
     * @param destinations - An object where keys are S3 object key prefixes and values are filesystem directories
     * @param props - Optional configuration properties
     */
    constructor(bucket, destinations, props) {
        this.bucket = bucket;
        this.destinations = destinations;
        this.props = props;
    }
    configure(starter) {
        this.bucket.grantRead(starter);
        starter.addScript(this.props?.priority ?? 10, ...commands_1.ShellCommands.syncFromBucket(this.bucket, this.destinations));
    }
}
exports.BucketSyncAddOn = BucketSyncAddOn;
_b = JSII_RTTI_SYMBOL_1;
BucketSyncAddOn[_b] = { fqn: "shady-island.configuration.BucketSyncAddOn", version: "0.1.35" };
/**
 * An add-on that configures a mount point for an EFS filesystem.
 *
 * This add-on will produce a startup script to:
 * - Create the mount directory
 * - Mount the NFS filesystem to the mount point
 * - Optionally change the mode or ownership of the mount point
 *
 * This visitor also configures the Security Groups on both ends.
 */
class ElasticFileSystemAddOn {
    /**
     * An add-on that configures a mount point for an EFS filesystem.
     *
     * This add-on will produce a startup script to:
     * - Create the mount directory
     * - Mount the NFS filesystem to the mount point
     * - Optionally change the mode or ownership of the mount point
     *
     * This visitor also configures the Security Groups on both ends.
     *
     * @param filesystem - The elastic filesystem to mount
     * @param destination - The directory to use as the mount point
     * @param props - Optional configuration properties
     */
    constructor(filesystem, destination, props) {
        this.filesystem = filesystem;
        this.destination = destination;
        this.props = props;
    }
    configure(starter) {
        const description = "Allow NFS traffic from EC2 to EFS";
        // The CDK source code definitely sets the default port to 2049.
        const port = this.filesystem.connections.defaultPort;
        // To prevent circular references in case the stacks are different.
        for (const fsg of this.filesystem.connections.securityGroups) {
            for (const isg of starter.connections.securityGroups) {
                fsg.addIngressRule(isg, port, description, true);
                isg.addEgressRule(fsg, port, description);
            }
        }
        const postMount = [];
        const { chown, chgrp, chmod, priority = 10 } = this.props || {};
        if (chmod) {
            postMount.push(`chmod ${chmod} "${this.destination}"`);
        }
        if (chown || chgrp) {
            postMount.push(...commands_1.ShellCommands.changeOwnership(this.destination, chown, chgrp));
        }
        starter.addScript(priority, ...commands_1.ShellCommands.mountElasticFileSystem(this.filesystem, this.destination), ...postMount);
    }
}
exports.ElasticFileSystemAddOn = ElasticFileSystemAddOn;
_c = JSII_RTTI_SYMBOL_1;
ElasticFileSystemAddOn[_c] = { fqn: "shady-island.configuration.ElasticFileSystemAddOn", version: "0.1.35" };
//# sourceMappingURL=data:application/json;base64,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