"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PostgresqlDatabase = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const triggers_1 = require("aws-cdk-lib/triggers");
const base_database_1 = require("./base-database");
const HANDLER_PATH = path.join(__dirname, "../../assets/rds/triggers/pgsql");
/**
 * A PostgreSQL database.
 */
class PostgresqlDatabase extends base_database_1.BaseDatabase {
    /**
     * Create a new PostgresqlDatabase inside a DatabaseCluster.
     *
     * This method automatically adds the cluster to the CloudFormation
     * dependencies of the CDK Trigger.
     *
     * @param scope - The Construct that contains this one.
     * @param id - The identifier of this construct.
     * @param cluster - The database cluster construct.
     * @param options - The configuration properties for this construct.
     */
    static forCluster(scope, id, cluster, options) {
        const props = { ...options };
        let clusterSecret = props.adminSecret || cluster.secret;
        if (clusterSecret === undefined) {
            throw new Error("You must provide either the adminSecret property or a cluster with an attached secret");
        }
        delete props.adminSecret;
        const database = new PostgresqlDatabase(scope, id, {
            target: cluster,
            endpoint: cluster.clusterEndpoint,
            adminSecret: clusterSecret,
            vpc: cluster.vpc,
            ...props,
        });
        database.trigger.executeAfter(cluster);
        return database;
    }
    /**
     * Create a new PostgresqlDatabase inside a DatabaseClusterFromSnapshot.
     *
     * This method automatically adds the cluster to the CloudFormation
     * dependencies of the CDK Trigger.
     *
     * @param scope - The Construct that contains this one.
     * @param id - The identifier of this construct.
     * @param cluster - The database cluster construct.
     * @param options - The configuration properties for this construct.
     */
    static forClusterFromSnapshot(scope, id, cluster, options) {
        // The DatabaseClusterFromSnapshot type is equivalent to DatabaseCluster.
        return PostgresqlDatabase.forCluster(scope, id, cluster, options);
    }
    /**
     * Create a new PostgresqlDatabase inside a DatabaseCluster.
     *
     * This method automatically adds the cluster to the CloudFormation
     * dependencies of the CDK Trigger.
     *
     * @param scope - The Construct that contains this one.
     * @param id - The identifier of this construct.
     * @param cluster - The database cluster construct.
     * @param options - The configuration properties for this construct.
     */
    static forServerlessCluster(scope, id, cluster, options) {
        // The ServerlessClusterFromSnapshot type is a subset of ServerlessCluster.
        return PostgresqlDatabase.forServerlessClusterFromSnapshot(scope, id, cluster, options);
    }
    /**
     * Create a new PostgresqlDatabase inside a DatabaseClusterFromSnapshot.
     *
     * This method automatically adds the cluster to the CloudFormation
     * dependencies of the CDK Trigger.
     *
     * @param scope - The Construct that contains this one.
     * @param id - The identifier of this construct.
     * @param cluster - The database cluster construct.
     * @param options - The configuration properties for this construct.
     */
    static forServerlessClusterFromSnapshot(scope, id, cluster, options) {
        const props = { ...options };
        let clusterSecret = props.adminSecret || cluster.secret;
        if (clusterSecret === undefined) {
            throw new Error("You must provide either the adminSecret property or a cluster with an attached secret");
        }
        delete props.adminSecret;
        const database = new PostgresqlDatabase(scope, id, {
            target: cluster,
            endpoint: cluster.clusterEndpoint,
            adminSecret: clusterSecret,
            ...props,
        });
        database.trigger.executeAfter(cluster);
        return database;
    }
    /**
     * Create a new PostgresqlDatabase inside a DatabaseInstance.
     *
     * This method automatically adds the instance to the CloudFormation
     * dependencies of the CDK Trigger.
     *
     * @param scope - The Construct that contains this one.
     * @param id - The identifier of this construct.
     * @param instance - The database cluster construct.
     * @param options - The configuration properties for this construct.
     */
    static forInstance(scope, id, instance, options) {
        const props = { ...options };
        let clusterSecret = props.adminSecret || instance.secret;
        if (clusterSecret === undefined) {
            throw new Error("You must provide either the adminSecret property or a cluster with an attached secret");
        }
        delete props.adminSecret;
        const database = new PostgresqlDatabase(scope, id, {
            target: instance,
            endpoint: instance.instanceEndpoint,
            adminSecret: clusterSecret,
            vpc: instance.vpc,
            ...props,
        });
        database.trigger.executeAfter(instance);
        return database;
    }
    /**
     * Create a new PostgresqlDatabase inside a DatabaseInstanceFromSnapshot.
     *
     * This method automatically adds the instance to the CloudFormation
     * dependencies of the CDK Trigger.
     *
     * @param scope - The Construct that contains this one.
     * @param id - The identifier of this construct.
     * @param instance - The database cluster construct.
     * @param options - The configuration properties for this construct.
     */
    static forInstanceFromSnapshot(scope, id, instance, options) {
        // The DatabaseInstanceFromSnapshot type is equivalent to DatabaseInstance.
        return PostgresqlDatabase.forInstance(scope, id, instance, options);
    }
    /**
     * Creates a new PostgresqlDatabase.
     *
     * @param scope - The Construct that contains this one.
     * @param id - The identifier of this construct.
     * @param props - The configuration properties for this construct.
     */
    constructor(scope, id, props) {
        super(scope, id, props);
        this.ownerSecrets = [];
        this.readerSecrets = [];
        this.unprivilegedSecrets = [];
        const { adminSecret, vpc, ownerSecret, schemaName, encoding = "UTF8", } = props;
        const environment = {
            AWS_NODEJS_CONNECTION_REUSE_ENABLED: "1",
            ADMIN_SECRET_ARN: adminSecret.secretArn,
            OWNER_SECRET_ARN: ownerSecret.secretArn,
            OWNER_SECRETS: aws_cdk_lib_1.Lazy.string({
                produce: () => JSON.stringify(this.ownerSecrets.map((s) => s.secretArn)),
            }),
            READER_SECRETS: aws_cdk_lib_1.Lazy.string({
                produce: () => JSON.stringify(this.readerSecrets.map((s) => s.secretArn)),
            }),
            UNPRIVILEGED_SECRETS: aws_cdk_lib_1.Lazy.string({
                produce: () => JSON.stringify(this.unprivilegedSecrets.map((s) => s.secretArn)),
            }),
            DB_NAME: this.databaseName,
            SCHEMA_NAME: schemaName || "",
            DB_ENCODING: encoding,
        };
        if (props.locale) {
            environment.DB_LOCALE = props.locale;
        }
        if (props.certificateAuthoritiesUrl) {
            environment.CA_CERTS_URL = props.certificateAuthoritiesUrl;
        }
        this.lambdaFunction = new aws_lambda_1.Function(this, "Function", {
            runtime: aws_lambda_1.Runtime.NODEJS_20_X,
            code: aws_lambda_1.Code.fromAsset(HANDLER_PATH),
            handler: "index.handler",
            description: "Creates a schema and possibly some secondary users",
            vpc,
            vpcSubnets: this.subnetSelection,
            securityGroups: [this.securityGroup],
            environment,
            timeout: aws_cdk_lib_1.Duration.minutes(2),
        });
        adminSecret.grantRead(this.lambdaFunction);
        ownerSecret.grantRead(this.lambdaFunction);
        this.trigger = new triggers_1.Trigger(this, "Trigger", {
            handler: this.lambdaFunction,
        });
        this.trigger.executeAfter(adminSecret, ownerSecret, this.lambdaFunction);
    }
    addUserAsOwner(secret) {
        this.ownerSecrets.push(secret);
        secret.grantRead(this.lambdaFunction);
        this.trigger.executeAfter(secret);
    }
    addUserAsReader(secret) {
        this.readerSecrets.push(secret);
        secret.grantRead(this.lambdaFunction);
        this.trigger.executeAfter(secret);
    }
    addUserAsUnprivileged(secret) {
        this.unprivilegedSecrets.push(secret);
        secret.grantRead(this.lambdaFunction);
        this.trigger.executeAfter(secret);
    }
}
exports.PostgresqlDatabase = PostgresqlDatabase;
_a = JSII_RTTI_SYMBOL_1;
PostgresqlDatabase[_a] = { fqn: "shady-island.PostgresqlDatabase", version: "0.1.35" };
//# sourceMappingURL=data:application/json;base64,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