from __future__ import annotations

import sys
from contextlib import suppress
from importlib import import_module, metadata as _metadata
from pathlib import Path

from .config import RetryConfig, SDKOptions, TelemetryConfig
from .element_service import ElementService, create_element_service
from .errors import AmeideRpcError, RpcErrorCategory, normalize_error


_generated_path = Path(__file__).resolve().parent / "generated"
_generated_path_str = str(_generated_path)
if _generated_path.exists() and _generated_path_str not in sys.path:
    sys.path.append(_generated_path_str)

with suppress(ModuleNotFoundError):
    sys.modules["ameide_core_proto"] = import_module("ameide_sdk.generated.ameide_core_proto")


try:
    __version__ = _metadata.version("ameide-sdk-python")
except _metadata.PackageNotFoundError:  # pragma: no cover - fallback for editable installs
    __version__ = "0.0.0"


def __getattr__(name: str):
    if name == "AmeideClient":
        from .client import AmeideClient

        return AmeideClient
    raise AttributeError(name)


__all__ = [
    "AmeideClient",
    "SDKOptions",
    "RetryConfig",
    "TelemetryConfig",
    "AmeideRpcError",
    "RpcErrorCategory",
    "normalize_error",
    "ElementService",
    "create_element_service",
    "__version__",
]
