import datetime

from google.protobuf import timestamp_pb2 as _timestamp_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf.internal import enum_type_wrapper as _enum_type_wrapper
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from collections.abc import Iterable as _Iterable, Mapping as _Mapping
from typing import ClassVar as _ClassVar, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class Message(_message.Message):
    __slots__ = ()
    class Role(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        ROLE_UNSPECIFIED: _ClassVar[Message.Role]
        ROLE_USER: _ClassVar[Message.Role]
        ROLE_ASSISTANT: _ClassVar[Message.Role]
        ROLE_SYSTEM: _ClassVar[Message.Role]
        ROLE_TOOL: _ClassVar[Message.Role]
    ROLE_UNSPECIFIED: Message.Role
    ROLE_USER: Message.Role
    ROLE_ASSISTANT: Message.Role
    ROLE_SYSTEM: Message.Role
    ROLE_TOOL: Message.Role
    class MetadataEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    ROLE_FIELD_NUMBER: _ClassVar[int]
    CONTENT_FIELD_NUMBER: _ClassVar[int]
    METADATA_FIELD_NUMBER: _ClassVar[int]
    role: Message.Role
    content: str
    metadata: _containers.ScalarMap[str, str]
    def __init__(self, role: _Optional[_Union[Message.Role, str]] = ..., content: _Optional[str] = ..., metadata: _Optional[_Mapping[str, str]] = ...) -> None: ...

class Options(_message.Message):
    __slots__ = ()
    TEMPERATURE_FIELD_NUMBER: _ClassVar[int]
    MAX_TOKENS_FIELD_NUMBER: _ClassVar[int]
    TOP_P_FIELD_NUMBER: _ClassVar[int]
    TOP_K_FIELD_NUMBER: _ClassVar[int]
    STREAM_FIELD_NUMBER: _ClassVar[int]
    STOP_FIELD_NUMBER: _ClassVar[int]
    temperature: float
    max_tokens: int
    top_p: float
    top_k: int
    stream: bool
    stop: _containers.RepeatedScalarFieldContainer[str]
    def __init__(self, temperature: _Optional[float] = ..., max_tokens: _Optional[int] = ..., top_p: _Optional[float] = ..., top_k: _Optional[int] = ..., stream: _Optional[bool] = ..., stop: _Optional[_Iterable[str]] = ...) -> None: ...

class Usage(_message.Message):
    __slots__ = ()
    PROMPT_TOKENS_FIELD_NUMBER: _ClassVar[int]
    COMPLETION_TOKENS_FIELD_NUMBER: _ClassVar[int]
    TOTAL_TOKENS_FIELD_NUMBER: _ClassVar[int]
    COST_USD_FIELD_NUMBER: _ClassVar[int]
    MODEL_FIELD_NUMBER: _ClassVar[int]
    prompt_tokens: int
    completion_tokens: int
    total_tokens: int
    cost_usd: float
    model: str
    def __init__(self, prompt_tokens: _Optional[int] = ..., completion_tokens: _Optional[int] = ..., total_tokens: _Optional[int] = ..., cost_usd: _Optional[float] = ..., model: _Optional[str] = ...) -> None: ...

class StreamEventMeta(_message.Message):
    __slots__ = ()
    STREAM_ID_FIELD_NUMBER: _ClassVar[int]
    EVENT_INDEX_FIELD_NUMBER: _ClassVar[int]
    RESUME_TOKEN_FIELD_NUMBER: _ClassVar[int]
    TIMESTAMP_MS_FIELD_NUMBER: _ClassVar[int]
    RUN_ID_FIELD_NUMBER: _ClassVar[int]
    stream_id: str
    event_index: int
    resume_token: str
    timestamp_ms: int
    run_id: str
    def __init__(self, stream_id: _Optional[str] = ..., event_index: _Optional[int] = ..., resume_token: _Optional[str] = ..., timestamp_ms: _Optional[int] = ..., run_id: _Optional[str] = ...) -> None: ...

class TokenDelta(_message.Message):
    __slots__ = ()
    TEXT_FIELD_NUMBER: _ClassVar[int]
    TOKEN_COUNT_FIELD_NUMBER: _ClassVar[int]
    LOG_PROB_FIELD_NUMBER: _ClassVar[int]
    text: str
    token_count: int
    log_prob: float
    def __init__(self, text: _Optional[str] = ..., token_count: _Optional[int] = ..., log_prob: _Optional[float] = ...) -> None: ...

class ToolCall(_message.Message):
    __slots__ = ()
    class ArgumentsEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    TOOL_NAME_FIELD_NUMBER: _ClassVar[int]
    TOOL_ID_FIELD_NUMBER: _ClassVar[int]
    ARGUMENTS_FIELD_NUMBER: _ClassVar[int]
    RESULT_FIELD_NUMBER: _ClassVar[int]
    tool_name: str
    tool_id: str
    arguments: _containers.ScalarMap[str, str]
    result: str
    def __init__(self, tool_name: _Optional[str] = ..., tool_id: _Optional[str] = ..., arguments: _Optional[_Mapping[str, str]] = ..., result: _Optional[str] = ...) -> None: ...

class Error(_message.Message):
    __slots__ = ()
    class DetailsEntry(_message.Message):
        __slots__ = ()
        KEY_FIELD_NUMBER: _ClassVar[int]
        VALUE_FIELD_NUMBER: _ClassVar[int]
        key: str
        value: str
        def __init__(self, key: _Optional[str] = ..., value: _Optional[str] = ...) -> None: ...
    CODE_FIELD_NUMBER: _ClassVar[int]
    MESSAGE_FIELD_NUMBER: _ClassVar[int]
    DETAILS_FIELD_NUMBER: _ClassVar[int]
    code: str
    message: str
    details: _containers.ScalarMap[str, str]
    def __init__(self, code: _Optional[str] = ..., message: _Optional[str] = ..., details: _Optional[_Mapping[str, str]] = ...) -> None: ...

class Status(_message.Message):
    __slots__ = ()
    class State(int, metaclass=_enum_type_wrapper.EnumTypeWrapper):
        __slots__ = ()
        STATE_UNSPECIFIED: _ClassVar[Status.State]
        STATE_RUNNING: _ClassVar[Status.State]
        STATE_COMPLETED: _ClassVar[Status.State]
        STATE_FAILED: _ClassVar[Status.State]
        STATE_CANCELLED: _ClassVar[Status.State]
    STATE_UNSPECIFIED: Status.State
    STATE_RUNNING: Status.State
    STATE_COMPLETED: Status.State
    STATE_FAILED: Status.State
    STATE_CANCELLED: Status.State
    STATE_FIELD_NUMBER: _ClassVar[int]
    MESSAGE_FIELD_NUMBER: _ClassVar[int]
    state: Status.State
    message: str
    def __init__(self, state: _Optional[_Union[Status.State, str]] = ..., message: _Optional[str] = ...) -> None: ...

class Heartbeat(_message.Message):
    __slots__ = ()
    TIMESTAMP_FIELD_NUMBER: _ClassVar[int]
    UPTIME_MS_FIELD_NUMBER: _ClassVar[int]
    timestamp: _timestamp_pb2.Timestamp
    uptime_ms: int
    def __init__(self, timestamp: _Optional[_Union[datetime.datetime, _timestamp_pb2.Timestamp, _Mapping]] = ..., uptime_ms: _Optional[int] = ...) -> None: ...
