from ameide_core_proto.workflows_runtime.v1 import workflows_types_pb2 as _workflows_types_pb2
from google.protobuf import struct_pb2 as _struct_pb2
from google.protobuf.internal import containers as _containers
from google.protobuf import descriptor as _descriptor
from google.protobuf import message as _message
from collections.abc import Iterable as _Iterable, Mapping as _Mapping
from typing import ClassVar as _ClassVar, Optional as _Optional, Union as _Union

DESCRIPTOR: _descriptor.FileDescriptor

class CreateWorkflowDefinitionRequest(_message.Message):
    __slots__ = ()
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    USER_ID_FIELD_NUMBER: _ClassVar[int]
    DEFINITION_FIELD_NUMBER: _ClassVar[int]
    tenant_id: str
    user_id: str
    definition: _workflows_types_pb2.WorkflowDefinitionInput
    def __init__(self, tenant_id: _Optional[str] = ..., user_id: _Optional[str] = ..., definition: _Optional[_Union[_workflows_types_pb2.WorkflowDefinitionInput, _Mapping]] = ...) -> None: ...

class CreateWorkflowDefinitionResponse(_message.Message):
    __slots__ = ()
    DEFINITION_FIELD_NUMBER: _ClassVar[int]
    definition: _workflows_types_pb2.WorkflowDefinition
    def __init__(self, definition: _Optional[_Union[_workflows_types_pb2.WorkflowDefinition, _Mapping]] = ...) -> None: ...

class UpdateWorkflowDefinitionRequest(_message.Message):
    __slots__ = ()
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    DEFINITION_ID_FIELD_NUMBER: _ClassVar[int]
    USER_ID_FIELD_NUMBER: _ClassVar[int]
    DEFINITION_FIELD_NUMBER: _ClassVar[int]
    STATUS_FIELD_NUMBER: _ClassVar[int]
    tenant_id: str
    definition_id: str
    user_id: str
    definition: _workflows_types_pb2.WorkflowDefinitionInput
    status: _workflows_types_pb2.WorkflowDefinitionStatus
    def __init__(self, tenant_id: _Optional[str] = ..., definition_id: _Optional[str] = ..., user_id: _Optional[str] = ..., definition: _Optional[_Union[_workflows_types_pb2.WorkflowDefinitionInput, _Mapping]] = ..., status: _Optional[_Union[_workflows_types_pb2.WorkflowDefinitionStatus, str]] = ...) -> None: ...

class UpdateWorkflowDefinitionResponse(_message.Message):
    __slots__ = ()
    DEFINITION_FIELD_NUMBER: _ClassVar[int]
    definition: _workflows_types_pb2.WorkflowDefinition
    def __init__(self, definition: _Optional[_Union[_workflows_types_pb2.WorkflowDefinition, _Mapping]] = ...) -> None: ...

class GetWorkflowDefinitionRequest(_message.Message):
    __slots__ = ()
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    DEFINITION_ID_FIELD_NUMBER: _ClassVar[int]
    INCLUDE_VERSIONS_FIELD_NUMBER: _ClassVar[int]
    tenant_id: str
    definition_id: str
    include_versions: bool
    def __init__(self, tenant_id: _Optional[str] = ..., definition_id: _Optional[str] = ..., include_versions: _Optional[bool] = ...) -> None: ...

class GetWorkflowDefinitionResponse(_message.Message):
    __slots__ = ()
    DEFINITION_FIELD_NUMBER: _ClassVar[int]
    VERSIONS_FIELD_NUMBER: _ClassVar[int]
    definition: _workflows_types_pb2.WorkflowDefinition
    versions: _containers.RepeatedCompositeFieldContainer[_workflows_types_pb2.WorkflowVersion]
    def __init__(self, definition: _Optional[_Union[_workflows_types_pb2.WorkflowDefinition, _Mapping]] = ..., versions: _Optional[_Iterable[_Union[_workflows_types_pb2.WorkflowVersion, _Mapping]]] = ...) -> None: ...

class ListWorkflowDefinitionsRequest(_message.Message):
    __slots__ = ()
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    STATUS_FIELD_NUMBER: _ClassVar[int]
    QUERY_FIELD_NUMBER: _ClassVar[int]
    PAGE_SIZE_FIELD_NUMBER: _ClassVar[int]
    PAGE_TOKEN_FIELD_NUMBER: _ClassVar[int]
    tenant_id: str
    status: _workflows_types_pb2.WorkflowDefinitionStatus
    query: str
    page_size: int
    page_token: str
    def __init__(self, tenant_id: _Optional[str] = ..., status: _Optional[_Union[_workflows_types_pb2.WorkflowDefinitionStatus, str]] = ..., query: _Optional[str] = ..., page_size: _Optional[int] = ..., page_token: _Optional[str] = ...) -> None: ...

class ListWorkflowDefinitionsResponse(_message.Message):
    __slots__ = ()
    DEFINITIONS_FIELD_NUMBER: _ClassVar[int]
    NEXT_PAGE_TOKEN_FIELD_NUMBER: _ClassVar[int]
    definitions: _containers.RepeatedCompositeFieldContainer[_workflows_types_pb2.WorkflowDefinition]
    next_page_token: str
    def __init__(self, definitions: _Optional[_Iterable[_Union[_workflows_types_pb2.WorkflowDefinition, _Mapping]]] = ..., next_page_token: _Optional[str] = ...) -> None: ...

class CreateWorkflowVersionRequest(_message.Message):
    __slots__ = ()
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    DEFINITION_ID_FIELD_NUMBER: _ClassVar[int]
    USER_ID_FIELD_NUMBER: _ClassVar[int]
    VERSION_FIELD_NUMBER: _ClassVar[int]
    tenant_id: str
    definition_id: str
    user_id: str
    version: _workflows_types_pb2.WorkflowVersionInput
    def __init__(self, tenant_id: _Optional[str] = ..., definition_id: _Optional[str] = ..., user_id: _Optional[str] = ..., version: _Optional[_Union[_workflows_types_pb2.WorkflowVersionInput, _Mapping]] = ...) -> None: ...

class CreateWorkflowVersionResponse(_message.Message):
    __slots__ = ()
    VERSION_FIELD_NUMBER: _ClassVar[int]
    version: _workflows_types_pb2.WorkflowVersion
    def __init__(self, version: _Optional[_Union[_workflows_types_pb2.WorkflowVersion, _Mapping]] = ...) -> None: ...

class ListWorkflowVersionsRequest(_message.Message):
    __slots__ = ()
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    DEFINITION_ID_FIELD_NUMBER: _ClassVar[int]
    tenant_id: str
    definition_id: str
    def __init__(self, tenant_id: _Optional[str] = ..., definition_id: _Optional[str] = ...) -> None: ...

class ListWorkflowVersionsResponse(_message.Message):
    __slots__ = ()
    VERSIONS_FIELD_NUMBER: _ClassVar[int]
    versions: _containers.RepeatedCompositeFieldContainer[_workflows_types_pb2.WorkflowVersion]
    def __init__(self, versions: _Optional[_Iterable[_Union[_workflows_types_pb2.WorkflowVersion, _Mapping]]] = ...) -> None: ...

class StartWorkflowRunRequest(_message.Message):
    __slots__ = ()
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    DEFINITION_ID_FIELD_NUMBER: _ClassVar[int]
    VERSION_ID_FIELD_NUMBER: _ClassVar[int]
    WORKFLOWS_TYPE_FIELD_NUMBER: _ClassVar[int]
    TASK_QUEUE_FIELD_NUMBER: _ClassVar[int]
    INPUT_FIELD_NUMBER: _ClassVar[int]
    MEMO_FIELD_NUMBER: _ClassVar[int]
    SEARCH_ATTRIBUTES_FIELD_NUMBER: _ClassVar[int]
    USER_ID_FIELD_NUMBER: _ClassVar[int]
    WORKFLOWS_ID_FIELD_NUMBER: _ClassVar[int]
    tenant_id: str
    definition_id: str
    version_id: str
    workflows_type: str
    task_queue: str
    input: _containers.RepeatedCompositeFieldContainer[_struct_pb2.Value]
    memo: _struct_pb2.Struct
    search_attributes: _struct_pb2.Struct
    user_id: str
    workflows_id: str
    def __init__(self, tenant_id: _Optional[str] = ..., definition_id: _Optional[str] = ..., version_id: _Optional[str] = ..., workflows_type: _Optional[str] = ..., task_queue: _Optional[str] = ..., input: _Optional[_Iterable[_Union[_struct_pb2.Value, _Mapping]]] = ..., memo: _Optional[_Union[_struct_pb2.Struct, _Mapping]] = ..., search_attributes: _Optional[_Union[_struct_pb2.Struct, _Mapping]] = ..., user_id: _Optional[str] = ..., workflows_id: _Optional[str] = ...) -> None: ...

class StartWorkflowRunResponse(_message.Message):
    __slots__ = ()
    RUN_FIELD_NUMBER: _ClassVar[int]
    run: _workflows_types_pb2.WorkflowRun
    def __init__(self, run: _Optional[_Union[_workflows_types_pb2.WorkflowRun, _Mapping]] = ...) -> None: ...

class ListWorkflowRunsRequest(_message.Message):
    __slots__ = ()
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    DEFINITION_ID_FIELD_NUMBER: _ClassVar[int]
    ELEMENT_ID_FIELD_NUMBER: _ClassVar[int]
    STATUS_FIELD_NUMBER: _ClassVar[int]
    tenant_id: str
    definition_id: str
    element_id: str
    status: str
    def __init__(self, tenant_id: _Optional[str] = ..., definition_id: _Optional[str] = ..., element_id: _Optional[str] = ..., status: _Optional[str] = ...) -> None: ...

class ListWorkflowRunsResponse(_message.Message):
    __slots__ = ()
    RUNS_FIELD_NUMBER: _ClassVar[int]
    runs: _containers.RepeatedCompositeFieldContainer[_workflows_types_pb2.WorkflowRun]
    def __init__(self, runs: _Optional[_Iterable[_Union[_workflows_types_pb2.WorkflowRun, _Mapping]]] = ...) -> None: ...

class DescribeWorkflowRunRequest(_message.Message):
    __slots__ = ()
    WORKFLOWS_ID_FIELD_NUMBER: _ClassVar[int]
    workflows_id: str
    def __init__(self, workflows_id: _Optional[str] = ...) -> None: ...

class DescribeWorkflowRunResponse(_message.Message):
    __slots__ = ()
    RUN_FIELD_NUMBER: _ClassVar[int]
    run: _workflows_types_pb2.WorkflowRun
    def __init__(self, run: _Optional[_Union[_workflows_types_pb2.WorkflowRun, _Mapping]] = ...) -> None: ...

class CancelWorkflowRunRequest(_message.Message):
    __slots__ = ()
    WORKFLOWS_ID_FIELD_NUMBER: _ClassVar[int]
    workflows_id: str
    def __init__(self, workflows_id: _Optional[str] = ...) -> None: ...

class CancelWorkflowRunResponse(_message.Message):
    __slots__ = ()
    def __init__(self) -> None: ...

class ReportWorkflowStatusRequest(_message.Message):
    __slots__ = ()
    UPDATE_FIELD_NUMBER: _ClassVar[int]
    update: _workflows_types_pb2.WorkflowStatusUpdate
    def __init__(self, update: _Optional[_Union[_workflows_types_pb2.WorkflowStatusUpdate, _Mapping]] = ...) -> None: ...

class ReportWorkflowStatusResponse(_message.Message):
    __slots__ = ()
    def __init__(self) -> None: ...

class CreateWorkflowRuleRequest(_message.Message):
    __slots__ = ()
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    USER_ID_FIELD_NUMBER: _ClassVar[int]
    RULE_FIELD_NUMBER: _ClassVar[int]
    tenant_id: str
    user_id: str
    rule: _workflows_types_pb2.WorkflowRuleInput
    def __init__(self, tenant_id: _Optional[str] = ..., user_id: _Optional[str] = ..., rule: _Optional[_Union[_workflows_types_pb2.WorkflowRuleInput, _Mapping]] = ...) -> None: ...

class CreateWorkflowRuleResponse(_message.Message):
    __slots__ = ()
    RULE_FIELD_NUMBER: _ClassVar[int]
    rule: _workflows_types_pb2.WorkflowRule
    def __init__(self, rule: _Optional[_Union[_workflows_types_pb2.WorkflowRule, _Mapping]] = ...) -> None: ...

class UpdateWorkflowRuleRequest(_message.Message):
    __slots__ = ()
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    RULE_ID_FIELD_NUMBER: _ClassVar[int]
    USER_ID_FIELD_NUMBER: _ClassVar[int]
    PATCH_FIELD_NUMBER: _ClassVar[int]
    tenant_id: str
    rule_id: str
    user_id: str
    patch: _workflows_types_pb2.WorkflowRulePatch
    def __init__(self, tenant_id: _Optional[str] = ..., rule_id: _Optional[str] = ..., user_id: _Optional[str] = ..., patch: _Optional[_Union[_workflows_types_pb2.WorkflowRulePatch, _Mapping]] = ...) -> None: ...

class UpdateWorkflowRuleResponse(_message.Message):
    __slots__ = ()
    RULE_FIELD_NUMBER: _ClassVar[int]
    rule: _workflows_types_pb2.WorkflowRule
    def __init__(self, rule: _Optional[_Union[_workflows_types_pb2.WorkflowRule, _Mapping]] = ...) -> None: ...

class DeleteWorkflowRuleRequest(_message.Message):
    __slots__ = ()
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    RULE_ID_FIELD_NUMBER: _ClassVar[int]
    tenant_id: str
    rule_id: str
    def __init__(self, tenant_id: _Optional[str] = ..., rule_id: _Optional[str] = ...) -> None: ...

class DeleteWorkflowRuleResponse(_message.Message):
    __slots__ = ()
    def __init__(self) -> None: ...

class ListWorkflowRulesRequest(_message.Message):
    __slots__ = ()
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    GRAPH_ID_FIELD_NUMBER: _ClassVar[int]
    TRANSFORMATION_ID_FIELD_NUMBER: _ClassVar[int]
    ENABLED_ONLY_FIELD_NUMBER: _ClassVar[int]
    tenant_id: str
    graph_id: str
    transformation_id: str
    enabled_only: bool
    def __init__(self, tenant_id: _Optional[str] = ..., graph_id: _Optional[str] = ..., transformation_id: _Optional[str] = ..., enabled_only: _Optional[bool] = ...) -> None: ...

class ListWorkflowRulesResponse(_message.Message):
    __slots__ = ()
    RULES_FIELD_NUMBER: _ClassVar[int]
    rules: _containers.RepeatedCompositeFieldContainer[_workflows_types_pb2.WorkflowRule]
    def __init__(self, rules: _Optional[_Iterable[_Union[_workflows_types_pb2.WorkflowRule, _Mapping]]] = ...) -> None: ...

class GetWorkflowRuleRequest(_message.Message):
    __slots__ = ()
    TENANT_ID_FIELD_NUMBER: _ClassVar[int]
    RULE_ID_FIELD_NUMBER: _ClassVar[int]
    tenant_id: str
    rule_id: str
    def __init__(self, tenant_id: _Optional[str] = ..., rule_id: _Optional[str] = ...) -> None: ...

class GetWorkflowRuleResponse(_message.Message):
    __slots__ = ()
    RULE_FIELD_NUMBER: _ClassVar[int]
    rule: _workflows_types_pb2.WorkflowRule
    def __init__(self, rule: _Optional[_Union[_workflows_types_pb2.WorkflowRule, _Mapping]] = ...) -> None: ...
