# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TenantArgs', 'Tenant']

@pulumi.input_type
class TenantArgs:
    def __init__(__self__, *,
                 allowed_logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 change_password: Optional[pulumi.Input['TenantChangePasswordArgs']] = None,
                 default_audience: Optional[pulumi.Input[str]] = None,
                 default_directory: Optional[pulumi.Input[str]] = None,
                 default_redirection_uri: Optional[pulumi.Input[str]] = None,
                 enabled_locales: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 error_page: Optional[pulumi.Input['TenantErrorPageArgs']] = None,
                 flags: Optional[pulumi.Input['TenantFlagsArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 guardian_mfa_page: Optional[pulumi.Input['TenantGuardianMfaPageArgs']] = None,
                 idle_session_lifetime: Optional[pulumi.Input[float]] = None,
                 picture_url: Optional[pulumi.Input[str]] = None,
                 sandbox_version: Optional[pulumi.Input[str]] = None,
                 session_cookie: Optional[pulumi.Input['TenantSessionCookieArgs']] = None,
                 session_lifetime: Optional[pulumi.Input[float]] = None,
                 support_email: Optional[pulumi.Input[str]] = None,
                 support_url: Optional[pulumi.Input[str]] = None,
                 universal_login: Optional[pulumi.Input['TenantUniversalLoginArgs']] = None):
        """
        The set of arguments for constructing a Tenant resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_logout_urls: URLs that Auth0 may redirect to after logout.
        :param pulumi.Input['TenantChangePasswordArgs'] change_password: Configuration settings for change password page. This attribute is deprecated in favor of the `auth0_pages` resource and
               it will be removed in a future major version. Check the
               [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more
               info.
        :param pulumi.Input[str] default_audience: API Audience to use by default for API Authorization flows. This setting is equivalent to appending the audience to every authorization request made to the tenant for every application.
        :param pulumi.Input[str] default_directory: Name of the connection to be used for Password Grant exchanges. Options include `auth0-adldap`, `ad`, `auth0`, `email`, `sms`, `waad`, and `adfs`.
        :param pulumi.Input[str] default_redirection_uri: The default absolute redirection URI. Must be HTTPS or an empty string.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_locales: Supported locales for the user interface. The first locale in the list will be used to set the default locale.
        :param pulumi.Input['TenantErrorPageArgs'] error_page: Configuration settings for error pages. This attribute is deprecated in favor of the `auth0_pages` resource and it will
               be removed in a future major version. Check the
               [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more
               info.
        :param pulumi.Input['TenantFlagsArgs'] flags: Configuration settings for tenant flags.
        :param pulumi.Input[str] friendly_name: Friendly name for the tenant.
        :param pulumi.Input['TenantGuardianMfaPageArgs'] guardian_mfa_page: Configuration settings for the Guardian MFA page. This attribute is deprecated in favor of the `auth0_pages` resource
               and it will be removed in a future major version. Check the
               [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more
               info.
        :param pulumi.Input[float] idle_session_lifetime: Number of hours during which a session can be inactive before the user must log in again.
        :param pulumi.Input[str] picture_url: URL of logo to be shown for the tenant. Recommended size is 150px x 150px. If no URL is provided, the Auth0 logo will be used.
        :param pulumi.Input[str] sandbox_version: Selected sandbox version for the extensibility environment, which allows you to use custom scripts to extend parts of Auth0's functionality.
        :param pulumi.Input['TenantSessionCookieArgs'] session_cookie: Alters behavior of tenant's session cookie. Contains a single `mode` property.
        :param pulumi.Input[float] session_lifetime: Number of hours during which a session will stay valid.
        :param pulumi.Input[str] support_email: Support email address for authenticating users.
        :param pulumi.Input[str] support_url: Support URL for authenticating users.
        :param pulumi.Input['TenantUniversalLoginArgs'] universal_login: Configuration settings for Universal Login. These configuration settings have been deprecated. Migrate to managing these
               settings through the `auth0_branding` resource. Check the
               [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-universal-login)
               for more info.
        """
        if allowed_logout_urls is not None:
            pulumi.set(__self__, "allowed_logout_urls", allowed_logout_urls)
        if change_password is not None:
            warnings.warn("""This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""", DeprecationWarning)
            pulumi.log.warn("""change_password is deprecated: This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""")
        if change_password is not None:
            pulumi.set(__self__, "change_password", change_password)
        if default_audience is not None:
            pulumi.set(__self__, "default_audience", default_audience)
        if default_directory is not None:
            pulumi.set(__self__, "default_directory", default_directory)
        if default_redirection_uri is not None:
            pulumi.set(__self__, "default_redirection_uri", default_redirection_uri)
        if enabled_locales is not None:
            pulumi.set(__self__, "enabled_locales", enabled_locales)
        if error_page is not None:
            warnings.warn("""This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""", DeprecationWarning)
            pulumi.log.warn("""error_page is deprecated: This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""")
        if error_page is not None:
            pulumi.set(__self__, "error_page", error_page)
        if flags is not None:
            pulumi.set(__self__, "flags", flags)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if guardian_mfa_page is not None:
            warnings.warn("""This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""", DeprecationWarning)
            pulumi.log.warn("""guardian_mfa_page is deprecated: This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""")
        if guardian_mfa_page is not None:
            pulumi.set(__self__, "guardian_mfa_page", guardian_mfa_page)
        if idle_session_lifetime is not None:
            pulumi.set(__self__, "idle_session_lifetime", idle_session_lifetime)
        if picture_url is not None:
            pulumi.set(__self__, "picture_url", picture_url)
        if sandbox_version is not None:
            pulumi.set(__self__, "sandbox_version", sandbox_version)
        if session_cookie is not None:
            pulumi.set(__self__, "session_cookie", session_cookie)
        if session_lifetime is not None:
            pulumi.set(__self__, "session_lifetime", session_lifetime)
        if support_email is not None:
            pulumi.set(__self__, "support_email", support_email)
        if support_url is not None:
            pulumi.set(__self__, "support_url", support_url)
        if universal_login is not None:
            warnings.warn("""These configuration settings have been deprecated. Migrate to managing these settings through the `auth0_branding` resource. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-universal-login) for more info.""", DeprecationWarning)
            pulumi.log.warn("""universal_login is deprecated: These configuration settings have been deprecated. Migrate to managing these settings through the `auth0_branding` resource. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-universal-login) for more info.""")
        if universal_login is not None:
            pulumi.set(__self__, "universal_login", universal_login)

    @property
    @pulumi.getter(name="allowedLogoutUrls")
    def allowed_logout_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        URLs that Auth0 may redirect to after logout.
        """
        return pulumi.get(self, "allowed_logout_urls")

    @allowed_logout_urls.setter
    def allowed_logout_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_logout_urls", value)

    @property
    @pulumi.getter(name="changePassword")
    def change_password(self) -> Optional[pulumi.Input['TenantChangePasswordArgs']]:
        """
        Configuration settings for change password page. This attribute is deprecated in favor of the `auth0_pages` resource and
        it will be removed in a future major version. Check the
        [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more
        info.
        """
        warnings.warn("""This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""", DeprecationWarning)
        pulumi.log.warn("""change_password is deprecated: This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""")

        return pulumi.get(self, "change_password")

    @change_password.setter
    def change_password(self, value: Optional[pulumi.Input['TenantChangePasswordArgs']]):
        pulumi.set(self, "change_password", value)

    @property
    @pulumi.getter(name="defaultAudience")
    def default_audience(self) -> Optional[pulumi.Input[str]]:
        """
        API Audience to use by default for API Authorization flows. This setting is equivalent to appending the audience to every authorization request made to the tenant for every application.
        """
        return pulumi.get(self, "default_audience")

    @default_audience.setter
    def default_audience(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_audience", value)

    @property
    @pulumi.getter(name="defaultDirectory")
    def default_directory(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the connection to be used for Password Grant exchanges. Options include `auth0-adldap`, `ad`, `auth0`, `email`, `sms`, `waad`, and `adfs`.
        """
        return pulumi.get(self, "default_directory")

    @default_directory.setter
    def default_directory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_directory", value)

    @property
    @pulumi.getter(name="defaultRedirectionUri")
    def default_redirection_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The default absolute redirection URI. Must be HTTPS or an empty string.
        """
        return pulumi.get(self, "default_redirection_uri")

    @default_redirection_uri.setter
    def default_redirection_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_redirection_uri", value)

    @property
    @pulumi.getter(name="enabledLocales")
    def enabled_locales(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Supported locales for the user interface. The first locale in the list will be used to set the default locale.
        """
        return pulumi.get(self, "enabled_locales")

    @enabled_locales.setter
    def enabled_locales(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "enabled_locales", value)

    @property
    @pulumi.getter(name="errorPage")
    def error_page(self) -> Optional[pulumi.Input['TenantErrorPageArgs']]:
        """
        Configuration settings for error pages. This attribute is deprecated in favor of the `auth0_pages` resource and it will
        be removed in a future major version. Check the
        [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more
        info.
        """
        warnings.warn("""This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""", DeprecationWarning)
        pulumi.log.warn("""error_page is deprecated: This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""")

        return pulumi.get(self, "error_page")

    @error_page.setter
    def error_page(self, value: Optional[pulumi.Input['TenantErrorPageArgs']]):
        pulumi.set(self, "error_page", value)

    @property
    @pulumi.getter
    def flags(self) -> Optional[pulumi.Input['TenantFlagsArgs']]:
        """
        Configuration settings for tenant flags.
        """
        return pulumi.get(self, "flags")

    @flags.setter
    def flags(self, value: Optional[pulumi.Input['TenantFlagsArgs']]):
        pulumi.set(self, "flags", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name for the tenant.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="guardianMfaPage")
    def guardian_mfa_page(self) -> Optional[pulumi.Input['TenantGuardianMfaPageArgs']]:
        """
        Configuration settings for the Guardian MFA page. This attribute is deprecated in favor of the `auth0_pages` resource
        and it will be removed in a future major version. Check the
        [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more
        info.
        """
        warnings.warn("""This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""", DeprecationWarning)
        pulumi.log.warn("""guardian_mfa_page is deprecated: This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""")

        return pulumi.get(self, "guardian_mfa_page")

    @guardian_mfa_page.setter
    def guardian_mfa_page(self, value: Optional[pulumi.Input['TenantGuardianMfaPageArgs']]):
        pulumi.set(self, "guardian_mfa_page", value)

    @property
    @pulumi.getter(name="idleSessionLifetime")
    def idle_session_lifetime(self) -> Optional[pulumi.Input[float]]:
        """
        Number of hours during which a session can be inactive before the user must log in again.
        """
        return pulumi.get(self, "idle_session_lifetime")

    @idle_session_lifetime.setter
    def idle_session_lifetime(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "idle_session_lifetime", value)

    @property
    @pulumi.getter(name="pictureUrl")
    def picture_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL of logo to be shown for the tenant. Recommended size is 150px x 150px. If no URL is provided, the Auth0 logo will be used.
        """
        return pulumi.get(self, "picture_url")

    @picture_url.setter
    def picture_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "picture_url", value)

    @property
    @pulumi.getter(name="sandboxVersion")
    def sandbox_version(self) -> Optional[pulumi.Input[str]]:
        """
        Selected sandbox version for the extensibility environment, which allows you to use custom scripts to extend parts of Auth0's functionality.
        """
        return pulumi.get(self, "sandbox_version")

    @sandbox_version.setter
    def sandbox_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sandbox_version", value)

    @property
    @pulumi.getter(name="sessionCookie")
    def session_cookie(self) -> Optional[pulumi.Input['TenantSessionCookieArgs']]:
        """
        Alters behavior of tenant's session cookie. Contains a single `mode` property.
        """
        return pulumi.get(self, "session_cookie")

    @session_cookie.setter
    def session_cookie(self, value: Optional[pulumi.Input['TenantSessionCookieArgs']]):
        pulumi.set(self, "session_cookie", value)

    @property
    @pulumi.getter(name="sessionLifetime")
    def session_lifetime(self) -> Optional[pulumi.Input[float]]:
        """
        Number of hours during which a session will stay valid.
        """
        return pulumi.get(self, "session_lifetime")

    @session_lifetime.setter
    def session_lifetime(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "session_lifetime", value)

    @property
    @pulumi.getter(name="supportEmail")
    def support_email(self) -> Optional[pulumi.Input[str]]:
        """
        Support email address for authenticating users.
        """
        return pulumi.get(self, "support_email")

    @support_email.setter
    def support_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "support_email", value)

    @property
    @pulumi.getter(name="supportUrl")
    def support_url(self) -> Optional[pulumi.Input[str]]:
        """
        Support URL for authenticating users.
        """
        return pulumi.get(self, "support_url")

    @support_url.setter
    def support_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "support_url", value)

    @property
    @pulumi.getter(name="universalLogin")
    def universal_login(self) -> Optional[pulumi.Input['TenantUniversalLoginArgs']]:
        """
        Configuration settings for Universal Login. These configuration settings have been deprecated. Migrate to managing these
        settings through the `auth0_branding` resource. Check the
        [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-universal-login)
        for more info.
        """
        warnings.warn("""These configuration settings have been deprecated. Migrate to managing these settings through the `auth0_branding` resource. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-universal-login) for more info.""", DeprecationWarning)
        pulumi.log.warn("""universal_login is deprecated: These configuration settings have been deprecated. Migrate to managing these settings through the `auth0_branding` resource. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-universal-login) for more info.""")

        return pulumi.get(self, "universal_login")

    @universal_login.setter
    def universal_login(self, value: Optional[pulumi.Input['TenantUniversalLoginArgs']]):
        pulumi.set(self, "universal_login", value)


@pulumi.input_type
class _TenantState:
    def __init__(__self__, *,
                 allowed_logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 change_password: Optional[pulumi.Input['TenantChangePasswordArgs']] = None,
                 default_audience: Optional[pulumi.Input[str]] = None,
                 default_directory: Optional[pulumi.Input[str]] = None,
                 default_redirection_uri: Optional[pulumi.Input[str]] = None,
                 enabled_locales: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 error_page: Optional[pulumi.Input['TenantErrorPageArgs']] = None,
                 flags: Optional[pulumi.Input['TenantFlagsArgs']] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 guardian_mfa_page: Optional[pulumi.Input['TenantGuardianMfaPageArgs']] = None,
                 idle_session_lifetime: Optional[pulumi.Input[float]] = None,
                 picture_url: Optional[pulumi.Input[str]] = None,
                 sandbox_version: Optional[pulumi.Input[str]] = None,
                 session_cookie: Optional[pulumi.Input['TenantSessionCookieArgs']] = None,
                 session_lifetime: Optional[pulumi.Input[float]] = None,
                 support_email: Optional[pulumi.Input[str]] = None,
                 support_url: Optional[pulumi.Input[str]] = None,
                 universal_login: Optional[pulumi.Input['TenantUniversalLoginArgs']] = None):
        """
        Input properties used for looking up and filtering Tenant resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_logout_urls: URLs that Auth0 may redirect to after logout.
        :param pulumi.Input['TenantChangePasswordArgs'] change_password: Configuration settings for change password page. This attribute is deprecated in favor of the `auth0_pages` resource and
               it will be removed in a future major version. Check the
               [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more
               info.
        :param pulumi.Input[str] default_audience: API Audience to use by default for API Authorization flows. This setting is equivalent to appending the audience to every authorization request made to the tenant for every application.
        :param pulumi.Input[str] default_directory: Name of the connection to be used for Password Grant exchanges. Options include `auth0-adldap`, `ad`, `auth0`, `email`, `sms`, `waad`, and `adfs`.
        :param pulumi.Input[str] default_redirection_uri: The default absolute redirection URI. Must be HTTPS or an empty string.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_locales: Supported locales for the user interface. The first locale in the list will be used to set the default locale.
        :param pulumi.Input['TenantErrorPageArgs'] error_page: Configuration settings for error pages. This attribute is deprecated in favor of the `auth0_pages` resource and it will
               be removed in a future major version. Check the
               [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more
               info.
        :param pulumi.Input['TenantFlagsArgs'] flags: Configuration settings for tenant flags.
        :param pulumi.Input[str] friendly_name: Friendly name for the tenant.
        :param pulumi.Input['TenantGuardianMfaPageArgs'] guardian_mfa_page: Configuration settings for the Guardian MFA page. This attribute is deprecated in favor of the `auth0_pages` resource
               and it will be removed in a future major version. Check the
               [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more
               info.
        :param pulumi.Input[float] idle_session_lifetime: Number of hours during which a session can be inactive before the user must log in again.
        :param pulumi.Input[str] picture_url: URL of logo to be shown for the tenant. Recommended size is 150px x 150px. If no URL is provided, the Auth0 logo will be used.
        :param pulumi.Input[str] sandbox_version: Selected sandbox version for the extensibility environment, which allows you to use custom scripts to extend parts of Auth0's functionality.
        :param pulumi.Input['TenantSessionCookieArgs'] session_cookie: Alters behavior of tenant's session cookie. Contains a single `mode` property.
        :param pulumi.Input[float] session_lifetime: Number of hours during which a session will stay valid.
        :param pulumi.Input[str] support_email: Support email address for authenticating users.
        :param pulumi.Input[str] support_url: Support URL for authenticating users.
        :param pulumi.Input['TenantUniversalLoginArgs'] universal_login: Configuration settings for Universal Login. These configuration settings have been deprecated. Migrate to managing these
               settings through the `auth0_branding` resource. Check the
               [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-universal-login)
               for more info.
        """
        if allowed_logout_urls is not None:
            pulumi.set(__self__, "allowed_logout_urls", allowed_logout_urls)
        if change_password is not None:
            warnings.warn("""This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""", DeprecationWarning)
            pulumi.log.warn("""change_password is deprecated: This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""")
        if change_password is not None:
            pulumi.set(__self__, "change_password", change_password)
        if default_audience is not None:
            pulumi.set(__self__, "default_audience", default_audience)
        if default_directory is not None:
            pulumi.set(__self__, "default_directory", default_directory)
        if default_redirection_uri is not None:
            pulumi.set(__self__, "default_redirection_uri", default_redirection_uri)
        if enabled_locales is not None:
            pulumi.set(__self__, "enabled_locales", enabled_locales)
        if error_page is not None:
            warnings.warn("""This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""", DeprecationWarning)
            pulumi.log.warn("""error_page is deprecated: This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""")
        if error_page is not None:
            pulumi.set(__self__, "error_page", error_page)
        if flags is not None:
            pulumi.set(__self__, "flags", flags)
        if friendly_name is not None:
            pulumi.set(__self__, "friendly_name", friendly_name)
        if guardian_mfa_page is not None:
            warnings.warn("""This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""", DeprecationWarning)
            pulumi.log.warn("""guardian_mfa_page is deprecated: This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""")
        if guardian_mfa_page is not None:
            pulumi.set(__self__, "guardian_mfa_page", guardian_mfa_page)
        if idle_session_lifetime is not None:
            pulumi.set(__self__, "idle_session_lifetime", idle_session_lifetime)
        if picture_url is not None:
            pulumi.set(__self__, "picture_url", picture_url)
        if sandbox_version is not None:
            pulumi.set(__self__, "sandbox_version", sandbox_version)
        if session_cookie is not None:
            pulumi.set(__self__, "session_cookie", session_cookie)
        if session_lifetime is not None:
            pulumi.set(__self__, "session_lifetime", session_lifetime)
        if support_email is not None:
            pulumi.set(__self__, "support_email", support_email)
        if support_url is not None:
            pulumi.set(__self__, "support_url", support_url)
        if universal_login is not None:
            warnings.warn("""These configuration settings have been deprecated. Migrate to managing these settings through the `auth0_branding` resource. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-universal-login) for more info.""", DeprecationWarning)
            pulumi.log.warn("""universal_login is deprecated: These configuration settings have been deprecated. Migrate to managing these settings through the `auth0_branding` resource. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-universal-login) for more info.""")
        if universal_login is not None:
            pulumi.set(__self__, "universal_login", universal_login)

    @property
    @pulumi.getter(name="allowedLogoutUrls")
    def allowed_logout_urls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        URLs that Auth0 may redirect to after logout.
        """
        return pulumi.get(self, "allowed_logout_urls")

    @allowed_logout_urls.setter
    def allowed_logout_urls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_logout_urls", value)

    @property
    @pulumi.getter(name="changePassword")
    def change_password(self) -> Optional[pulumi.Input['TenantChangePasswordArgs']]:
        """
        Configuration settings for change password page. This attribute is deprecated in favor of the `auth0_pages` resource and
        it will be removed in a future major version. Check the
        [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more
        info.
        """
        warnings.warn("""This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""", DeprecationWarning)
        pulumi.log.warn("""change_password is deprecated: This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""")

        return pulumi.get(self, "change_password")

    @change_password.setter
    def change_password(self, value: Optional[pulumi.Input['TenantChangePasswordArgs']]):
        pulumi.set(self, "change_password", value)

    @property
    @pulumi.getter(name="defaultAudience")
    def default_audience(self) -> Optional[pulumi.Input[str]]:
        """
        API Audience to use by default for API Authorization flows. This setting is equivalent to appending the audience to every authorization request made to the tenant for every application.
        """
        return pulumi.get(self, "default_audience")

    @default_audience.setter
    def default_audience(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_audience", value)

    @property
    @pulumi.getter(name="defaultDirectory")
    def default_directory(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the connection to be used for Password Grant exchanges. Options include `auth0-adldap`, `ad`, `auth0`, `email`, `sms`, `waad`, and `adfs`.
        """
        return pulumi.get(self, "default_directory")

    @default_directory.setter
    def default_directory(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_directory", value)

    @property
    @pulumi.getter(name="defaultRedirectionUri")
    def default_redirection_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The default absolute redirection URI. Must be HTTPS or an empty string.
        """
        return pulumi.get(self, "default_redirection_uri")

    @default_redirection_uri.setter
    def default_redirection_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_redirection_uri", value)

    @property
    @pulumi.getter(name="enabledLocales")
    def enabled_locales(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Supported locales for the user interface. The first locale in the list will be used to set the default locale.
        """
        return pulumi.get(self, "enabled_locales")

    @enabled_locales.setter
    def enabled_locales(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "enabled_locales", value)

    @property
    @pulumi.getter(name="errorPage")
    def error_page(self) -> Optional[pulumi.Input['TenantErrorPageArgs']]:
        """
        Configuration settings for error pages. This attribute is deprecated in favor of the `auth0_pages` resource and it will
        be removed in a future major version. Check the
        [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more
        info.
        """
        warnings.warn("""This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""", DeprecationWarning)
        pulumi.log.warn("""error_page is deprecated: This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""")

        return pulumi.get(self, "error_page")

    @error_page.setter
    def error_page(self, value: Optional[pulumi.Input['TenantErrorPageArgs']]):
        pulumi.set(self, "error_page", value)

    @property
    @pulumi.getter
    def flags(self) -> Optional[pulumi.Input['TenantFlagsArgs']]:
        """
        Configuration settings for tenant flags.
        """
        return pulumi.get(self, "flags")

    @flags.setter
    def flags(self, value: Optional[pulumi.Input['TenantFlagsArgs']]):
        pulumi.set(self, "flags", value)

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> Optional[pulumi.Input[str]]:
        """
        Friendly name for the tenant.
        """
        return pulumi.get(self, "friendly_name")

    @friendly_name.setter
    def friendly_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "friendly_name", value)

    @property
    @pulumi.getter(name="guardianMfaPage")
    def guardian_mfa_page(self) -> Optional[pulumi.Input['TenantGuardianMfaPageArgs']]:
        """
        Configuration settings for the Guardian MFA page. This attribute is deprecated in favor of the `auth0_pages` resource
        and it will be removed in a future major version. Check the
        [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more
        info.
        """
        warnings.warn("""This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""", DeprecationWarning)
        pulumi.log.warn("""guardian_mfa_page is deprecated: This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""")

        return pulumi.get(self, "guardian_mfa_page")

    @guardian_mfa_page.setter
    def guardian_mfa_page(self, value: Optional[pulumi.Input['TenantGuardianMfaPageArgs']]):
        pulumi.set(self, "guardian_mfa_page", value)

    @property
    @pulumi.getter(name="idleSessionLifetime")
    def idle_session_lifetime(self) -> Optional[pulumi.Input[float]]:
        """
        Number of hours during which a session can be inactive before the user must log in again.
        """
        return pulumi.get(self, "idle_session_lifetime")

    @idle_session_lifetime.setter
    def idle_session_lifetime(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "idle_session_lifetime", value)

    @property
    @pulumi.getter(name="pictureUrl")
    def picture_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL of logo to be shown for the tenant. Recommended size is 150px x 150px. If no URL is provided, the Auth0 logo will be used.
        """
        return pulumi.get(self, "picture_url")

    @picture_url.setter
    def picture_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "picture_url", value)

    @property
    @pulumi.getter(name="sandboxVersion")
    def sandbox_version(self) -> Optional[pulumi.Input[str]]:
        """
        Selected sandbox version for the extensibility environment, which allows you to use custom scripts to extend parts of Auth0's functionality.
        """
        return pulumi.get(self, "sandbox_version")

    @sandbox_version.setter
    def sandbox_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sandbox_version", value)

    @property
    @pulumi.getter(name="sessionCookie")
    def session_cookie(self) -> Optional[pulumi.Input['TenantSessionCookieArgs']]:
        """
        Alters behavior of tenant's session cookie. Contains a single `mode` property.
        """
        return pulumi.get(self, "session_cookie")

    @session_cookie.setter
    def session_cookie(self, value: Optional[pulumi.Input['TenantSessionCookieArgs']]):
        pulumi.set(self, "session_cookie", value)

    @property
    @pulumi.getter(name="sessionLifetime")
    def session_lifetime(self) -> Optional[pulumi.Input[float]]:
        """
        Number of hours during which a session will stay valid.
        """
        return pulumi.get(self, "session_lifetime")

    @session_lifetime.setter
    def session_lifetime(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "session_lifetime", value)

    @property
    @pulumi.getter(name="supportEmail")
    def support_email(self) -> Optional[pulumi.Input[str]]:
        """
        Support email address for authenticating users.
        """
        return pulumi.get(self, "support_email")

    @support_email.setter
    def support_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "support_email", value)

    @property
    @pulumi.getter(name="supportUrl")
    def support_url(self) -> Optional[pulumi.Input[str]]:
        """
        Support URL for authenticating users.
        """
        return pulumi.get(self, "support_url")

    @support_url.setter
    def support_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "support_url", value)

    @property
    @pulumi.getter(name="universalLogin")
    def universal_login(self) -> Optional[pulumi.Input['TenantUniversalLoginArgs']]:
        """
        Configuration settings for Universal Login. These configuration settings have been deprecated. Migrate to managing these
        settings through the `auth0_branding` resource. Check the
        [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-universal-login)
        for more info.
        """
        warnings.warn("""These configuration settings have been deprecated. Migrate to managing these settings through the `auth0_branding` resource. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-universal-login) for more info.""", DeprecationWarning)
        pulumi.log.warn("""universal_login is deprecated: These configuration settings have been deprecated. Migrate to managing these settings through the `auth0_branding` resource. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-universal-login) for more info.""")

        return pulumi.get(self, "universal_login")

    @universal_login.setter
    def universal_login(self, value: Optional[pulumi.Input['TenantUniversalLoginArgs']]):
        pulumi.set(self, "universal_login", value)


class Tenant(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 change_password: Optional[pulumi.Input[pulumi.InputType['TenantChangePasswordArgs']]] = None,
                 default_audience: Optional[pulumi.Input[str]] = None,
                 default_directory: Optional[pulumi.Input[str]] = None,
                 default_redirection_uri: Optional[pulumi.Input[str]] = None,
                 enabled_locales: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 error_page: Optional[pulumi.Input[pulumi.InputType['TenantErrorPageArgs']]] = None,
                 flags: Optional[pulumi.Input[pulumi.InputType['TenantFlagsArgs']]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 guardian_mfa_page: Optional[pulumi.Input[pulumi.InputType['TenantGuardianMfaPageArgs']]] = None,
                 idle_session_lifetime: Optional[pulumi.Input[float]] = None,
                 picture_url: Optional[pulumi.Input[str]] = None,
                 sandbox_version: Optional[pulumi.Input[str]] = None,
                 session_cookie: Optional[pulumi.Input[pulumi.InputType['TenantSessionCookieArgs']]] = None,
                 session_lifetime: Optional[pulumi.Input[float]] = None,
                 support_email: Optional[pulumi.Input[str]] = None,
                 support_url: Optional[pulumi.Input[str]] = None,
                 universal_login: Optional[pulumi.Input[pulumi.InputType['TenantUniversalLoginArgs']]] = None,
                 __props__=None):
        """
        With this resource, you can manage Auth0 tenants, including setting logos and support contact information, setting error pages, and configuring default tenant behaviors.

        > Creating tenants through the Management API is not currently supported. Therefore, this resource can only
        manage an existing tenant created through the Auth0 dashboard.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        my_tenant = auth0.Tenant("myTenant",
            allowed_logout_urls=["http://example.com/logout"],
            change_password=auth0.TenantChangePasswordArgs(
                enabled=True,
                html="<html>Change Password</html>",
            ),
            default_redirection_uri="https://example.com/login",
            enabled_locales=["en"],
            error_page=auth0.TenantErrorPageArgs(
                html="<html>Error Page</html>",
                show_log_link=True,
                url="https://example.com/errors",
            ),
            flags=auth0.TenantFlagsArgs(
                disable_clickjack_protection_headers=True,
                disable_fields_map_fix=False,
                disable_management_api_sms_obfuscation=False,
                enable_public_signup_user_exists_error=True,
                no_disclose_enterprise_connections=False,
                universal_login=True,
                use_scope_descriptions_for_consent=True,
            ),
            friendly_name="Tenant Name",
            guardian_mfa_page=auth0.TenantGuardianMfaPageArgs(
                enabled=True,
                html="<html>MFA</html>",
            ),
            picture_url="http://example.com/logo.png",
            sandbox_version="12",
            session_cookie=auth0.TenantSessionCookieArgs(
                mode="non-persistent",
            ),
            session_lifetime=8760,
            support_email="support@example.com",
            support_url="http://example.com/support",
            universal_login=auth0.TenantUniversalLoginArgs(
                colors=auth0.TenantUniversalLoginColorsArgs(
                    page_background="#000000",
                    primary="#0059d6",
                ),
            ))
        ```

        ## Import

        As this is not a resource identifiable by an ID within the Auth0 Management API, tenant can be imported using a random string. # We recommend [Version 4 UUID](https://www.uuidgenerator.net/version4) # Example

        ```sh
         $ pulumi import auth0:index/tenant:Tenant my_tenant 82f4f21b-017a-319d-92e7-2291c1ca36c4
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_logout_urls: URLs that Auth0 may redirect to after logout.
        :param pulumi.Input[pulumi.InputType['TenantChangePasswordArgs']] change_password: Configuration settings for change password page. This attribute is deprecated in favor of the `auth0_pages` resource and
               it will be removed in a future major version. Check the
               [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more
               info.
        :param pulumi.Input[str] default_audience: API Audience to use by default for API Authorization flows. This setting is equivalent to appending the audience to every authorization request made to the tenant for every application.
        :param pulumi.Input[str] default_directory: Name of the connection to be used for Password Grant exchanges. Options include `auth0-adldap`, `ad`, `auth0`, `email`, `sms`, `waad`, and `adfs`.
        :param pulumi.Input[str] default_redirection_uri: The default absolute redirection URI. Must be HTTPS or an empty string.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_locales: Supported locales for the user interface. The first locale in the list will be used to set the default locale.
        :param pulumi.Input[pulumi.InputType['TenantErrorPageArgs']] error_page: Configuration settings for error pages. This attribute is deprecated in favor of the `auth0_pages` resource and it will
               be removed in a future major version. Check the
               [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more
               info.
        :param pulumi.Input[pulumi.InputType['TenantFlagsArgs']] flags: Configuration settings for tenant flags.
        :param pulumi.Input[str] friendly_name: Friendly name for the tenant.
        :param pulumi.Input[pulumi.InputType['TenantGuardianMfaPageArgs']] guardian_mfa_page: Configuration settings for the Guardian MFA page. This attribute is deprecated in favor of the `auth0_pages` resource
               and it will be removed in a future major version. Check the
               [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more
               info.
        :param pulumi.Input[float] idle_session_lifetime: Number of hours during which a session can be inactive before the user must log in again.
        :param pulumi.Input[str] picture_url: URL of logo to be shown for the tenant. Recommended size is 150px x 150px. If no URL is provided, the Auth0 logo will be used.
        :param pulumi.Input[str] sandbox_version: Selected sandbox version for the extensibility environment, which allows you to use custom scripts to extend parts of Auth0's functionality.
        :param pulumi.Input[pulumi.InputType['TenantSessionCookieArgs']] session_cookie: Alters behavior of tenant's session cookie. Contains a single `mode` property.
        :param pulumi.Input[float] session_lifetime: Number of hours during which a session will stay valid.
        :param pulumi.Input[str] support_email: Support email address for authenticating users.
        :param pulumi.Input[str] support_url: Support URL for authenticating users.
        :param pulumi.Input[pulumi.InputType['TenantUniversalLoginArgs']] universal_login: Configuration settings for Universal Login. These configuration settings have been deprecated. Migrate to managing these
               settings through the `auth0_branding` resource. Check the
               [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-universal-login)
               for more info.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[TenantArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        With this resource, you can manage Auth0 tenants, including setting logos and support contact information, setting error pages, and configuring default tenant behaviors.

        > Creating tenants through the Management API is not currently supported. Therefore, this resource can only
        manage an existing tenant created through the Auth0 dashboard.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        my_tenant = auth0.Tenant("myTenant",
            allowed_logout_urls=["http://example.com/logout"],
            change_password=auth0.TenantChangePasswordArgs(
                enabled=True,
                html="<html>Change Password</html>",
            ),
            default_redirection_uri="https://example.com/login",
            enabled_locales=["en"],
            error_page=auth0.TenantErrorPageArgs(
                html="<html>Error Page</html>",
                show_log_link=True,
                url="https://example.com/errors",
            ),
            flags=auth0.TenantFlagsArgs(
                disable_clickjack_protection_headers=True,
                disable_fields_map_fix=False,
                disable_management_api_sms_obfuscation=False,
                enable_public_signup_user_exists_error=True,
                no_disclose_enterprise_connections=False,
                universal_login=True,
                use_scope_descriptions_for_consent=True,
            ),
            friendly_name="Tenant Name",
            guardian_mfa_page=auth0.TenantGuardianMfaPageArgs(
                enabled=True,
                html="<html>MFA</html>",
            ),
            picture_url="http://example.com/logo.png",
            sandbox_version="12",
            session_cookie=auth0.TenantSessionCookieArgs(
                mode="non-persistent",
            ),
            session_lifetime=8760,
            support_email="support@example.com",
            support_url="http://example.com/support",
            universal_login=auth0.TenantUniversalLoginArgs(
                colors=auth0.TenantUniversalLoginColorsArgs(
                    page_background="#000000",
                    primary="#0059d6",
                ),
            ))
        ```

        ## Import

        As this is not a resource identifiable by an ID within the Auth0 Management API, tenant can be imported using a random string. # We recommend [Version 4 UUID](https://www.uuidgenerator.net/version4) # Example

        ```sh
         $ pulumi import auth0:index/tenant:Tenant my_tenant 82f4f21b-017a-319d-92e7-2291c1ca36c4
        ```

        :param str resource_name: The name of the resource.
        :param TenantArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TenantArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 change_password: Optional[pulumi.Input[pulumi.InputType['TenantChangePasswordArgs']]] = None,
                 default_audience: Optional[pulumi.Input[str]] = None,
                 default_directory: Optional[pulumi.Input[str]] = None,
                 default_redirection_uri: Optional[pulumi.Input[str]] = None,
                 enabled_locales: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 error_page: Optional[pulumi.Input[pulumi.InputType['TenantErrorPageArgs']]] = None,
                 flags: Optional[pulumi.Input[pulumi.InputType['TenantFlagsArgs']]] = None,
                 friendly_name: Optional[pulumi.Input[str]] = None,
                 guardian_mfa_page: Optional[pulumi.Input[pulumi.InputType['TenantGuardianMfaPageArgs']]] = None,
                 idle_session_lifetime: Optional[pulumi.Input[float]] = None,
                 picture_url: Optional[pulumi.Input[str]] = None,
                 sandbox_version: Optional[pulumi.Input[str]] = None,
                 session_cookie: Optional[pulumi.Input[pulumi.InputType['TenantSessionCookieArgs']]] = None,
                 session_lifetime: Optional[pulumi.Input[float]] = None,
                 support_email: Optional[pulumi.Input[str]] = None,
                 support_url: Optional[pulumi.Input[str]] = None,
                 universal_login: Optional[pulumi.Input[pulumi.InputType['TenantUniversalLoginArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TenantArgs.__new__(TenantArgs)

            __props__.__dict__["allowed_logout_urls"] = allowed_logout_urls
            if change_password is not None and not opts.urn:
                warnings.warn("""This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""", DeprecationWarning)
                pulumi.log.warn("""change_password is deprecated: This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""")
            __props__.__dict__["change_password"] = change_password
            __props__.__dict__["default_audience"] = default_audience
            __props__.__dict__["default_directory"] = default_directory
            __props__.__dict__["default_redirection_uri"] = default_redirection_uri
            __props__.__dict__["enabled_locales"] = enabled_locales
            if error_page is not None and not opts.urn:
                warnings.warn("""This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""", DeprecationWarning)
                pulumi.log.warn("""error_page is deprecated: This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""")
            __props__.__dict__["error_page"] = error_page
            __props__.__dict__["flags"] = flags
            __props__.__dict__["friendly_name"] = friendly_name
            if guardian_mfa_page is not None and not opts.urn:
                warnings.warn("""This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""", DeprecationWarning)
                pulumi.log.warn("""guardian_mfa_page is deprecated: This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""")
            __props__.__dict__["guardian_mfa_page"] = guardian_mfa_page
            __props__.__dict__["idle_session_lifetime"] = idle_session_lifetime
            __props__.__dict__["picture_url"] = picture_url
            __props__.__dict__["sandbox_version"] = sandbox_version
            __props__.__dict__["session_cookie"] = session_cookie
            __props__.__dict__["session_lifetime"] = session_lifetime
            __props__.__dict__["support_email"] = support_email
            __props__.__dict__["support_url"] = support_url
            if universal_login is not None and not opts.urn:
                warnings.warn("""These configuration settings have been deprecated. Migrate to managing these settings through the `auth0_branding` resource. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-universal-login) for more info.""", DeprecationWarning)
                pulumi.log.warn("""universal_login is deprecated: These configuration settings have been deprecated. Migrate to managing these settings through the `auth0_branding` resource. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-universal-login) for more info.""")
            __props__.__dict__["universal_login"] = universal_login
        super(Tenant, __self__).__init__(
            'auth0:index/tenant:Tenant',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowed_logout_urls: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            change_password: Optional[pulumi.Input[pulumi.InputType['TenantChangePasswordArgs']]] = None,
            default_audience: Optional[pulumi.Input[str]] = None,
            default_directory: Optional[pulumi.Input[str]] = None,
            default_redirection_uri: Optional[pulumi.Input[str]] = None,
            enabled_locales: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            error_page: Optional[pulumi.Input[pulumi.InputType['TenantErrorPageArgs']]] = None,
            flags: Optional[pulumi.Input[pulumi.InputType['TenantFlagsArgs']]] = None,
            friendly_name: Optional[pulumi.Input[str]] = None,
            guardian_mfa_page: Optional[pulumi.Input[pulumi.InputType['TenantGuardianMfaPageArgs']]] = None,
            idle_session_lifetime: Optional[pulumi.Input[float]] = None,
            picture_url: Optional[pulumi.Input[str]] = None,
            sandbox_version: Optional[pulumi.Input[str]] = None,
            session_cookie: Optional[pulumi.Input[pulumi.InputType['TenantSessionCookieArgs']]] = None,
            session_lifetime: Optional[pulumi.Input[float]] = None,
            support_email: Optional[pulumi.Input[str]] = None,
            support_url: Optional[pulumi.Input[str]] = None,
            universal_login: Optional[pulumi.Input[pulumi.InputType['TenantUniversalLoginArgs']]] = None) -> 'Tenant':
        """
        Get an existing Tenant resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_logout_urls: URLs that Auth0 may redirect to after logout.
        :param pulumi.Input[pulumi.InputType['TenantChangePasswordArgs']] change_password: Configuration settings for change password page. This attribute is deprecated in favor of the `auth0_pages` resource and
               it will be removed in a future major version. Check the
               [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more
               info.
        :param pulumi.Input[str] default_audience: API Audience to use by default for API Authorization flows. This setting is equivalent to appending the audience to every authorization request made to the tenant for every application.
        :param pulumi.Input[str] default_directory: Name of the connection to be used for Password Grant exchanges. Options include `auth0-adldap`, `ad`, `auth0`, `email`, `sms`, `waad`, and `adfs`.
        :param pulumi.Input[str] default_redirection_uri: The default absolute redirection URI. Must be HTTPS or an empty string.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_locales: Supported locales for the user interface. The first locale in the list will be used to set the default locale.
        :param pulumi.Input[pulumi.InputType['TenantErrorPageArgs']] error_page: Configuration settings for error pages. This attribute is deprecated in favor of the `auth0_pages` resource and it will
               be removed in a future major version. Check the
               [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more
               info.
        :param pulumi.Input[pulumi.InputType['TenantFlagsArgs']] flags: Configuration settings for tenant flags.
        :param pulumi.Input[str] friendly_name: Friendly name for the tenant.
        :param pulumi.Input[pulumi.InputType['TenantGuardianMfaPageArgs']] guardian_mfa_page: Configuration settings for the Guardian MFA page. This attribute is deprecated in favor of the `auth0_pages` resource
               and it will be removed in a future major version. Check the
               [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more
               info.
        :param pulumi.Input[float] idle_session_lifetime: Number of hours during which a session can be inactive before the user must log in again.
        :param pulumi.Input[str] picture_url: URL of logo to be shown for the tenant. Recommended size is 150px x 150px. If no URL is provided, the Auth0 logo will be used.
        :param pulumi.Input[str] sandbox_version: Selected sandbox version for the extensibility environment, which allows you to use custom scripts to extend parts of Auth0's functionality.
        :param pulumi.Input[pulumi.InputType['TenantSessionCookieArgs']] session_cookie: Alters behavior of tenant's session cookie. Contains a single `mode` property.
        :param pulumi.Input[float] session_lifetime: Number of hours during which a session will stay valid.
        :param pulumi.Input[str] support_email: Support email address for authenticating users.
        :param pulumi.Input[str] support_url: Support URL for authenticating users.
        :param pulumi.Input[pulumi.InputType['TenantUniversalLoginArgs']] universal_login: Configuration settings for Universal Login. These configuration settings have been deprecated. Migrate to managing these
               settings through the `auth0_branding` resource. Check the
               [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-universal-login)
               for more info.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TenantState.__new__(_TenantState)

        __props__.__dict__["allowed_logout_urls"] = allowed_logout_urls
        __props__.__dict__["change_password"] = change_password
        __props__.__dict__["default_audience"] = default_audience
        __props__.__dict__["default_directory"] = default_directory
        __props__.__dict__["default_redirection_uri"] = default_redirection_uri
        __props__.__dict__["enabled_locales"] = enabled_locales
        __props__.__dict__["error_page"] = error_page
        __props__.__dict__["flags"] = flags
        __props__.__dict__["friendly_name"] = friendly_name
        __props__.__dict__["guardian_mfa_page"] = guardian_mfa_page
        __props__.__dict__["idle_session_lifetime"] = idle_session_lifetime
        __props__.__dict__["picture_url"] = picture_url
        __props__.__dict__["sandbox_version"] = sandbox_version
        __props__.__dict__["session_cookie"] = session_cookie
        __props__.__dict__["session_lifetime"] = session_lifetime
        __props__.__dict__["support_email"] = support_email
        __props__.__dict__["support_url"] = support_url
        __props__.__dict__["universal_login"] = universal_login
        return Tenant(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowedLogoutUrls")
    def allowed_logout_urls(self) -> pulumi.Output[Sequence[str]]:
        """
        URLs that Auth0 may redirect to after logout.
        """
        return pulumi.get(self, "allowed_logout_urls")

    @property
    @pulumi.getter(name="changePassword")
    def change_password(self) -> pulumi.Output['outputs.TenantChangePassword']:
        """
        Configuration settings for change password page. This attribute is deprecated in favor of the `auth0_pages` resource and
        it will be removed in a future major version. Check the
        [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more
        info.
        """
        warnings.warn("""This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""", DeprecationWarning)
        pulumi.log.warn("""change_password is deprecated: This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""")

        return pulumi.get(self, "change_password")

    @property
    @pulumi.getter(name="defaultAudience")
    def default_audience(self) -> pulumi.Output[str]:
        """
        API Audience to use by default for API Authorization flows. This setting is equivalent to appending the audience to every authorization request made to the tenant for every application.
        """
        return pulumi.get(self, "default_audience")

    @property
    @pulumi.getter(name="defaultDirectory")
    def default_directory(self) -> pulumi.Output[str]:
        """
        Name of the connection to be used for Password Grant exchanges. Options include `auth0-adldap`, `ad`, `auth0`, `email`, `sms`, `waad`, and `adfs`.
        """
        return pulumi.get(self, "default_directory")

    @property
    @pulumi.getter(name="defaultRedirectionUri")
    def default_redirection_uri(self) -> pulumi.Output[str]:
        """
        The default absolute redirection URI. Must be HTTPS or an empty string.
        """
        return pulumi.get(self, "default_redirection_uri")

    @property
    @pulumi.getter(name="enabledLocales")
    def enabled_locales(self) -> pulumi.Output[Sequence[str]]:
        """
        Supported locales for the user interface. The first locale in the list will be used to set the default locale.
        """
        return pulumi.get(self, "enabled_locales")

    @property
    @pulumi.getter(name="errorPage")
    def error_page(self) -> pulumi.Output['outputs.TenantErrorPage']:
        """
        Configuration settings for error pages. This attribute is deprecated in favor of the `auth0_pages` resource and it will
        be removed in a future major version. Check the
        [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more
        info.
        """
        warnings.warn("""This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""", DeprecationWarning)
        pulumi.log.warn("""error_page is deprecated: This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""")

        return pulumi.get(self, "error_page")

    @property
    @pulumi.getter
    def flags(self) -> pulumi.Output['outputs.TenantFlags']:
        """
        Configuration settings for tenant flags.
        """
        return pulumi.get(self, "flags")

    @property
    @pulumi.getter(name="friendlyName")
    def friendly_name(self) -> pulumi.Output[str]:
        """
        Friendly name for the tenant.
        """
        return pulumi.get(self, "friendly_name")

    @property
    @pulumi.getter(name="guardianMfaPage")
    def guardian_mfa_page(self) -> pulumi.Output['outputs.TenantGuardianMfaPage']:
        """
        Configuration settings for the Guardian MFA page. This attribute is deprecated in favor of the `auth0_pages` resource
        and it will be removed in a future major version. Check the
        [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more
        info.
        """
        warnings.warn("""This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""", DeprecationWarning)
        pulumi.log.warn("""guardian_mfa_page is deprecated: This attribute is deprecated in favor of the `auth0_pages` resource and it will be removed in a future major version. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-pages) for more info.""")

        return pulumi.get(self, "guardian_mfa_page")

    @property
    @pulumi.getter(name="idleSessionLifetime")
    def idle_session_lifetime(self) -> pulumi.Output[Optional[float]]:
        """
        Number of hours during which a session can be inactive before the user must log in again.
        """
        return pulumi.get(self, "idle_session_lifetime")

    @property
    @pulumi.getter(name="pictureUrl")
    def picture_url(self) -> pulumi.Output[str]:
        """
        URL of logo to be shown for the tenant. Recommended size is 150px x 150px. If no URL is provided, the Auth0 logo will be used.
        """
        return pulumi.get(self, "picture_url")

    @property
    @pulumi.getter(name="sandboxVersion")
    def sandbox_version(self) -> pulumi.Output[str]:
        """
        Selected sandbox version for the extensibility environment, which allows you to use custom scripts to extend parts of Auth0's functionality.
        """
        return pulumi.get(self, "sandbox_version")

    @property
    @pulumi.getter(name="sessionCookie")
    def session_cookie(self) -> pulumi.Output['outputs.TenantSessionCookie']:
        """
        Alters behavior of tenant's session cookie. Contains a single `mode` property.
        """
        return pulumi.get(self, "session_cookie")

    @property
    @pulumi.getter(name="sessionLifetime")
    def session_lifetime(self) -> pulumi.Output[Optional[float]]:
        """
        Number of hours during which a session will stay valid.
        """
        return pulumi.get(self, "session_lifetime")

    @property
    @pulumi.getter(name="supportEmail")
    def support_email(self) -> pulumi.Output[str]:
        """
        Support email address for authenticating users.
        """
        return pulumi.get(self, "support_email")

    @property
    @pulumi.getter(name="supportUrl")
    def support_url(self) -> pulumi.Output[str]:
        """
        Support URL for authenticating users.
        """
        return pulumi.get(self, "support_url")

    @property
    @pulumi.getter(name="universalLogin")
    def universal_login(self) -> pulumi.Output['outputs.TenantUniversalLogin']:
        """
        Configuration settings for Universal Login. These configuration settings have been deprecated. Migrate to managing these
        settings through the `auth0_branding` resource. Check the
        [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-universal-login)
        for more info.
        """
        warnings.warn("""These configuration settings have been deprecated. Migrate to managing these settings through the `auth0_branding` resource. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-universal-login) for more info.""", DeprecationWarning)
        pulumi.log.warn("""universal_login is deprecated: These configuration settings have been deprecated. Migrate to managing these settings through the `auth0_branding` resource. Check the [MIGRATION_GUIDE](https://github.com/auth0/terraform-provider-auth0/blob/main/MIGRATION_GUIDE.md#tenant-universal-login) for more info.""")

        return pulumi.get(self, "universal_login")

