from typing import Any, Dict, Type, TypeVar, Tuple, Optional, BinaryIO, TextIO, TYPE_CHECKING

from typing import List


from attrs import define as _attrs_define
from attrs import field as _attrs_field

from ..types import UNSET, Unset

from ..models.test_result import TestResult






T = TypeVar("T", bound="RunDetectionRuleYamlTestsResponseDataResults")


@_attrs_define
class RunDetectionRuleYamlTestsResponseDataResults:
    """ 
     """

    additional_properties: Dict[str, TestResult] = _attrs_field(init=False, factory=dict)


    def to_dict(self) -> Dict[str, Any]:
        
        field_dict: Dict[str, Any] = {}
        for prop_name, prop in self.additional_properties.items():
            field_dict[prop_name] = prop.value

        return field_dict



    @classmethod
    def from_dict(cls: Type[T], src_dict: Dict[str, Any]) -> T:
        d = src_dict.copy()
        run_detection_rule_yaml_tests_response_data_results = cls(
        )


        additional_properties = {}
        for prop_name, prop_dict in d.items():
            additional_property = TestResult(prop_dict)



            additional_properties[prop_name] = additional_property

        run_detection_rule_yaml_tests_response_data_results.additional_properties = additional_properties
        return run_detection_rule_yaml_tests_response_data_results

    @property
    def additional_keys(self) -> List[str]:
        return list(self.additional_properties.keys())

    def __getitem__(self, key: str) -> TestResult:
        return self.additional_properties[key]

    def __setitem__(self, key: str, value: TestResult) -> None:
        self.additional_properties[key] = value

    def __delitem__(self, key: str) -> None:
        del self.additional_properties[key]

    def __contains__(self, key: str) -> bool:
        return key in self.additional_properties
