"""Dataset definitions and metadata."""

from typing import Any, Dict

# TODO: add proper file names for each dataset

DATASET_TYPES: Dict[str, Dict[str, Any]] = {
    "bills": {
        "key": "bills/bicam_bills.zip",
        "size_mb": 1847,
        "description": "Complete bills data including text, summaries, and related records",
        "checksum": "sha256:b003b16abfe093d78a6da0a43170dfce338fbf88bc85af561f45cbd159ec0f17",
        "extracted_size_mb": 3694,
        "files": [
            "bills.csv",
            "bills_actions.csv",
            "bills_actions_committees.csv",
            "bills_actions_recorded_votes.csv",
            "bills_cboestimates.csv",
            "bills_cosponsors.csv",
            "bills_laws.csv",
            "bills_lobbied.csv",
            "bills_reference_codes_sections.csv",
            "bills_reference_laws.csv",
            "bills_reference_statutes.csv",
            "bills_reference_statutes_pages.csv",
            "bills_related_bills.csv",
            "bills_sponsors.csv",
            "bills_subjects.csv",
            "bills_summaries.csv",
            "bills_texts.csv",
            "bills_titles.csv",
            "crosswalk_bills_voteview.csv",
            "ref_bill_summary_version_codes.csv",
            "ref_bill_version_codes.csv",
            "ref_title_type_codes.csv",
        ],
        "format": "CSV",
        "congress_range": "93-118",
    },
    "amendments": {
        "key": "amendments/bicam_amendments.zip",
        "size_mb": 6568,
        "description": "All amendments with amended items",
        "checksum": "sha256:2b2660041df3f83a4b9d76758dc4acbba4e97ffebdd4fc603773a3f1e35d79e7",
        "extracted_size_mb": 13136,
        "files": [
            "amendments.csv",
            "amendments_actions.csv",
            "amendments_actions_recorded_votes.csv",
            "amendments_amended_amendments.csv",
            "amendments_amended_bills.csv",
            "amendments_amended_treaties.csv",
            "amendments_cosponsors.csv",
            "amendments_sponsors.csv",
            "amendments_texts.csv",
        ],
        "format": "CSV",
        "congress_range": "93-118",
    },
    "members": {
        "key": "members/bicam_members.zip",
        "size_mb": 1,
        "description": "Historical and current member information",
        "checksum": "sha256:b82799a397518675d4a353306ff88a49d9bbedd3c19f34283261098556430c5e",
        "extracted_size_mb": 3,
        "files": [
            "members.csv",
            "members_leadership_roles.csv",
            "members_metadata.csv",
            "members_party_history.csv",
            "members_terms.csv",
        ],
        "format": "CSV",
        "congress_range": "1-118",
    },
    "nominations": {
        "key": "nominations/bicam_nominations.zip",
        "size_mb": 21,
        "description": "Presidential nominations data",
        "checksum": "sha256:87b072e7189e0a9a901f3f90da5958cbe22ac7d9cfca42a3e926dbcd9c49becf",
        "extracted_size_mb": 42,
        "files": [
            "nominations.csv",
            "nominations_actions.csv",
            "nominations_actions_committees.csv",
            "nominations_committeeactivities.csv",
            "nominations_nominees.csv",
            "nominations_positions.csv",
            "nominations_associated_hearings.csv",
        ],
        "format": "CSV",
        "congress_range": "93-118",
    },
    "committees": {
        "key": "committees/bicam_committees.zip",
        "size_mb": 17,
        "description": "Committee information, including history of committee names",
        "checksum": "sha256:73de42d6740a757507b056dcd16fa8659dfe8a56888f0965fd7778dc3d6dab03",
        "extracted_size_mb": 34,
        "files": [
            "committees.csv",
            "committees_bills.csv",
            "committees_committeereports.csv",
            "committees_history.csv",
            "committees_subcommittees.csv",
        ],
        "format": "CSV",
        "congress_range": "93-118",
    },
    "committeereports": {
        "key": "committeereports/bicam_committeereports.zip",
        "size_mb": 570,
        "description": "Committee reports, with full text and related information",
        "checksum": "sha256:deb0670f0956fe14de762ee46f122390e0dbcd80fc43a7791b89ce840eab6285",
        "extracted_size_mb": 1141,
        "files": [
            "committeereports.csv",
            "committeereports_associated_bills.csv",
            "committeereports_associated_treaties.csv",
            "committeereports_members.csv",
            "committeereports_metadata.csv",
            "committeereports_metadata_granules.csv",
            "committeereports_texts.csv",
        ],
        "format": "CSV",
        "congress_range": "104-118",
    },
    "committeemeetings": {
        "key": "committeemeetings/bicam_committeemeetings.zip",
        "size_mb": 5,
        "description": "Committee meeting records",
        "checksum": "sha256:0c998ddaa24bbd5f94e410d3712cf3be4120773aa5310af86f2b7c76864cc936",
        "extracted_size_mb": 10,
        "files": [
            "committeemeetings.csv",
            "committeemeetings_associated_bills.csv",
            "committeemeetings_associated_hearings.csv",
            "committeemeetings_associated_nominations.csv",
            "committeemeetings_associated_treaties.csv",
            "committeemeetings_committees.csv",
            "committeemeetings_meeting_documents.csv",
            "committeemeetings_witness_documents.csv",
            "committeemeetings_witnesses.csv",
        ],
        "format": "CSV",
        "congress_range": "110-118",
    },
    "committeeprints": {
        "key": "committeeprints/bicam_committeeprints.zip",
        "size_mb": 91,
        "description": "Committee prints, including full text and topics",
        "checksum": "sha256:8088670c85ca776f9f663c1192609e2627b35cb7506f48c0f410b637d427ce6b",
        "extracted_size_mb": 181,
        "files": [
            "committeeprints.csv",
            "committeeprints_associated_bills.csv",
            "committeeprints_associated_treaties.csv",
            "committeeprints_members.csv",
            "committeeprints_metadata.csv",
            "committeeprints_metadata_granules.csv",
            "committeeprints_texts.csv",
        ],
        "format": "CSV",
        "congress_range": "105-118",
    },
    "hearings": {
        "key": "hearings/bicam_hearings.zip",
        "size_mb": 1748,
        "description": "Hearing information, such as address and transcripts",
        "checksum": "sha256:0c95b41f7bf09c360656603ebcadfeafc8c1c420d0820ca195fd32367dcb8312",
        "extracted_size_mb": 3495,
        "files": [
            "hearings.csv",
            "hearings_bills.csv",
            "hearings_committees.csv",
            "hearings_dates.csv",
            "hearings_members.csv",
            "hearings_metadata.csv",
            "hearings_metadata_granules.csv",
            "hearings_texts.csv",
            "hearings_witnesses.csv",
        ],
        "format": "CSV",
        "congress_range": "105-118",
    },
    "treaties": {
        "key": "treaties/bicam_treaties.zip",
        "size_mb": 0,
        "description": "Treaty documents with actions, titles, and more",
        "checksum": "sha256:a03cb8ab8063ec2e8f35441768378e1854351ed466cac97312681aff082e6615",
        "extracted_size_mb": 1,
        "files": [
            "treaties.csv",
            "treaties_actions.csv",
            "treaties_country_parties.csv",
            "treaties_index_terms.csv",
            "treaties_metadata.csv",
            "treaties_metadata_granules.csv",
            "treaties_titles.csv",
        ],
        "format": "CSV",
        "congress_range": "93-118",
    },
    "congresses": {
        "key": "congresses/bicam_congresses.zip",
        "size_mb": 0,
        "description": "Congressional session metadata, like directories and session dates",
        "checksum": "sha256:9cdeceeaa8602e3e35954e1809274a89e327109694401c8f867ea57f340953f0",
        "extracted_size_mb": 1,
        "files": [
            "congresses.csv",
            "congresses_directories.csv",
            "congresses_directories_isbn.csv",
            "congresses_sessions.csv",
        ],
        "format": "CSV",
        "congress_range": "1-119",
    },
    "complete": {
        "key": "complete/bicam.zip",
        "size_mb": 10862,
        "description": "Complete BICAM dataset with all data types",
        "checksum": "sha256:f0fd24802c4136b242b70c67885c0a8e211bc864bb0cc74934345c46e5ee53b5",
        "extracted_size_mb": 21725,
        "files": [
            "All files from individual datasets",
        ],
        "format": "CSV",
        "congress_range": "1-119",
    },
}
