# coding: utf-8

"""
    Daytona

    Daytona AI platform API Docs

    The version of the OpenAPI document: 1.0
    Contact: support@daytona.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional
from daytona_api_client_async.models.create_build_info import CreateBuildInfo
from daytona_api_client_async.models.sandbox_volume import SandboxVolume
from typing import Optional, Set
from typing_extensions import Self

class CreateSandbox(BaseModel):
    """
    CreateSandbox
    """ # noqa: E501
    snapshot: Optional[StrictStr] = Field(default=None, description="The ID or name of the snapshot used for the sandbox")
    user: Optional[StrictStr] = Field(default=None, description="The user associated with the project")
    env: Optional[Dict[str, StrictStr]] = Field(default=None, description="Environment variables for the sandbox")
    labels: Optional[Dict[str, StrictStr]] = Field(default=None, description="Labels for the sandbox")
    public: Optional[StrictBool] = Field(default=None, description="Whether the sandbox http preview is publicly accessible")
    var_class: Optional[StrictStr] = Field(default=None, description="The sandbox class type", alias="class")
    target: Optional[StrictStr] = Field(default=None, description="The target (region) where the sandbox will be created")
    cpu: Optional[StrictInt] = Field(default=None, description="CPU cores allocated to the sandbox")
    gpu: Optional[StrictInt] = Field(default=None, description="GPU units allocated to the sandbox")
    memory: Optional[StrictInt] = Field(default=None, description="Memory allocated to the sandbox in GB")
    disk: Optional[StrictInt] = Field(default=None, description="Disk space allocated to the sandbox in GB")
    auto_stop_interval: Optional[StrictInt] = Field(default=None, description="Auto-stop interval in minutes (0 means disabled)", alias="autoStopInterval")
    auto_archive_interval: Optional[StrictInt] = Field(default=None, description="Auto-archive interval in minutes (0 means the maximum interval will be used)", alias="autoArchiveInterval")
    auto_delete_interval: Optional[StrictInt] = Field(default=None, description="Auto-delete interval in minutes (negative value means disabled, 0 means delete immediately upon stopping)", alias="autoDeleteInterval")
    volumes: Optional[List[SandboxVolume]] = Field(default=None, description="Array of volumes to attach to the sandbox")
    build_info: Optional[CreateBuildInfo] = Field(default=None, description="Build information for the sandbox", alias="buildInfo")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["snapshot", "user", "env", "labels", "public", "class", "target", "cpu", "gpu", "memory", "disk", "autoStopInterval", "autoArchiveInterval", "autoDeleteInterval", "volumes", "buildInfo"]

    @field_validator('var_class')
    def var_class_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['small', 'medium', 'large']):
            raise ValueError("must be one of enum values ('small', 'medium', 'large')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CreateSandbox from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in volumes (list)
        _items = []
        if self.volumes:
            for _item_volumes in self.volumes:
                if _item_volumes:
                    _items.append(_item_volumes.to_dict())
            _dict['volumes'] = _items
        # override the default output from pydantic by calling `to_dict()` of build_info
        if self.build_info:
            _dict['buildInfo'] = self.build_info.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CreateSandbox from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "snapshot": obj.get("snapshot"),
            "user": obj.get("user"),
            "env": obj.get("env"),
            "labels": obj.get("labels"),
            "public": obj.get("public"),
            "class": obj.get("class"),
            "target": obj.get("target"),
            "cpu": obj.get("cpu"),
            "gpu": obj.get("gpu"),
            "memory": obj.get("memory"),
            "disk": obj.get("disk"),
            "autoStopInterval": obj.get("autoStopInterval"),
            "autoArchiveInterval": obj.get("autoArchiveInterval"),
            "autoDeleteInterval": obj.get("autoDeleteInterval"),
            "volumes": [SandboxVolume.from_dict(_item) for _item in obj["volumes"]] if obj.get("volumes") is not None else None,
            "buildInfo": CreateBuildInfo.from_dict(obj["buildInfo"]) if obj.get("buildInfo") is not None else None
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


