# coding: utf-8

"""
    Daytona

    Daytona AI platform API Docs

    The version of the OpenAPI document: 1.0
    Contact: support@daytona.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from daytona_api_client_async.models.organization_role import OrganizationRole
from typing import Optional, Set
from typing_extensions import Self

class OrganizationInvitation(BaseModel):
    """
    OrganizationInvitation
    """ # noqa: E501
    id: StrictStr = Field(description="Invitation ID")
    email: StrictStr = Field(description="Email address of the invitee")
    invited_by: StrictStr = Field(description="Email address of the inviter", alias="invitedBy")
    organization_id: StrictStr = Field(description="Organization ID", alias="organizationId")
    organization_name: StrictStr = Field(description="Organization name", alias="organizationName")
    expires_at: datetime = Field(description="Expiration date of the invitation", alias="expiresAt")
    status: StrictStr = Field(description="Invitation status")
    role: StrictStr = Field(description="Member role")
    assigned_roles: List[OrganizationRole] = Field(description="Assigned roles", alias="assignedRoles")
    created_at: datetime = Field(description="Creation timestamp", alias="createdAt")
    updated_at: datetime = Field(description="Last update timestamp", alias="updatedAt")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "email", "invitedBy", "organizationId", "organizationName", "expiresAt", "status", "role", "assignedRoles", "createdAt", "updatedAt"]

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['pending', 'accepted', 'declined', 'cancelled']):
            raise ValueError("must be one of enum values ('pending', 'accepted', 'declined', 'cancelled')")
        return value

    @field_validator('role')
    def role_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['owner', 'member']):
            raise ValueError("must be one of enum values ('owner', 'member')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of OrganizationInvitation from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in assigned_roles (list)
        _items = []
        if self.assigned_roles:
            for _item_assigned_roles in self.assigned_roles:
                if _item_assigned_roles:
                    _items.append(_item_assigned_roles.to_dict())
            _dict['assignedRoles'] = _items
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of OrganizationInvitation from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "email": obj.get("email"),
            "invitedBy": obj.get("invitedBy"),
            "organizationId": obj.get("organizationId"),
            "organizationName": obj.get("organizationName"),
            "expiresAt": obj.get("expiresAt"),
            "status": obj.get("status"),
            "role": obj.get("role"),
            "assignedRoles": [OrganizationRole.from_dict(_item) for _item in obj["assignedRoles"]] if obj.get("assignedRoles") is not None else None,
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


