# coding: utf-8

"""
    Daytona

    Daytona AI platform API Docs

    The version of the OpenAPI document: 1.0
    Contact: support@daytona.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional, Union
from daytona_api_client_async.models.runner_state import RunnerState
from daytona_api_client_async.models.sandbox_class import SandboxClass
from typing import Optional, Set
from typing_extensions import Self

class Runner(BaseModel):
    """
    Runner
    """ # noqa: E501
    id: StrictStr = Field(description="The ID of the runner")
    domain: StrictStr = Field(description="The domain of the runner")
    api_url: StrictStr = Field(description="The API URL of the runner", alias="apiUrl")
    proxy_url: StrictStr = Field(description="The proxy URL of the runner", alias="proxyUrl")
    api_key: StrictStr = Field(description="The API key for the runner", alias="apiKey")
    cpu: Union[StrictFloat, StrictInt] = Field(description="The CPU capacity of the runner")
    memory: Union[StrictFloat, StrictInt] = Field(description="The memory capacity of the runner in GiB")
    disk: Union[StrictFloat, StrictInt] = Field(description="The disk capacity of the runner in GiB")
    gpu: Union[StrictFloat, StrictInt] = Field(description="The GPU capacity of the runner")
    gpu_type: StrictStr = Field(description="The type of GPU", alias="gpuType")
    var_class: SandboxClass = Field(description="The class of the runner", alias="class")
    used: Union[StrictFloat, StrictInt] = Field(description="The current usage of the runner")
    capacity: Union[StrictFloat, StrictInt] = Field(description="The capacity of the runner")
    current_cpu_usage_percentage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Current CPU usage percentage", alias="currentCpuUsagePercentage")
    current_memory_usage_percentage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Current RAM usage percentage", alias="currentMemoryUsagePercentage")
    current_disk_usage_percentage: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Current disk usage percentage", alias="currentDiskUsagePercentage")
    current_allocated_cpu: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Current allocated CPU", alias="currentAllocatedCpu")
    current_allocated_memory_gi_b: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Current allocated memory in GiB", alias="currentAllocatedMemoryGiB")
    current_allocated_disk_gi_b: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Current allocated disk in GiB", alias="currentAllocatedDiskGiB")
    current_snapshot_count: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Current snapshot count", alias="currentSnapshotCount")
    availability_score: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Runner availability score", alias="availabilityScore")
    region: StrictStr = Field(description="The region of the runner")
    state: RunnerState = Field(description="The state of the runner")
    last_checked: Optional[StrictStr] = Field(default=None, description="The last time the runner was checked", alias="lastChecked")
    unschedulable: StrictBool = Field(description="Whether the runner is unschedulable")
    created_at: StrictStr = Field(description="The creation timestamp of the runner", alias="createdAt")
    updated_at: StrictStr = Field(description="The last update timestamp of the runner", alias="updatedAt")
    version: StrictStr = Field(description="The version of the runner")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "domain", "apiUrl", "proxyUrl", "apiKey", "cpu", "memory", "disk", "gpu", "gpuType", "class", "used", "capacity", "currentCpuUsagePercentage", "currentMemoryUsagePercentage", "currentDiskUsagePercentage", "currentAllocatedCpu", "currentAllocatedMemoryGiB", "currentAllocatedDiskGiB", "currentSnapshotCount", "availabilityScore", "region", "state", "lastChecked", "unschedulable", "createdAt", "updatedAt", "version"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Runner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Runner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "domain": obj.get("domain"),
            "apiUrl": obj.get("apiUrl"),
            "proxyUrl": obj.get("proxyUrl"),
            "apiKey": obj.get("apiKey"),
            "cpu": obj.get("cpu"),
            "memory": obj.get("memory"),
            "disk": obj.get("disk"),
            "gpu": obj.get("gpu"),
            "gpuType": obj.get("gpuType"),
            "class": obj.get("class"),
            "used": obj.get("used"),
            "capacity": obj.get("capacity"),
            "currentCpuUsagePercentage": obj.get("currentCpuUsagePercentage"),
            "currentMemoryUsagePercentage": obj.get("currentMemoryUsagePercentage"),
            "currentDiskUsagePercentage": obj.get("currentDiskUsagePercentage"),
            "currentAllocatedCpu": obj.get("currentAllocatedCpu"),
            "currentAllocatedMemoryGiB": obj.get("currentAllocatedMemoryGiB"),
            "currentAllocatedDiskGiB": obj.get("currentAllocatedDiskGiB"),
            "currentSnapshotCount": obj.get("currentSnapshotCount"),
            "availabilityScore": obj.get("availabilityScore"),
            "region": obj.get("region"),
            "state": obj.get("state"),
            "lastChecked": obj.get("lastChecked"),
            "unschedulable": obj.get("unschedulable"),
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "version": obj.get("version")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


