# coding: utf-8

"""
    Daytona

    Daytona AI platform API Docs

    The version of the OpenAPI document: 1.0
    Contact: support@daytona.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from daytona_api_client_async.models.build_info import BuildInfo
from daytona_api_client_async.models.sandbox_desired_state import SandboxDesiredState
from daytona_api_client_async.models.sandbox_state import SandboxState
from daytona_api_client_async.models.sandbox_volume import SandboxVolume
from typing import Optional, Set
from typing_extensions import Self

class Sandbox(BaseModel):
    """
    Sandbox
    """ # noqa: E501
    id: StrictStr = Field(description="The ID of the sandbox")
    organization_id: StrictStr = Field(description="The organization ID of the sandbox", alias="organizationId")
    snapshot: Optional[StrictStr] = Field(default=None, description="The snapshot used for the sandbox")
    user: StrictStr = Field(description="The user associated with the project")
    env: Dict[str, StrictStr] = Field(description="Environment variables for the sandbox")
    labels: Dict[str, StrictStr] = Field(description="Labels for the sandbox")
    public: StrictBool = Field(description="Whether the sandbox http preview is public")
    target: StrictStr = Field(description="The target environment for the sandbox")
    cpu: Union[StrictFloat, StrictInt] = Field(description="The CPU quota for the sandbox")
    gpu: Union[StrictFloat, StrictInt] = Field(description="The GPU quota for the sandbox")
    memory: Union[StrictFloat, StrictInt] = Field(description="The memory quota for the sandbox")
    disk: Union[StrictFloat, StrictInt] = Field(description="The disk quota for the sandbox")
    state: Optional[SandboxState] = Field(default=None, description="The state of the sandbox")
    desired_state: Optional[SandboxDesiredState] = Field(default=None, description="The desired state of the sandbox", alias="desiredState")
    error_reason: Optional[StrictStr] = Field(default=None, description="The error reason of the sandbox", alias="errorReason")
    backup_state: Optional[StrictStr] = Field(default=None, description="The state of the backup", alias="backupState")
    backup_created_at: Optional[StrictStr] = Field(default=None, description="The creation timestamp of the last backup", alias="backupCreatedAt")
    auto_stop_interval: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Auto-stop interval in minutes (0 means disabled)", alias="autoStopInterval")
    auto_archive_interval: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Auto-archive interval in minutes", alias="autoArchiveInterval")
    auto_delete_interval: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Auto-delete interval in minutes (negative value means disabled, 0 means delete immediately upon stopping)", alias="autoDeleteInterval")
    runner_domain: Optional[StrictStr] = Field(default=None, description="The domain name of the runner", alias="runnerDomain")
    volumes: Optional[List[SandboxVolume]] = Field(default=None, description="Array of volumes attached to the sandbox")
    build_info: Optional[BuildInfo] = Field(default=None, description="Build information for the sandbox", alias="buildInfo")
    created_at: Optional[StrictStr] = Field(default=None, description="The creation timestamp of the sandbox", alias="createdAt")
    updated_at: Optional[StrictStr] = Field(default=None, description="The last update timestamp of the sandbox", alias="updatedAt")
    var_class: Optional[StrictStr] = Field(default=None, description="The class of the sandbox", alias="class")
    daemon_version: Optional[StrictStr] = Field(default=None, description="The version of the daemon running in the sandbox", alias="daemonVersion")
    additional_properties: Dict[str, Any] = {}
    __properties: ClassVar[List[str]] = ["id", "organizationId", "snapshot", "user", "env", "labels", "public", "target", "cpu", "gpu", "memory", "disk", "state", "desiredState", "errorReason", "backupState", "backupCreatedAt", "autoStopInterval", "autoArchiveInterval", "autoDeleteInterval", "runnerDomain", "volumes", "buildInfo", "createdAt", "updatedAt", "class", "daemonVersion"]

    @field_validator('backup_state')
    def backup_state_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['None', 'Pending', 'InProgress', 'Completed', 'Error']):
            raise ValueError("must be one of enum values ('None', 'Pending', 'InProgress', 'Completed', 'Error')")
        return value

    @field_validator('var_class')
    def var_class_validate_enum(cls, value):
        """Validates the enum"""
        if value is None:
            return value

        if value not in set(['small', 'medium', 'large']):
            raise ValueError("must be one of enum values ('small', 'medium', 'large')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of Sandbox from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        * Fields in `self.additional_properties` are added to the output dict.
        """
        excluded_fields: Set[str] = set([
            "additional_properties",
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in volumes (list)
        _items = []
        if self.volumes:
            for _item_volumes in self.volumes:
                if _item_volumes:
                    _items.append(_item_volumes.to_dict())
            _dict['volumes'] = _items
        # override the default output from pydantic by calling `to_dict()` of build_info
        if self.build_info:
            _dict['buildInfo'] = self.build_info.to_dict()
        # puts key-value pairs in additional_properties in the top level
        if self.additional_properties is not None:
            for _key, _value in self.additional_properties.items():
                _dict[_key] = _value

        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of Sandbox from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "id": obj.get("id"),
            "organizationId": obj.get("organizationId"),
            "snapshot": obj.get("snapshot"),
            "user": obj.get("user"),
            "env": obj.get("env"),
            "labels": obj.get("labels"),
            "public": obj.get("public"),
            "target": obj.get("target"),
            "cpu": obj.get("cpu"),
            "gpu": obj.get("gpu"),
            "memory": obj.get("memory"),
            "disk": obj.get("disk"),
            "state": obj.get("state"),
            "desiredState": obj.get("desiredState"),
            "errorReason": obj.get("errorReason"),
            "backupState": obj.get("backupState"),
            "backupCreatedAt": obj.get("backupCreatedAt"),
            "autoStopInterval": obj.get("autoStopInterval"),
            "autoArchiveInterval": obj.get("autoArchiveInterval"),
            "autoDeleteInterval": obj.get("autoDeleteInterval"),
            "runnerDomain": obj.get("runnerDomain"),
            "volumes": [SandboxVolume.from_dict(_item) for _item in obj["volumes"]] if obj.get("volumes") is not None else None,
            "buildInfo": BuildInfo.from_dict(obj["buildInfo"]) if obj.get("buildInfo") is not None else None,
            "createdAt": obj.get("createdAt"),
            "updatedAt": obj.get("updatedAt"),
            "class": obj.get("class"),
            "daemonVersion": obj.get("daemonVersion")
        })
        # store additional fields in additional_properties
        for _key in obj.keys():
            if _key not in cls.__properties:
                _obj.additional_properties[_key] = obj.get(_key)

        return _obj


