# coding: utf-8

# flake8: noqa
"""
    API Specification

    # Introduction Welcome to gridscales API documentation.  A REST API is a programming interface that allows you to access and send data directly to our systems using HTTPS requests, without the need to use a web GUI. All the functionality you are already familiar with in your control panel is accessible through the API, including expert methods that are only available through the API. Allowing you to script any actions you require, regardless of their complexity.  First we will start with a general overview about how the API works, followed by an extensive list of each endpoint, describing them in great detail.  ## Requests  For security, gridscale requires all API requests are made through the HTTPS protocol so that traffic is encrypted. The following table displays the different type of requests that the interface responds to, depending on the action you require.  | Method | Description | | --- | --- | | GET | A simple search of information. The response is a JSON object. Requests using GET are always read-only. | | POST | Adds new objects and object relations. The POST request must contain all the required parameters in the form of a JSON object. | | PATCH | Changes an object or an object relation. The parameters in PATCH requests are usually optional, so only the changed parameters must be specified in a JSON object. | | DELETE | Deletes an object or object relation. The object is deleted if it exists. | | OPTIONS | Get an extensive list of the servers support methods and characteristics. We will not give example OPTION requests on each endpoint, as they are extensive and self-descriptive. |  <aside class=\"notice\"> The methods PATCH and DELETE are idempotent - that is, a request with identical parameters can be sent several times, and it doesn't change the result. </aside>  ## Status Codes  | HTTP Status | `Message` | Description | | --- | --- | --- | | 200 | `OK` | The request has been successfully processed and the result of the request is transmitted in the response. | | 202 | `Accepted` | The request has been accepted, but will run at a later date. Meaning we can not guarantee the success of the request. You should poll the request to be notified once the resource has been provisioned - see the requests endpoint on how to poll. | | 204 | `No Content` | The request was successful, but the answer deliberately contains no data. | | 400 | `Bad Request` | The request message was built incorrectly. | | 401 | `Unauthorised` | The request can not be performed without a valid authentication. X-Auth UserId or X-Auth token HTTP header is not set or the userID / token is invalid. | | 402 | `Payment Required` | Action can not be executed - not provided any or invalid payment methods. | | 403 | `Forbidden` | The request was not carried out due to lack of authorization of the user or because an impossible action was requested. | | 404 | `Not Found` | The requested resource was not found. Will also be used if you do a resource exists, but the user does not have permission for it. | | 405 | `Method Not Allowed` | The request may be made only with other HTTP methods (eg GET rather than POST). | | 409 | `Conflict` | The request was made under false assumptions. For example, a user can not be created twice with the same email. | | 415 | `Unsupported Media Type` | The contents of the request have been submitted with an invalid media type. All POST or PATCH requests must have \"Content-Type : application / json\" as a header, and send a JSON object as a payload. | | 416 | `Requested Range Not Satisfiable` | The request could not be fulfilled. It is possible that a resource limit was reached or an IPv4 address pool is exhausted. | | 424 | `Failed Dependency` | The request could not be performed because the object is in the wrong status. | | 429 | `Too Many Requests` | The request has been rejected because rate limits have been exceeded. |  <aside class=\"success\"> Status 200-204 indicates that the request has been accepted and is processed. </aside> <aside class=\"notice\"> Status 400-429 indicates that there was a problem with the request that originated on the client. You will find more information about the problem in the body of 4xx response. </aside> <aside class=\"warning\"> A status 500 means that there was a server-side problem and your request can not be processed now. </aside>  ## Request Headers  | Header | Description | | --- | --- | | Content-Type | Always \"application/json\". | | X-Auth-userId | The user UUID. This can be found in the panel under \"API\" and will never change ( even after the change of user e-mail). | | X-Auth-Token | Is generated from the API hash and must be sent with all API requests. Both the token and its permissions can be configured in the panel.|  ## Response Headers  | Header | Description | | --- | --- | | Content-Type | Always \"application/json\". | | X-Time-Provisioning | The time taken to process the request (in ms). | | X-Api-Identity | The currently active Provisioning API version. Useful when reporting bugs to us. | | X-Request-Id   | The unique identifier of the request, be sure to include it when referring to a request. | | RateLimit-Limit | The number of requests that can be made per minute. | | RateLimit-Remaining | The number of requests that still remain before you hit your request limit. | | RateLimit-Reset | A [Unix timestamp](https://en.wikipedia.org/wiki/Unix_time) in milliseconds of when the rate limit will reset, or the time at which a request no longer will return 429 - Too Many Requests. |  ## Timestamp Format  All timestamps follow <a href=\"https://de.wikipedia.org/wiki/ISO_8601\" target=\"_blank_\">ISO 8601</a> and issued in <a href=\"https://www.timeanddate.de/zeitzonen/utc-gmt\" target=\"_blank_\">UTC</a>  ## CORS  ### Cross Origin Resource Sharing  To allow API access from other domains that supports the API CORS (Cross Origin Resource Sharing). See: enable-cors.org/ .  This allows direct use the API in the browser running a JavaScript web control panel.  All this is done in the background by the browser. The following HTTP headers are set by the API:  Header | Parameter | Description --- | --- | --- Access-Control-Allow-Methods   | GET, POST, PUT, PATCH, DELETE, OPTIONS | Contains all available methods that may be used for queries. Access-Control-Allow-Credentials | true | Is set to \"true\". Allows the browser to send the authentication data via X-Auth HTTP header. Access-Control-Allow-Headers | Origin, X-Requested-With, Content-Type, Accept, X-Auth-UserId, X-Auth-Token, X-Exec-Time, X-API-Version, X-Api-Client | The HTTP headers available for requests. Access-Control-Allow-Origin | * | The domain sent by the browser as a source of demand. Access-Control-Expose-Headers | X-Exec-Time, X-Api-Version | The HTTP headers that can be used by a browser application.  ## Rate Limits  The number of requests that can be made through our API is currently limited to 210 requests per 60 seconds. The current state of rate limiting is returned within the response headers of each request. The relevant response headers are  - RateLimit-Limit - RateLimit-Remaining - RateLimit-Reset  See the Response Headers section for details.  As long as the `RateLimit-Remaining` count is above zero, you will be able to make further requests. As soon as the `RateLimit-Remaining` header value is zero, subsequent requests will return the 429 status code. This will stay until the timestamp given in `RateLimit-Reset` has been reached.  ### Example rate limiting response  ```shell HTTP/1.0 429 TOO MANY REQUESTS Content-Length: 66 Content-Type: application/json; charset=utf-8 Date: Mon, 11 Nov 2019 11:11:33 GMT RateLimit-Limit: 210 RateLimit-Remaining: 0 RateLimit-Reset: 1573468299256  {     \"id\": \"too_many_requests\",     \"message\": \"API Rate limit exceeded.\" } ```  It is important to understand how rate limits are reset in order to use the API efficiently. Rate limits are reset for all counted requests at once. This means that that once the timestamp `RateLimit-Remaining` has arrived all counted request are reset and you can again start sending requests to the API.  This allows for short burst of traffic. The downside is once you have hit the request limit no more requests are allowed until the rate limit duration is reset.  ## Object Relations Relationships describe resource objects (storages, networks, IPs, etc.) that are connected to a server. These relationships are treated like objects themselves and can have properties specific to this relation.  One example would be, that the MAC address of a private network connected to a server (Server-to-Network relation) can be found as property of the relation itself - the relation is the _network interface_ in the server.  Another example is storage, where the SCSI LUN is also part of the Server-to-Storage relation object.  This information is especially interesting if some kind of network boot is used on the servers, where the properties of the server need to be known beforehand.  ## Deleted Objects Objects that are deleted are no longer visible on their *regular* endpoints. For historical reasons these objects are still available read-only on a special endpoint named /deleted. If objects have been deleted but have not yet been billed in the current period, the yet-to-be-billed price is still shown.  <!-- #strip_js --> ## Node.js / Javascript Library  We have a JavaScript library for you to use our API with ease.  <a href=\"https://badge.fury.io/js/%40gridscale%2Fgsclient-js\"><img src=\"https://badge.fury.io/js/%40gridscale%2Fgsclient-js.svg\" alt=\"npm version\" height=\"18\"></a>  <aside class=\"success\"> We want to make it even easier for you to manage your Infrastructure via our API - so feel free to contact us with any ideas, or languages you would like to see included. </aside>  Requests with our Node.js lib return a little differently. Everything is the same except it allows you to add URL parameters to customize your requests.  To get started <a href=\"https://www.npmjs.com/package/@gridscale/gsclient-js\" target=\"_blank\">click here</a> .  <!-- #strip_js_end -->  <!-- #strip_go --> ## Golang Library We also have a Golang library for Gophers.  Requests with our Golang lib return a little differently. Everything is the same except it allows you to add URL parameters to customize your requests.  To get started <a href=\"https://github.com/gridscale/gsclient-go\" target=\"_blank\">click here</a> .  <!-- #strip_go_end -->  <!-- #strip_python --> ## Python Library  We have a Python library, that optionally also simplifies handling of asynchronous requests by mimicking synchronous blocking behaviour.  To get started <a href=\"https://pypi.org/project/gs-api-client/\" target=\"_blank\">click here</a> .  <!-- #strip_python_end -->  # Authentication  In order to use the API, the User-UUID and an API_Token are required. Both are available via the web GUI which can be found here on <a href=\"https://my.gridscale.io/APIs/\" target=\"_blank\">Your Account</a>  <aside class=\"success\"> If you are logged in, your UUID and Token will be pulled dynamically from your account, so you can copy request examples straight into your code. </aside>  The User-UUID remains the same, even if the users email address is changed. The API_Token is a randomly generated hash that allows read/write access.  ## API_Token  <table class=\"security-details\"><tbody><tr><th> Security scheme type: </th><td> API Key </td></tr><tr><th> header parameter name:</th><td> X-Auth-Token </td></tr></tbody></table>  ## User_UUID  <table class=\"security-details\"><tbody><tr><th> Security scheme type: </th><td> API Key </td></tr><tr><th> header parameter name:</th><td> X-Auth-UserId </td></tr></tbody></table>  ## Examples  <!-- #strip_js --> > Node.js ``` // to get started // read the docs @ https://www.npmjs.com/package/@gs_js_auth/api var gs_js_auth = require('@gs_js_auth/api').gs_js_auth; var client = new gs_js_auth.Client(\"##API_TOKEN##\",\"##USER_UUID##\"); ``` <!-- #strip_js_end -->  <!-- #strip_go --> > Golang ``` // to get started // read the docs @ https://github.com/gridscale/gsclient-go config := gsclient.NewConfiguration(   \"https://api.gridscale.io\",   \"##USER_UUID##\",   \"##API_TOKEN##\",   false, //set debug mode ) client := gsclient.NewClient(config) ``` <!-- #strip_go_end -->  > Shell Authentication Headers ```   -H \"X-Auth-UserId: ##USER_UUID##\" \\   -H \"X-Auth-Token: ##API_TOKEN##\" \\ ```  > Setting Authentication in your Environment variables ``` export API_TOKEN=\"##API_TOKEN##\" USER_UUID=\"##USER_UUID##\" ```  <aside class=\"notice\"> You must replace <code>USER_UUID</code> and <code>API_Token</code> with your personal UUID and API key respectively. </aside>   # noqa: E501

    OpenAPI spec version: 1.0.50
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

# import models into model package
from gs_api_client.swagger.models.access_key import AccessKey
from gs_api_client.swagger.models.access_key_create import AccessKeyCreate
from gs_api_client.swagger.models.access_key_create_response import AccessKeyCreateResponse
from gs_api_client.swagger.models.access_key_create_response_access_key import AccessKeyCreateResponseAccessKey
from gs_api_client.swagger.models.access_key_get_response import AccessKeyGetResponse
from gs_api_client.swagger.models.access_key_list import AccessKeyList
from gs_api_client.swagger.models.access_keys_get_response import AccessKeysGetResponse
from gs_api_client.swagger.models.accumulated_usage import AccumulatedUsage
from gs_api_client.swagger.models.backup_location import BackupLocation
from gs_api_client.swagger.models.backup_location_index import BackupLocationIndex
from gs_api_client.swagger.models.backup_locations_get_response import BackupLocationsGetResponse
from gs_api_client.swagger.models.bucket import Bucket
from gs_api_client.swagger.models.bucket_get_response import BucketGetResponse
from gs_api_client.swagger.models.bucket_list import BucketList
from gs_api_client.swagger.models.bucket_usage import BucketUsage
from gs_api_client.swagger.models.buckets_get_response import BucketsGetResponse
from gs_api_client.swagger.models.certificate import Certificate
from gs_api_client.swagger.models.certificate_create import CertificateCreate
from gs_api_client.swagger.models.certificate_get_response import CertificateGetResponse
from gs_api_client.swagger.models.certificate_index import CertificateIndex
from gs_api_client.swagger.models.certificates_get_response import CertificatesGetResponse
from gs_api_client.swagger.models.create_response import CreateResponse
from gs_api_client.swagger.models.current_usage_per_minute import CurrentUsagePerMinute
from gs_api_client.swagger.models.deleted_ips_get_response import DeletedIpsGetResponse
from gs_api_client.swagger.models.deleted_isoimages_get_response import DeletedIsoimagesGetResponse
from gs_api_client.swagger.models.deleted_loadbalancers_get_response import DeletedLoadbalancersGetResponse
from gs_api_client.swagger.models.deleted_networks_get_response import DeletedNetworksGetResponse
from gs_api_client.swagger.models.deleted_paas_services_get_response import DeletedPaasServicesGetResponse
from gs_api_client.swagger.models.deleted_servers_get_response import DeletedServersGetResponse
from gs_api_client.swagger.models.deleted_snapshots_get_response import DeletedSnapshotsGetResponse
from gs_api_client.swagger.models.deleted_storages_get_response import DeletedStoragesGetResponse
from gs_api_client.swagger.models.deleted_templates_get_response import DeletedTemplatesGetResponse
from gs_api_client.swagger.models.dhcp_server import DhcpServer
from gs_api_client.swagger.models.distributed_storages_usages import DistributedStoragesUsages
from gs_api_client.swagger.models.event_response import EventResponse
from gs_api_client.swagger.models.event_response_events import EventResponseEvents
from gs_api_client.swagger.models.firewall import Firewall
from gs_api_client.swagger.models.firewall_create import FirewallCreate
from gs_api_client.swagger.models.firewall_get_response import FirewallGetResponse
from gs_api_client.swagger.models.firewall_index import FirewallIndex
from gs_api_client.swagger.models.firewall_relation import FirewallRelation
from gs_api_client.swagger.models.firewall_rules import FirewallRules
from gs_api_client.swagger.models.firewall_update import FirewallUpdate
from gs_api_client.swagger.models.firewall_v4in_rule import FirewallV4inRule
from gs_api_client.swagger.models.firewall_v4out_rule import FirewallV4outRule
from gs_api_client.swagger.models.firewall_v6in_rule import FirewallV6inRule
from gs_api_client.swagger.models.firewall_v6out_rule import FirewallV6outRule
from gs_api_client.swagger.models.firewalls_get_response import FirewallsGetResponse
from gs_api_client.swagger.models.ip import Ip
from gs_api_client.swagger.models.ip_brief import IpBrief
from gs_api_client.swagger.models.ip_brief_index import IpBriefIndex
from gs_api_client.swagger.models.ip_create import IpCreate
from gs_api_client.swagger.models.ip_create_response import IpCreateResponse
from gs_api_client.swagger.models.ip_get_response import IpGetResponse
from gs_api_client.swagger.models.ip_relation import IpRelation
from gs_api_client.swagger.models.ip_update import IpUpdate
from gs_api_client.swagger.models.ips_get_response import IpsGetResponse
from gs_api_client.swagger.models.ips_usage import IpsUsage
from gs_api_client.swagger.models.ips_usages import IpsUsages
from gs_api_client.swagger.models.isoimage import Isoimage
from gs_api_client.swagger.models.isoimage_create import IsoimageCreate
from gs_api_client.swagger.models.isoimage_get_response import IsoimageGetResponse
from gs_api_client.swagger.models.isoimage_index import IsoimageIndex
from gs_api_client.swagger.models.isoimage_relation import IsoimageRelation
from gs_api_client.swagger.models.isoimage_update import IsoimageUpdate
from gs_api_client.swagger.models.isoimagein_server import IsoimageinServer
from gs_api_client.swagger.models.isoimages_get_response import IsoimagesGetResponse
from gs_api_client.swagger.models.isoimages_usage import IsoimagesUsage
from gs_api_client.swagger.models.isoimages_usages import IsoimagesUsages
from gs_api_client.swagger.models.label import Label
from gs_api_client.swagger.models.label_get_response import LabelGetResponse
from gs_api_client.swagger.models.label_index import LabelIndex
from gs_api_client.swagger.models.labels_get_response import LabelsGetResponse
from gs_api_client.swagger.models.link_ip import LinkIp
from gs_api_client.swagger.models.link_isoimage import LinkIsoimage
from gs_api_client.swagger.models.link_network import LinkNetwork
from gs_api_client.swagger.models.link_storage import LinkStorage
from gs_api_client.swagger.models.linked_ip import LinkedIp
from gs_api_client.swagger.models.linked_ip_brief import LinkedIpBrief
from gs_api_client.swagger.models.linked_ip_get_response import LinkedIpGetResponse
from gs_api_client.swagger.models.linked_ip_update import LinkedIpUpdate
from gs_api_client.swagger.models.linked_ips_get_response import LinkedIpsGetResponse
from gs_api_client.swagger.models.linked_isoimage import LinkedIsoimage
from gs_api_client.swagger.models.linked_isoimage_brief import LinkedIsoimageBrief
from gs_api_client.swagger.models.linked_isoimage_get_response import LinkedIsoimageGetResponse
from gs_api_client.swagger.models.linked_isoimage_update import LinkedIsoimageUpdate
from gs_api_client.swagger.models.linked_isoimages_get_response import LinkedIsoimagesGetResponse
from gs_api_client.swagger.models.linked_network import LinkedNetwork
from gs_api_client.swagger.models.linked_network_brief import LinkedNetworkBrief
from gs_api_client.swagger.models.linked_network_get_response import LinkedNetworkGetResponse
from gs_api_client.swagger.models.linked_network_update import LinkedNetworkUpdate
from gs_api_client.swagger.models.linked_networks_get_response import LinkedNetworksGetResponse
from gs_api_client.swagger.models.linked_storage import LinkedStorage
from gs_api_client.swagger.models.linked_storage_brief import LinkedStorageBrief
from gs_api_client.swagger.models.linked_storage_get_response import LinkedStorageGetResponse
from gs_api_client.swagger.models.linked_storage_update import LinkedStorageUpdate
from gs_api_client.swagger.models.linked_storages_get_response import LinkedStoragesGetResponse
from gs_api_client.swagger.models.listen_ports import ListenPorts
from gs_api_client.swagger.models.listen_ports_by_ip_index import ListenPortsByIpIndex
from gs_api_client.swagger.models.loadbalancer import Loadbalancer
from gs_api_client.swagger.models.loadbalancer_create import LoadbalancerCreate
from gs_api_client.swagger.models.loadbalancer_create_backend_servers import LoadbalancerCreateBackendServers
from gs_api_client.swagger.models.loadbalancer_create_forwarding_rules import LoadbalancerCreateForwardingRules
from gs_api_client.swagger.models.loadbalancer_get_response import LoadbalancerGetResponse
from gs_api_client.swagger.models.loadbalancer_index import LoadbalancerIndex
from gs_api_client.swagger.models.loadbalancer_update import LoadbalancerUpdate
from gs_api_client.swagger.models.loadbalancerin_ip import LoadbalancerinIp
from gs_api_client.swagger.models.loadbalancerin_ip_inner import LoadbalancerinIpInner
from gs_api_client.swagger.models.loadbalancers_get_response import LoadbalancersGetResponse
from gs_api_client.swagger.models.loadbalancers_usage import LoadbalancersUsage
from gs_api_client.swagger.models.loadbalancers_usages import LoadbalancersUsages
from gs_api_client.swagger.models.location import Location
from gs_api_client.swagger.models.location_change_requested import LocationChangeRequested
from gs_api_client.swagger.models.location_create import LocationCreate
from gs_api_client.swagger.models.location_get_response import LocationGetResponse
from gs_api_client.swagger.models.location_index import LocationIndex
from gs_api_client.swagger.models.location_update import LocationUpdate
from gs_api_client.swagger.models.locations_get_response import LocationsGetResponse
from gs_api_client.swagger.models.marketplace_application import MarketplaceApplication
from gs_api_client.swagger.models.marketplace_application_create import MarketplaceApplicationCreate
from gs_api_client.swagger.models.marketplace_application_create_response import MarketplaceApplicationCreateResponse
from gs_api_client.swagger.models.marketplace_application_create_setup import MarketplaceApplicationCreateSetup
from gs_api_client.swagger.models.marketplace_application_get_response import MarketplaceApplicationGetResponse
from gs_api_client.swagger.models.marketplace_application_import import MarketplaceApplicationImport
from gs_api_client.swagger.models.marketplace_application_index import MarketplaceApplicationIndex
from gs_api_client.swagger.models.marketplace_application_metadata import MarketplaceApplicationMetadata
from gs_api_client.swagger.models.marketplace_application_setup import MarketplaceApplicationSetup
from gs_api_client.swagger.models.marketplace_application_update import MarketplaceApplicationUpdate
from gs_api_client.swagger.models.marketplace_applications_get_response import MarketplaceApplicationsGetResponse
from gs_api_client.swagger.models.metrics import Metrics
from gs_api_client.swagger.models.metrics_value import MetricsValue
from gs_api_client.swagger.models.network import Network
from gs_api_client.swagger.models.network_create import NetworkCreate
from gs_api_client.swagger.models.network_get_response import NetworkGetResponse
from gs_api_client.swagger.models.network_index import NetworkIndex
from gs_api_client.swagger.models.network_pinned_servers_response import NetworkPinnedServersResponse
from gs_api_client.swagger.models.network_relation import NetworkRelation
from gs_api_client.swagger.models.network_update import NetworkUpdate
from gs_api_client.swagger.models.networkin_firewall import NetworkinFirewall
from gs_api_client.swagger.models.networkin_firewall_inner import NetworkinFirewallInner
from gs_api_client.swagger.models.networkin_server import NetworkinServer
from gs_api_client.swagger.models.networks_get_response import NetworksGetResponse
from gs_api_client.swagger.models.object_usage_overview import ObjectUsageOverview
from gs_api_client.swagger.models.paas_security_zone import PaasSecurityZone
from gs_api_client.swagger.models.paas_security_zone_create import PaasSecurityZoneCreate
from gs_api_client.swagger.models.paas_security_zone_create_response import PaasSecurityZoneCreateResponse
from gs_api_client.swagger.models.paas_security_zone_get_response import PaasSecurityZoneGetResponse
from gs_api_client.swagger.models.paas_security_zone_index import PaasSecurityZoneIndex
from gs_api_client.swagger.models.paas_security_zone_relation import PaasSecurityZoneRelation
from gs_api_client.swagger.models.paas_security_zone_update import PaasSecurityZoneUpdate
from gs_api_client.swagger.models.paas_security_zones import PaasSecurityZones
from gs_api_client.swagger.models.paas_security_zones_get_response import PaasSecurityZonesGetResponse
from gs_api_client.swagger.models.paas_security_zones_relation import PaasSecurityZonesRelation
from gs_api_client.swagger.models.paas_security_zonesin_network import PaasSecurityZonesinNetwork
from gs_api_client.swagger.models.paas_security_zonesin_network_inner import PaasSecurityZonesinNetworkInner
from gs_api_client.swagger.models.paas_service import PaasService
from gs_api_client.swagger.models.paas_service_create import PaasServiceCreate
from gs_api_client.swagger.models.paas_service_create_response import PaasServiceCreateResponse
from gs_api_client.swagger.models.paas_service_credentials import PaasServiceCredentials
from gs_api_client.swagger.models.paas_service_credentials_inner import PaasServiceCredentialsInner
from gs_api_client.swagger.models.paas_service_get_response import PaasServiceGetResponse
from gs_api_client.swagger.models.paas_service_index import PaasServiceIndex
from gs_api_client.swagger.models.paas_service_metrics_get_response import PaasServiceMetricsGetResponse
from gs_api_client.swagger.models.paas_service_metrics_list import PaasServiceMetricsList
from gs_api_client.swagger.models.paas_service_parameters import PaasServiceParameters
from gs_api_client.swagger.models.paas_service_parameters_schema import PaasServiceParametersSchema
from gs_api_client.swagger.models.paas_service_resource_limit import PaasServiceResourceLimit
from gs_api_client.swagger.models.paas_service_resource_limits import PaasServiceResourceLimits
from gs_api_client.swagger.models.paas_service_template import PaasServiceTemplate
from gs_api_client.swagger.models.paas_service_template_autoscaling import PaasServiceTemplateAutoscaling
from gs_api_client.swagger.models.paas_service_template_autoscaling_cores import PaasServiceTemplateAutoscalingCores
from gs_api_client.swagger.models.paas_service_template_autoscaling_storage import PaasServiceTemplateAutoscalingStorage
from gs_api_client.swagger.models.paas_service_template_index import PaasServiceTemplateIndex
from gs_api_client.swagger.models.paas_service_template_resources import PaasServiceTemplateResources
from gs_api_client.swagger.models.paas_service_templates_get_response import PaasServiceTemplatesGetResponse
from gs_api_client.swagger.models.paas_service_update import PaasServiceUpdate
from gs_api_client.swagger.models.paas_services_get_response import PaasServicesGetResponse
from gs_api_client.swagger.models.paas_services_usage import PaasServicesUsage
from gs_api_client.swagger.models.paas_services_usages import PaasServicesUsages
from gs_api_client.swagger.models.pinned_server import PinnedServer
from gs_api_client.swagger.models.pinned_server_payload import PinnedServerPayload
from gs_api_client.swagger.models.product_usage import ProductUsage
from gs_api_client.swagger.models.public_ipin_server import PublicIpinServer
from gs_api_client.swagger.models.request import Request
from gs_api_client.swagger.models.request_get_response import RequestGetResponse
from gs_api_client.swagger.models.rocket_storages_usages import RocketStoragesUsages
from gs_api_client.swagger.models.rules_properties import RulesProperties
from gs_api_client.swagger.models.server import Server
from gs_api_client.swagger.models.server_create import ServerCreate
from gs_api_client.swagger.models.server_create_response import ServerCreateResponse
from gs_api_client.swagger.models.server_get_response import ServerGetResponse
from gs_api_client.swagger.models.server_index import ServerIndex
from gs_api_client.swagger.models.server_metrics_get_response import ServerMetricsGetResponse
from gs_api_client.swagger.models.server_metrics_list import ServerMetricsList
from gs_api_client.swagger.models.server_power_status import ServerPowerStatus
from gs_api_client.swagger.models.server_power_update import ServerPowerUpdate
from gs_api_client.swagger.models.server_relation import ServerRelation
from gs_api_client.swagger.models.server_update import ServerUpdate
from gs_api_client.swagger.models.serverin_ip import ServerinIp
from gs_api_client.swagger.models.serverin_ip_inner import ServerinIpInner
from gs_api_client.swagger.models.serverin_isoimage import ServerinIsoimage
from gs_api_client.swagger.models.serverin_isoimage_inner import ServerinIsoimageInner
from gs_api_client.swagger.models.serverin_network import ServerinNetwork
from gs_api_client.swagger.models.serverin_network_inner import ServerinNetworkInner
from gs_api_client.swagger.models.serverin_strorage import ServerinStrorage
from gs_api_client.swagger.models.serverin_strorage_inner import ServerinStrorageInner
from gs_api_client.swagger.models.servers_get_response import ServersGetResponse
from gs_api_client.swagger.models.servers_usage import ServersUsage
from gs_api_client.swagger.models.servers_usages import ServersUsages
from gs_api_client.swagger.models.servicein_paas_security_zone import ServiceinPaasSecurityZone
from gs_api_client.swagger.models.servicein_paas_security_zone_inner import ServiceinPaasSecurityZoneInner
from gs_api_client.swagger.models.servicein_paas_security_zones import ServiceinPaasSecurityZones
from gs_api_client.swagger.models.servicein_paas_security_zones_inner import ServiceinPaasSecurityZonesInner
from gs_api_client.swagger.models.snapshot import Snapshot
from gs_api_client.swagger.models.snapshot_create import SnapshotCreate
from gs_api_client.swagger.models.snapshot_export_to_s3_payload import SnapshotExportToS3Payload
from gs_api_client.swagger.models.snapshot_export_to_s3_payload_s3auth import SnapshotExportToS3PayloadS3auth
from gs_api_client.swagger.models.snapshot_export_to_s3_payload_s3data import SnapshotExportToS3PayloadS3data
from gs_api_client.swagger.models.snapshot_get_response import SnapshotGetResponse
from gs_api_client.swagger.models.snapshot_index import SnapshotIndex
from gs_api_client.swagger.models.snapshot_schedule import SnapshotSchedule
from gs_api_client.swagger.models.snapshot_schedule_create import SnapshotScheduleCreate
from gs_api_client.swagger.models.snapshot_schedule_get_response import SnapshotScheduleGetResponse
from gs_api_client.swagger.models.snapshot_schedule_index import SnapshotScheduleIndex
from gs_api_client.swagger.models.snapshot_schedule_relations import SnapshotScheduleRelations
from gs_api_client.swagger.models.snapshot_schedule_relations_snapshots import SnapshotScheduleRelationsSnapshots
from gs_api_client.swagger.models.snapshot_schedule_update import SnapshotScheduleUpdate
from gs_api_client.swagger.models.snapshot_schedules_get_response import SnapshotSchedulesGetResponse
from gs_api_client.swagger.models.snapshot_schedulesin_storage import SnapshotSchedulesinStorage
from gs_api_client.swagger.models.snapshot_schedulesin_storage_inner import SnapshotSchedulesinStorageInner
from gs_api_client.swagger.models.snapshot_update import SnapshotUpdate
from gs_api_client.swagger.models.snapshots_get_response import SnapshotsGetResponse
from gs_api_client.swagger.models.snapshots_usage import SnapshotsUsage
from gs_api_client.swagger.models.snapshots_usages import SnapshotsUsages
from gs_api_client.swagger.models.sshkey import Sshkey
from gs_api_client.swagger.models.sshkey_create import SshkeyCreate
from gs_api_client.swagger.models.sshkey_get_response import SshkeyGetResponse
from gs_api_client.swagger.models.sshkey_index import SshkeyIndex
from gs_api_client.swagger.models.sshkey_update import SshkeyUpdate
from gs_api_client.swagger.models.sshkeys_get_response import SshkeysGetResponse
from gs_api_client.swagger.models.storage import Storage
from gs_api_client.swagger.models.storage_backup import StorageBackup
from gs_api_client.swagger.models.storage_backup_index import StorageBackupIndex
from gs_api_client.swagger.models.storage_backup_schedule import StorageBackupSchedule
from gs_api_client.swagger.models.storage_backup_schedule_create import StorageBackupScheduleCreate
from gs_api_client.swagger.models.storage_backup_schedule_get_response import StorageBackupScheduleGetResponse
from gs_api_client.swagger.models.storage_backup_schedule_index import StorageBackupScheduleIndex
from gs_api_client.swagger.models.storage_backup_schedule_relations import StorageBackupScheduleRelations
from gs_api_client.swagger.models.storage_backup_schedule_update import StorageBackupScheduleUpdate
from gs_api_client.swagger.models.storage_backup_schedules_get_response import StorageBackupSchedulesGetResponse
from gs_api_client.swagger.models.storage_backup_usages import StorageBackupUsages
from gs_api_client.swagger.models.storage_backups_get_response import StorageBackupsGetResponse
from gs_api_client.swagger.models.storage_backups_usage import StorageBackupsUsage
from gs_api_client.swagger.models.storage_clone import StorageClone
from gs_api_client.swagger.models.storage_create import StorageCreate
from gs_api_client.swagger.models.storage_create_template_password import StorageCreateTemplatePassword
from gs_api_client.swagger.models.storage_create_template_sshkey import StorageCreateTemplateSshkey
from gs_api_client.swagger.models.storage_get_response import StorageGetResponse
from gs_api_client.swagger.models.storage_import_from_backup import StorageImportFromBackup
from gs_api_client.swagger.models.storage_import_from_backup_backup import StorageImportFromBackupBackup
from gs_api_client.swagger.models.storage_import_from_s3_object import StorageImportFromS3Object
from gs_api_client.swagger.models.storage_index import StorageIndex
from gs_api_client.swagger.models.storage_rollback import StorageRollback
from gs_api_client.swagger.models.storage_snapshots import StorageSnapshots
from gs_api_client.swagger.models.storage_template_create import StorageTemplateCreate
from gs_api_client.swagger.models.storage_templates_get_response import StorageTemplatesGetResponse
from gs_api_client.swagger.models.storage_type import StorageType
from gs_api_client.swagger.models.storage_update import StorageUpdate
from gs_api_client.swagger.models.storage_variant import StorageVariant
from gs_api_client.swagger.models.storages_get_response import StoragesGetResponse
from gs_api_client.swagger.models.storages_relation import StoragesRelation
from gs_api_client.swagger.models.storages_usage import StoragesUsage
from gs_api_client.swagger.models.storagesin_server import StoragesinServer
from gs_api_client.swagger.models.task_event_label import TaskEventLabel
from gs_api_client.swagger.models.task_event_label_schema import TaskEventLabelSchema
from gs_api_client.swagger.models.task_event_name import TaskEventName
from gs_api_client.swagger.models.task_events import TaskEvents
from gs_api_client.swagger.models.task_events_certificate import TaskEventsCertificate
from gs_api_client.swagger.models.task_events_certificate_certificate_remove import TaskEventsCertificateCertificateRemove
from gs_api_client.swagger.models.task_events_firewall import TaskEventsFirewall
from gs_api_client.swagger.models.task_events_firewall_firewall_remove import TaskEventsFirewallFirewallRemove
from gs_api_client.swagger.models.task_events_firewall_firewall_update import TaskEventsFirewallFirewallUpdate
from gs_api_client.swagger.models.task_events_firewall_firewall_update_rules import TaskEventsFirewallFirewallUpdateRules
from gs_api_client.swagger.models.task_events_firewall_firewall_update_rules_schema import TaskEventsFirewallFirewallUpdateRulesSchema
from gs_api_client.swagger.models.task_events_firewall_firewall_update_rules_schema_rulesv4out import TaskEventsFirewallFirewallUpdateRulesSchemaRulesv4out
from gs_api_client.swagger.models.task_events_firewall_firewall_update_rules_schema_rulesv4out_schema import TaskEventsFirewallFirewallUpdateRulesSchemaRulesv4outSchema
from gs_api_client.swagger.models.task_events_firewall_firewall_update_rules_schema_rulesv4out_schema_action import TaskEventsFirewallFirewallUpdateRulesSchemaRulesv4outSchemaAction
from gs_api_client.swagger.models.task_events_firewall_firewall_update_rules_schema_rulesv4out_schema_order import TaskEventsFirewallFirewallUpdateRulesSchemaRulesv4outSchemaOrder
from gs_api_client.swagger.models.task_events_firewall_firewall_update_rules_schema_rulesv4out_schema_src_cidr import TaskEventsFirewallFirewallUpdateRulesSchemaRulesv4outSchemaSrcCidr
from gs_api_client.swagger.models.task_events_ipaddr import TaskEventsIpaddr
from gs_api_client.swagger.models.task_events_ipaddr_ipaddr_add import TaskEventsIpaddrIpaddrAdd
from gs_api_client.swagger.models.task_events_ipaddr_ipaddr_add_family import TaskEventsIpaddrIpaddrAddFamily
from gs_api_client.swagger.models.task_events_ipaddr_ipaddr_remove import TaskEventsIpaddrIpaddrRemove
from gs_api_client.swagger.models.task_events_ipaddr_ipaddr_update import TaskEventsIpaddrIpaddrUpdate
from gs_api_client.swagger.models.task_events_ipaddr_ipaddr_update_failover import TaskEventsIpaddrIpaddrUpdateFailover
from gs_api_client.swagger.models.task_events_ipaddr_ipaddr_update_reverse_dns import TaskEventsIpaddrIpaddrUpdateReverseDns
from gs_api_client.swagger.models.task_events_isoimage import TaskEventsIsoimage
from gs_api_client.swagger.models.task_events_isoimage_isoimage_add import TaskEventsIsoimageIsoimageAdd
from gs_api_client.swagger.models.task_events_isoimage_isoimage_add_isoimage_uuid import TaskEventsIsoimageIsoimageAddIsoimageUuid
from gs_api_client.swagger.models.task_events_isoimage_isoimage_add_source_url import TaskEventsIsoimageIsoimageAddSourceUrl
from gs_api_client.swagger.models.task_events_isoimage_isoimage_remove import TaskEventsIsoimageIsoimageRemove
from gs_api_client.swagger.models.task_events_isoimage_isoimage_update import TaskEventsIsoimageIsoimageUpdate
from gs_api_client.swagger.models.task_events_loadbalancer import TaskEventsLoadbalancer
from gs_api_client.swagger.models.task_events_loadbalancer_loadbalancer_remove import TaskEventsLoadbalancerLoadbalancerRemove
from gs_api_client.swagger.models.task_events_loadbalancer_loadbalancer_update import TaskEventsLoadbalancerLoadbalancerUpdate
from gs_api_client.swagger.models.task_events_loadbalancer_loadbalancer_update_algorithm import TaskEventsLoadbalancerLoadbalancerUpdateAlgorithm
from gs_api_client.swagger.models.task_events_loadbalancer_loadbalancer_update_backend_servers import TaskEventsLoadbalancerLoadbalancerUpdateBackendServers
from gs_api_client.swagger.models.task_events_loadbalancer_loadbalancer_update_backend_servers_schema import TaskEventsLoadbalancerLoadbalancerUpdateBackendServersSchema
from gs_api_client.swagger.models.task_events_loadbalancer_loadbalancer_update_backend_servers_schema_schema import TaskEventsLoadbalancerLoadbalancerUpdateBackendServersSchemaSchema
from gs_api_client.swagger.models.task_events_loadbalancer_loadbalancer_update_backend_servers_schema_schema_host import TaskEventsLoadbalancerLoadbalancerUpdateBackendServersSchemaSchemaHost
from gs_api_client.swagger.models.task_events_loadbalancer_loadbalancer_update_backend_servers_schema_schema_weight import TaskEventsLoadbalancerLoadbalancerUpdateBackendServersSchemaSchemaWeight
from gs_api_client.swagger.models.task_events_loadbalancer_loadbalancer_update_forwarding_rule import TaskEventsLoadbalancerLoadbalancerUpdateForwardingRule
from gs_api_client.swagger.models.task_events_loadbalancer_loadbalancer_update_forwarding_rule_schema import TaskEventsLoadbalancerLoadbalancerUpdateForwardingRuleSchema
from gs_api_client.swagger.models.task_events_loadbalancer_loadbalancer_update_forwarding_rule_schema_schema import TaskEventsLoadbalancerLoadbalancerUpdateForwardingRuleSchemaSchema
from gs_api_client.swagger.models.task_events_loadbalancer_loadbalancer_update_forwarding_rule_schema_schema_letsencrypt_ssl import TaskEventsLoadbalancerLoadbalancerUpdateForwardingRuleSchemaSchemaLetsencryptSsl
from gs_api_client.swagger.models.task_events_loadbalancer_loadbalancer_update_forwarding_rule_schema_schema_mode import TaskEventsLoadbalancerLoadbalancerUpdateForwardingRuleSchemaSchemaMode
from gs_api_client.swagger.models.task_events_loadbalancer_loadbalancer_update_redirect_http_to_https import TaskEventsLoadbalancerLoadbalancerUpdateRedirectHttpToHttps
from gs_api_client.swagger.models.task_events_marketplace_template import TaskEventsMarketplaceTemplate
from gs_api_client.swagger.models.task_events_marketplace_template_marketplace_template_add import TaskEventsMarketplaceTemplateMarketplaceTemplateAdd
from gs_api_client.swagger.models.task_events_marketplace_template_marketplace_template_add_capacity import TaskEventsMarketplaceTemplateMarketplaceTemplateAddCapacity
from gs_api_client.swagger.models.task_events_marketplace_template_marketplace_template_add_object_storage_path import TaskEventsMarketplaceTemplateMarketplaceTemplateAddObjectStoragePath
from gs_api_client.swagger.models.task_events_marketplace_template_marketplace_template_import import TaskEventsMarketplaceTemplateMarketplaceTemplateImport
from gs_api_client.swagger.models.task_events_marketplace_template_marketplace_template_import_unique_hash import TaskEventsMarketplaceTemplateMarketplaceTemplateImportUniqueHash
from gs_api_client.swagger.models.task_events_marketplace_template_marketplace_template_remove import TaskEventsMarketplaceTemplateMarketplaceTemplateRemove
from gs_api_client.swagger.models.task_events_marketplace_template_marketplace_template_remove_template_uuid import TaskEventsMarketplaceTemplateMarketplaceTemplateRemoveTemplateUuid
from gs_api_client.swagger.models.task_events_network import TaskEventsNetwork
from gs_api_client.swagger.models.task_events_network_network_add import TaskEventsNetworkNetworkAdd
from gs_api_client.swagger.models.task_events_network_network_add_l2security import TaskEventsNetworkNetworkAddL2security
from gs_api_client.swagger.models.task_events_network_network_remove import TaskEventsNetworkNetworkRemove
from gs_api_client.swagger.models.task_events_network_network_update import TaskEventsNetworkNetworkUpdate
from gs_api_client.swagger.models.task_events_paas import TaskEventsPaas
from gs_api_client.swagger.models.task_events_paas_paas_security_zone_add import TaskEventsPaasPaasSecurityZoneAdd
from gs_api_client.swagger.models.task_events_paas_paas_security_zone_remove import TaskEventsPaasPaasSecurityZoneRemove
from gs_api_client.swagger.models.task_events_paas_paas_security_zone_update import TaskEventsPaasPaasSecurityZoneUpdate
from gs_api_client.swagger.models.task_events_paas_paas_service_add import TaskEventsPaasPaasServiceAdd
from gs_api_client.swagger.models.task_events_paas_paas_service_add_credentials import TaskEventsPaasPaasServiceAddCredentials
from gs_api_client.swagger.models.task_events_paas_paas_service_add_credentials_schema import TaskEventsPaasPaasServiceAddCredentialsSchema
from gs_api_client.swagger.models.task_events_paas_paas_service_add_resource_limit import TaskEventsPaasPaasServiceAddResourceLimit
from gs_api_client.swagger.models.task_events_paas_paas_service_add_resource_limit_schema import TaskEventsPaasPaasServiceAddResourceLimitSchema
from gs_api_client.swagger.models.task_events_paas_paas_service_add_resource_limit_schema_anyof import TaskEventsPaasPaasServiceAddResourceLimitSchemaAnyof
from gs_api_client.swagger.models.task_events_paas_paas_service_add_resource_limit_schema_schema import TaskEventsPaasPaasServiceAddResourceLimitSchemaSchema
from gs_api_client.swagger.models.task_events_paas_paas_service_add_resource_limit_schema_schema_limit import TaskEventsPaasPaasServiceAddResourceLimitSchemaSchemaLimit
from gs_api_client.swagger.models.task_events_paas_paas_service_add_resource_limit_schema_schema_resource import TaskEventsPaasPaasServiceAddResourceLimitSchemaSchemaResource
from gs_api_client.swagger.models.task_events_paas_paas_service_remove import TaskEventsPaasPaasServiceRemove
from gs_api_client.swagger.models.task_events_paas_paas_service_update import TaskEventsPaasPaasServiceUpdate
from gs_api_client.swagger.models.task_events_schedules import TaskEventsSchedules
from gs_api_client.swagger.models.task_events_schedules_schedule_snapshot_add import TaskEventsSchedulesScheduleSnapshotAdd
from gs_api_client.swagger.models.task_events_schedules_schedule_snapshot_add_next_runtime import TaskEventsSchedulesScheduleSnapshotAddNextRuntime
from gs_api_client.swagger.models.task_events_schedules_schedule_snapshot_add_run_interval import TaskEventsSchedulesScheduleSnapshotAddRunInterval
from gs_api_client.swagger.models.task_events_schedules_schedule_snapshot_add_schedule_uuid import TaskEventsSchedulesScheduleSnapshotAddScheduleUuid
from gs_api_client.swagger.models.task_events_schedules_schedule_snapshot_add_storage_uuid import TaskEventsSchedulesScheduleSnapshotAddStorageUuid
from gs_api_client.swagger.models.task_events_schedules_schedule_snapshot_perform import TaskEventsSchedulesScheduleSnapshotPerform
from gs_api_client.swagger.models.task_events_schedules_schedule_snapshot_remove import TaskEventsSchedulesScheduleSnapshotRemove
from gs_api_client.swagger.models.task_events_server import TaskEventsServer
from gs_api_client.swagger.models.task_events_server_server_add import TaskEventsServerServerAdd
from gs_api_client.swagger.models.task_events_server_server_add_auto_recovery import TaskEventsServerServerAddAutoRecovery
from gs_api_client.swagger.models.task_events_server_server_add_availability_zone import TaskEventsServerServerAddAvailabilityZone
from gs_api_client.swagger.models.task_events_server_server_add_cores import TaskEventsServerServerAddCores
from gs_api_client.swagger.models.task_events_server_server_add_hardware_profile import TaskEventsServerServerAddHardwareProfile
from gs_api_client.swagger.models.task_events_server_server_power_update import TaskEventsServerServerPowerUpdate
from gs_api_client.swagger.models.task_events_server_server_power_update_power import TaskEventsServerServerPowerUpdatePower
from gs_api_client.swagger.models.task_events_server_server_relation_ipaddr_add import TaskEventsServerServerRelationIpaddrAdd
from gs_api_client.swagger.models.task_events_server_server_relation_isoimage_add import TaskEventsServerServerRelationIsoimageAdd
from gs_api_client.swagger.models.task_events_server_server_relation_isoimage_remove import TaskEventsServerServerRelationIsoimageRemove
from gs_api_client.swagger.models.task_events_server_server_relation_network_add import TaskEventsServerServerRelationNetworkAdd
from gs_api_client.swagger.models.task_events_server_server_relation_network_add_firewall import TaskEventsServerServerRelationNetworkAddFirewall
from gs_api_client.swagger.models.task_events_server_server_relation_network_add_firewall_template_uuid import TaskEventsServerServerRelationNetworkAddFirewallTemplateUuid
from gs_api_client.swagger.models.task_events_server_server_relation_network_add_l3security import TaskEventsServerServerRelationNetworkAddL3security
from gs_api_client.swagger.models.task_events_server_server_relation_network_add_ordering import TaskEventsServerServerRelationNetworkAddOrdering
from gs_api_client.swagger.models.task_events_server_server_relation_network_remove import TaskEventsServerServerRelationNetworkRemove
from gs_api_client.swagger.models.task_events_server_server_relation_storage_add import TaskEventsServerServerRelationStorageAdd
from gs_api_client.swagger.models.task_events_server_server_relation_storage_remove import TaskEventsServerServerRelationStorageRemove
from gs_api_client.swagger.models.task_events_server_server_remove import TaskEventsServerServerRemove
from gs_api_client.swagger.models.task_events_server_server_update import TaskEventsServerServerUpdate
from gs_api_client.swagger.models.task_events_snapshot import TaskEventsSnapshot
from gs_api_client.swagger.models.task_events_snapshot_snapshot_add import TaskEventsSnapshotSnapshotAdd
from gs_api_client.swagger.models.task_events_snapshot_snapshot_export_tos3 import TaskEventsSnapshotSnapshotExportTos3
from gs_api_client.swagger.models.task_events_snapshot_snapshot_export_tos3_s3auth import TaskEventsSnapshotSnapshotExportTos3S3auth
from gs_api_client.swagger.models.task_events_snapshot_snapshot_export_tos3_s3auth_schema import TaskEventsSnapshotSnapshotExportTos3S3authSchema
from gs_api_client.swagger.models.task_events_snapshot_snapshot_export_tos3_s3auth_schema_secret_key import TaskEventsSnapshotSnapshotExportTos3S3authSchemaSecretKey
from gs_api_client.swagger.models.task_events_snapshot_snapshot_export_tos3_s3data import TaskEventsSnapshotSnapshotExportTos3S3data
from gs_api_client.swagger.models.task_events_snapshot_snapshot_export_tos3_s3data_schema import TaskEventsSnapshotSnapshotExportTos3S3dataSchema
from gs_api_client.swagger.models.task_events_snapshot_snapshot_remove import TaskEventsSnapshotSnapshotRemove
from gs_api_client.swagger.models.task_events_snapshot_snapshot_rollback import TaskEventsSnapshotSnapshotRollback
from gs_api_client.swagger.models.task_events_sshkey import TaskEventsSshkey
from gs_api_client.swagger.models.task_events_sshkey_sshkey_add import TaskEventsSshkeySshkeyAdd
from gs_api_client.swagger.models.task_events_sshkey_sshkey_add_sshkey import TaskEventsSshkeySshkeyAddSshkey
from gs_api_client.swagger.models.task_events_sshkey_sshkey_remove import TaskEventsSshkeySshkeyRemove
from gs_api_client.swagger.models.task_events_storage import TaskEventsStorage
from gs_api_client.swagger.models.task_events_storage_isoimage_update import TaskEventsStorageIsoimageUpdate
from gs_api_client.swagger.models.task_events_storage_storage_add import TaskEventsStorageStorageAdd
from gs_api_client.swagger.models.task_events_storage_storage_add_storage_type import TaskEventsStorageStorageAddStorageType
from gs_api_client.swagger.models.task_events_storage_storage_add_template import TaskEventsStorageStorageAddTemplate
from gs_api_client.swagger.models.task_events_storage_storage_add_template_schema import TaskEventsStorageStorageAddTemplateSchema
from gs_api_client.swagger.models.task_events_storage_storage_add_template_schema_password import TaskEventsStorageStorageAddTemplateSchemaPassword
from gs_api_client.swagger.models.task_events_storage_storage_add_template_schema_password_type import TaskEventsStorageStorageAddTemplateSchemaPasswordType
from gs_api_client.swagger.models.task_events_storage_storage_add_template_schema_sshkeys import TaskEventsStorageStorageAddTemplateSchemaSshkeys
from gs_api_client.swagger.models.task_events_storage_storage_remove import TaskEventsStorageStorageRemove
from gs_api_client.swagger.models.task_events_template import TaskEventsTemplate
from gs_api_client.swagger.models.task_events_template_template_add import TaskEventsTemplateTemplateAdd
from gs_api_client.swagger.models.task_events_template_template_remove import TaskEventsTemplateTemplateRemove
from gs_api_client.swagger.models.task_events_template_template_update import TaskEventsTemplateTemplateUpdate
from gs_api_client.swagger.models.template import Template
from gs_api_client.swagger.models.template_get_response import TemplateGetResponse
from gs_api_client.swagger.models.template_index import TemplateIndex
from gs_api_client.swagger.models.template_update import TemplateUpdate
from gs_api_client.swagger.models.templates_get_response import TemplatesGetResponse
from gs_api_client.swagger.models.templates_usage import TemplatesUsage
from gs_api_client.swagger.models.templates_usages import TemplatesUsages
from gs_api_client.swagger.models.usage_get_response_overview import UsageGetResponseOverview
from gs_api_client.swagger.models.usage_get_response_overview_products import UsageGetResponseOverviewProducts
from gs_api_client.swagger.models.usage_per_interval import UsagePerInterval
from gs_api_client.swagger.models.usage_per_interval_inner import UsagePerIntervalInner
from gs_api_client.swagger.models.vlansin_network import VlansinNetwork
from gs_api_client.swagger.models.paas_service_metrics import PaasServiceMetrics
from gs_api_client.swagger.models.server_metrics import ServerMetrics
from gs_api_client.swagger.models.paas_services_in_network import PaasServicesInNetwork
from gs_api_client.swagger.models.paas_services_in_network_inner import PaasServicesInNetworkInner
from gs_api_client.swagger.models.paas_servicesin_network import PaasServicesinNetwork
from gs_api_client.swagger.models.paas_servicesin_network_inner import PaasServicesinNetworkInner
from gs_api_client.swagger.models.backup_schedulesin_storage import BackupSchedulesinStorage
from gs_api_client.swagger.models.storage_backups import StorageBackups

