"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs = require("fs");
const path = require("path");
const follow_mode_1 = require("./follow-mode");
const utils_1 = require("./utils");
function copyDirectory(srcDir, destDir, options = {}, rootDir) {
    const follow = options.follow !== undefined ? options.follow : follow_mode_1.FollowMode.EXTERNAL;
    const exclude = options.exclude || [];
    rootDir = rootDir || srcDir;
    if (!fs.statSync(srcDir).isDirectory()) {
        throw new Error(`${srcDir} is not a directory`);
    }
    const files = fs.readdirSync(srcDir);
    for (const file of files) {
        const sourceFilePath = path.join(srcDir, file);
        if (utils_1.shouldExclude(exclude, path.relative(rootDir, sourceFilePath))) {
            continue;
        }
        const destFilePath = path.join(destDir, file);
        let stat = follow === follow_mode_1.FollowMode.ALWAYS
            ? fs.statSync(sourceFilePath)
            : fs.lstatSync(sourceFilePath);
        if (stat && stat.isSymbolicLink()) {
            const target = fs.readlinkSync(sourceFilePath);
            // determine if this is an external link (i.e. the target's absolute path
            // is outside of the root directory).
            const targetPath = path.normalize(path.resolve(srcDir, target));
            if (utils_1.shouldFollow(follow, rootDir, targetPath)) {
                stat = fs.statSync(sourceFilePath);
            }
            else {
                fs.symlinkSync(target, destFilePath);
                stat = undefined;
            }
        }
        if (stat && stat.isDirectory()) {
            fs.mkdirSync(destFilePath);
            copyDirectory(sourceFilePath, destFilePath, options, rootDir);
            stat = undefined;
        }
        if (stat && stat.isFile()) {
            fs.copyFileSync(sourceFilePath, destFilePath);
            stat = undefined;
        }
    }
}
exports.copyDirectory = copyDirectory;
//# sourceMappingURL=data:application/json;base64,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