import { Test } from 'nodeunit';
declare const _default: {
    shouldExclude: {
        'excludes nothing by default'(test: Test): void;
        'excludes requested files'(test: Test): void;
        'does not exclude whitelisted files'(test: Test): void;
    };
    shouldFollow: {
        always: {
            'follows internal'(test: Test): void;
            'follows external'(test: Test): void;
            'does not follow internal when the referent does not exist'(test: Test): void;
            'does not follow external when the referent does not exist'(test: Test): void;
        };
        external: {
            'does not follow internal'(test: Test): void;
            'follows external'(test: Test): void;
            'does not follow external when referent does not exist'(test: Test): void;
        };
        blockExternal: {
            'follows internal'(test: Test): void;
            'does not follow internal when referent does not exist'(test: Test): void;
            'does not follow external'(test: Test): void;
        };
        never: {
            'does not follow internal'(test: Test): void;
            'does not follow external'(test: Test): void;
        };
    };
};
export = _default;
