"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.shell = void 0;
const child_process_1 = require("child_process");
function shell(command, ...args) {
    const proc = child_process_1.spawnSync(command, args);
    if (proc.error) {
        throw new Error(proc.error.message);
    }
    if (proc.status !== 0) {
        throw new Error(`non-zero exist code ${proc.status}: ${proc.stdout} ${proc.stderr}`);
    }
    return proc.stdout.toString('utf-8');
}
exports.shell = shell;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiX3NoZWxsLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL19zaGVsbC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxpREFBMEM7QUFFMUMsU0FBZ0IsS0FBSyxDQUFDLE9BQWUsRUFBRSxHQUFHLElBQWM7SUFDdEQsTUFBTSxJQUFJLEdBQUcseUJBQVMsQ0FBQyxPQUFPLEVBQUUsSUFBSSxDQUFDLENBQUM7SUFFdEMsSUFBSSxJQUFJLENBQUMsS0FBSyxFQUFFO1FBQ2QsTUFBTSxJQUFJLEtBQUssQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLE9BQU8sQ0FBQyxDQUFDO0tBQ3JDO0lBRUQsSUFBSSxJQUFJLENBQUMsTUFBTSxLQUFLLENBQUMsRUFBRTtRQUNyQixNQUFNLElBQUksS0FBSyxDQUFDLHVCQUF1QixJQUFJLENBQUMsTUFBTSxLQUFLLElBQUksQ0FBQyxNQUFNLElBQUksSUFBSSxDQUFDLE1BQU0sRUFBRSxDQUFDLENBQUM7S0FDdEY7SUFFRCxPQUFPLElBQUksQ0FBQyxNQUFNLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxDQUFDO0FBQ3ZDLENBQUM7QUFaRCxzQkFZQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IHNwYXduU3luYyB9IGZyb20gJ2NoaWxkX3Byb2Nlc3MnO1xuXG5leHBvcnQgZnVuY3Rpb24gc2hlbGwoY29tbWFuZDogc3RyaW5nLCAuLi5hcmdzOiBzdHJpbmdbXSk6IHN0cmluZyB7XG4gIGNvbnN0IHByb2MgPSBzcGF3blN5bmMoY29tbWFuZCwgYXJncyk7XG5cbiAgaWYgKHByb2MuZXJyb3IpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IocHJvYy5lcnJvci5tZXNzYWdlKTtcbiAgfVxuXG4gIGlmIChwcm9jLnN0YXR1cyAhPT0gMCkge1xuICAgIHRocm93IG5ldyBFcnJvcihgbm9uLXplcm8gZXhpc3QgY29kZSAke3Byb2Muc3RhdHVzfTogJHtwcm9jLnN0ZG91dH0gJHtwcm9jLnN0ZGVycn1gKTtcbiAgfVxuXG4gIHJldHVybiBwcm9jLnN0ZG91dC50b1N0cmluZygndXRmLTgnKTtcbn0iXX0=