# coding: utf-8

from __future__ import absolute_import

from typing import List  # noqa: F401

from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib.models.base_model_ import Model
from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib.util import deserialize_model


class ServiceFunctionRegistrationRequest(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(
        self,
        service_function_id: str = None,
        service_function_name: str = None,
        service_function_image: str = None,
        service_function_type: str = None,
        application_ports: List[int] = None,
    ):  # noqa: E501
        """ServiceFunctionRegistrationRequest - a model defined in Swagger

        :param service_function_name: The service_function_name of this ServiceFunctionRegistrationRequest.  # noqa: E501
        :type service_function_name: str
        :param service_function_image: The service_function_image of this ServiceFunctionRegistrationRequest.  # noqa: E501
        :type service_function_image: str
        :param service_function_type: The service_function_type of this ServiceFunctionRegistrationRequest.  # noqa: E501
        :type service_function_type: str
        :param application_ports: The application_ports of this ServiceFunctionRegistrationRequest.  # noqa: E501
        :type application_ports: List[int]
        :param autoscaling_policies: The autoscaling_policies of this ServiceFunctionRegistrationRequest.  # noqa: E501
        :type autoscaling_policies: List[AutoscalingPolicy]
        :param required_volumes: The required_volumes of this ServiceFunctionRegistrationRequest.  # noqa: E501
        :type required_volumes: List[Volume]
        :param required_env_parameters: The required_env_parameters of this ServiceFunctionRegistrationRequest.  # noqa: E501
        :type required_env_parameters: List[EnvParameterName]
        :param privileged: The privileged of this ServiceFunctionRegistrationRequest.  # noqa: E501
        :type privileged: bool
        """
        self.swagger_types = {
            "service_function_id": str,
            "service_function_name": str,
            "service_function_image": str,
            "service_function_type": str,
            "application_ports": List[int],
        }

        self.attribute_map = {
            "service_function_id": "service_function_id",
            "service_function_name": "service_function_name",
            "service_function_image": "service_function_image",
            "service_function_type": "service_function_type",
            "application_ports": "application_ports",
        }
        self._service_function_id = service_function_id
        self._service_function_name = service_function_name
        self._service_function_image = service_function_image
        self._service_function_type = service_function_type
        self._application_ports = application_ports

    @classmethod
    def from_dict(cls, dikt) -> "ServiceFunctionRegistrationRequest":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ServiceFunctionRegistrationRequest of this ServiceFunctionRegistrationRequest.  # noqa: E501
        :rtype: ServiceFunctionRegistrationRequest
        """
        return deserialize_model(dikt, cls)

    @property
    def service_function_id(self) -> str:
        """Gets the service_function_name of this ServiceFunctionRegistrationRequest.


        :return: The service_function_name of this ServiceFunctionRegistrationRequest.
        :rtype: str
        """
        return self._service_function_id

    @service_function_id.setter
    def service_function_id(self, service_function_id: str):
        """Sets the service_function_name of this ServiceFunctionRegistrationRequest.


        :param service_function_name: The service_function_name of this ServiceFunctionRegistrationRequest.
        :type service_function_name: str
        """

        self._service_function_id = service_function_id

    @property
    def service_function_name(self) -> str:
        """Gets the service_function_name of this ServiceFunctionRegistrationRequest.


        :return: The service_function_name of this ServiceFunctionRegistrationRequest.
        :rtype: str
        """
        return self._service_function_name

    @service_function_name.setter
    def service_function_name(self, service_function_name: str):
        """Sets the service_function_name of this ServiceFunctionRegistrationRequest.


        :param service_function_name: The service_function_name of this ServiceFunctionRegistrationRequest.
        :type service_function_name: str
        """

        self._service_function_name = service_function_name

    @property
    def service_function_image(self) -> str:
        """Gets the service_function_image of this ServiceFunctionRegistrationRequest.


        :return: The service_function_image of this ServiceFunctionRegistrationRequest.
        :rtype: str
        """
        return self._service_function_image

    @service_function_image.setter
    def service_function_image(self, service_function_image: str):
        """Sets the service_function_image of this ServiceFunctionRegistrationRequest.


        :param service_function_image: The service_function_image of this ServiceFunctionRegistrationRequest.
        :type service_function_image: str
        """

        self._service_function_image = service_function_image

    @property
    def service_function_type(self) -> str:
        """Gets the service_function_type of this ServiceFunctionRegistrationRequest.


        :return: The service_function_type of this ServiceFunctionRegistrationRequest.
        :rtype: str
        """
        return self._service_function_type

    @service_function_type.setter
    def service_function_type(self, service_function_type: str):
        """Sets the service_function_type of this ServiceFunctionRegistrationRequest.


        :param service_function_type: The service_function_type of this ServiceFunctionRegistrationRequest.
        :type service_function_type: str
        """

        self._service_function_type = service_function_type

    @property
    def application_ports(self) -> List[int]:
        """Gets the application_ports of this ServiceFunctionRegistrationRequest.


        :return: The application_ports of this ServiceFunctionRegistrationRequest.
        :rtype: List[int]
        """
        return self._application_ports

    @application_ports.setter
    def application_ports(self, application_ports: List[int]):
        """Sets the application_ports of this ServiceFunctionRegistrationRequest.


        :param application_ports: The application_ports of this ServiceFunctionRegistrationRequest.
        :type application_ports: List[int]
        """

        self._application_ports = application_ports
