# coding: utf-8

from __future__ import absolute_import

from datetime import date, datetime  # noqa: F401
from typing import Dict, List  # noqa: F401

from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib import util
from sunrise6g_opensdk.edgecloud.adapters.kubernetes.lib.models.base_model_ import Model


class Volume(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    def __init__(self, name: str = None, path: str = None, hostpath: str = None):  # noqa: E501
        """Volume - a model defined in Swagger

        :param name: The name of this Volume.  # noqa: E501
        :type name: str
        :param path: The path of this Volume.  # noqa: E501
        :type path: str
        :param hostpath: The hostpath of this Volume.  # noqa: E501
        :type hostpath: str
        """
        self.swagger_types = {"name": str, "path": str, "hostpath": str}

        self.attribute_map = {"name": "name", "path": "path", "hostpath": "hostpath"}
        self._name = name
        self._path = path
        self._hostpath = hostpath

    @classmethod
    def from_dict(cls, dikt) -> "Volume":
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The volume of this Volume.  # noqa: E501
        :rtype: Volume
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self) -> str:
        """Gets the name of this Volume.


        :return: The name of this Volume.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str):
        """Sets the name of this Volume.


        :param name: The name of this Volume.
        :type name: str
        """

        self._name = name

    @property
    def path(self) -> str:
        """Gets the path of this Volume.


        :return: The path of this Volume.
        :rtype: str
        """
        return self._path

    @path.setter
    def path(self, path: str):
        """Sets the path of this Volume.


        :param path: The path of this Volume.
        :type path: str
        """

        self._path = path

    @property
    def hostpath(self) -> str:
        """Gets the hostpath of this Volume.


        :return: The hostpath of this Volume.
        :rtype: str
        """
        return self._hostpath

    @hostpath.setter
    def hostpath(self, hostpath: str):
        """Sets the hostpath of this Volume.


        :param hostpath: The hostpath of this Volume.
        :type hostpath: str
        """

        self._hostpath = hostpath
