# Generated by Django 1.11.13 on 2018-06-21 13:05

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models

import weblate.utils.fields
import weblate.utils.render


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("trans", "0001_squashed_0143_auto_20180609_1655"),
        ("lang", "0001_squashed_0011_auto_20180215_1158"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("social_django", "0001_initial"),
    ]

    operations = [
        migrations.CreateModel(
            name="Profile",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "language",
                    models.CharField(
                        blank=True,
                        choices=settings.LANGUAGES,
                        max_length=10,
                        verbose_name="Interface Language",
                    ),
                ),
                ("suggested", models.IntegerField(db_index=True, default=0)),
                ("translated", models.IntegerField(db_index=True, default=0)),
                (
                    "subscribe_any_translation",
                    models.BooleanField(
                        default=False, verbose_name="Notification on any translation"
                    ),
                ),
                (
                    "subscribe_new_string",
                    models.BooleanField(
                        default=False,
                        verbose_name="Notification on new string to translate",
                    ),
                ),
                (
                    "subscribe_new_suggestion",
                    models.BooleanField(
                        default=False, verbose_name="Notification on new suggestion"
                    ),
                ),
                (
                    "subscribe_new_contributor",
                    models.BooleanField(
                        default=False, verbose_name="Notification on new contributor"
                    ),
                ),
                (
                    "subscribe_new_comment",
                    models.BooleanField(
                        default=False, verbose_name="Notification on new comment"
                    ),
                ),
                (
                    "subscribe_merge_failure",
                    models.BooleanField(
                        default=False, verbose_name="Notification on merge failure"
                    ),
                ),
                (
                    "subscribe_new_language",
                    models.BooleanField(
                        default=False,
                        verbose_name="Notification on new language request",
                    ),
                ),
                (
                    "languages",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Choose which languages you prefer to translate. These will be offered to you on the dashboard to have easier access to chosen translations.",
                        to="lang.Language",
                        verbose_name="Translated languages",
                    ),
                ),
                (
                    "secondary_languages",
                    models.ManyToManyField(
                        blank=True,
                        help_text="Choose languages you can understand, strings in those languages will be shown in addition to the source string.",
                        related_name="secondary_profile_set",
                        to="lang.Language",
                        verbose_name="Secondary languages",
                    ),
                ),
                (
                    "subscriptions",
                    models.ManyToManyField(
                        blank=True,
                        help_text="You can receive notifications for watched projects and they are shown on the dashboard by default.",
                        to="trans.Project",
                        verbose_name="Watched projects",
                    ),
                ),
                (
                    "user",
                    models.OneToOneField(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "hide_completed",
                    models.BooleanField(
                        default=False,
                        verbose_name="Hide completed translations on the dashboard",
                    ),
                ),
                (
                    "secondary_in_zen",
                    models.BooleanField(
                        default=True,
                        verbose_name="Show secondary translations in the Zen mode",
                    ),
                ),
                (
                    "hide_source_secondary",
                    models.BooleanField(
                        default=False,
                        verbose_name="Hide source if there is secondary language",
                    ),
                ),
                (
                    "dashboard_component_list",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="trans.ComponentList",
                        verbose_name="Default component list",
                    ),
                ),
                (
                    "dashboard_view",
                    models.IntegerField(
                        choices=[
                            (1, "Watched translations"),
                            (2, "Your languages"),
                            (6, "Component lists"),
                            (4, "Component list"),
                            (5, "Suggested translations"),
                        ],
                        default=1,
                        verbose_name="Default dashboard view",
                    ),
                ),
                (
                    "editor_link",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="Enter custom URL to be used as link to open source code. You can use %(branch)s for branch, %(file)s and %(line)s as filename and line placeholders. Usually something like editor://open/?file=%(file)s&line=%(line)s is good option.",
                        max_length=200,
                        validators=[weblate.utils.render.validate_editor],
                        verbose_name="Editor link",
                    ),
                ),
                (
                    "special_chars",
                    models.CharField(
                        blank=True,
                        default="",
                        help_text="You can specify additional special characters to be shown in the visual keyboard while translating. It can be useful for chars you use frequently but are hard to type on your keyboard.",
                        max_length=30,
                        verbose_name="Special characters",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="VerifiedEmail",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("email", models.EmailField(max_length=254)),
                (
                    "social",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="social_django.UserSocialAuth",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="AuditLog",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "activity",
                    models.CharField(
                        choices=[
                            ("auth-connect", "auth-connect"),
                            ("auth-disconnect", "auth-disconnect"),
                            ("connect", "connect"),
                            ("failed-auth", "failed-auth"),
                            ("locked", "locked"),
                            ("login", "login"),
                            ("login-new", "login-new"),
                            ("password", "password"),
                            ("register", "register"),
                            ("removed", "removed"),
                            ("reset", "reset"),
                            ("reset-request", "reset-request"),
                            ("tos", "tos"),
                        ],
                        db_index=True,
                        max_length=20,
                    ),
                ),
                ("params", weblate.utils.fields.JSONField()),
                ("address", models.GenericIPAddressField(null=True)),
                ("timestamp", models.DateTimeField(auto_now_add=True, db_index=True)),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                ("user_agent", models.CharField(default="", max_length=200)),
            ],
            options={"ordering": ["-timestamp"]},
        ),
    ]
