# Generated by Django 1.11.16 on 2018-12-16 13:43

from django.db import migrations


def create_profiles(apps, schema_editor):
    Profile = apps.get_model("accounts", "Profile")
    User = apps.get_model("weblate_auth", "User")
    db_alias = schema_editor.connection.alias
    for user in User.objects.using(db_alias).iterator():
        Profile.objects.using(db_alias).get_or_create(user=user)


class Migration(migrations.Migration):

    dependencies = [("accounts", "0003_profile_translate_mode")]

    operations = [
        migrations.RunPython(
            create_profiles, reverse_code=create_profiles, elidable=True
        )
    ]
