# Generated by Django 2.2 on 2019-04-26 09:41

from django.db import migrations, models

import weblate.utils.render


def migrate_editor(apps, schema_editor):
    Profile = apps.get_model("accounts", "Profile")
    db_alias = schema_editor.connection.alias
    for profile in Profile.objects.using(db_alias).exclude(editor_link=""):
        profile.editor_link = weblate.utils.render.migrate_repoweb(profile.editor_link)
        profile.save()


class Migration(migrations.Migration):

    dependencies = [("accounts", "0007_auto_20190411_0807")]

    operations = [
        migrations.AlterField(
            model_name="profile",
            name="editor_link",
            field=models.CharField(
                blank=True,
                default="",
                help_text="Enter custom URL to be used as link to open source code. You can use {{branch}} for branch, {{filename}} and  {{line}} as filename and line placeholders. Usually something like editor://open/?file={{filename}}&line={{line}} is good option.",
                max_length=200,
                validators=[weblate.utils.render.validate_editor],
                verbose_name="Editor link",
            ),
        ),
        migrations.RunPython(migrate_editor, migrations.RunPython.noop, elidable=True),
    ]
