# Generated by Django 1.11.13 on 2018-06-21 12:49

import django.db.models.deletion
from django.db import migrations, models

import weblate.utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [("trans", "0001_squashed_0143_auto_20180609_1655")]

    operations = [
        migrations.CreateModel(
            name="Addon",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                ("configuration", weblate.utils.fields.JSONField()),
                ("state", weblate.utils.fields.JSONField()),
                (
                    "component",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="trans.Component",
                    ),
                ),
            ],
            options={"verbose_name": "add-on", "verbose_name_plural": "add-ons"},
        ),
        migrations.CreateModel(
            name="Event",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "event",
                    models.IntegerField(
                        choices=[
                            (1, "post push"),
                            (2, "post update"),
                            (3, "pre commit"),
                            (4, "post commit"),
                            (5, "post add"),
                            (6, "unit post create"),
                            (7, "store post load"),
                        ]
                    ),
                ),
                (
                    "addon",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="addons.Addon"
                    ),
                ),
            ],
            options={
                "verbose_name": "add-on event",
                "verbose_name_plural": "add-on events",
            },
        ),
        migrations.AlterUniqueTogether(
            name="event", unique_together={("addon", "event")}
        ),
        migrations.AddField(
            model_name="addon",
            name="project_scope",
            field=models.BooleanField(db_index=True, default=False),
        ),
        migrations.AlterUniqueTogether(
            name="addon", unique_together={("component", "name")}
        ),
    ]
