# Generated by Django 1.11.18 on 2019-02-15 13:46

from django.db import migrations, models


def update_repo_scope(apps, schema_editor):
    """Update the repo_scope flag."""
    Addon = apps.get_model("addons", "Addon")
    db_alias = schema_editor.connection.alias
    Addon.objects.using(db_alias).filter(name="weblate.git.squash").update(
        repo_scope=True
    )


class Migration(migrations.Migration):

    dependencies = [("addons", "0011_squash_addon")]

    operations = [
        migrations.AddField(
            model_name="addon",
            name="repo_scope",
            field=models.BooleanField(db_index=True, default=False),
        ),
        migrations.RunPython(
            update_repo_scope, reverse_code=update_repo_scope, elidable=True
        ),
    ]
