# Generated by Django 2.2 on 2019-06-04 11:30

from django.db import migrations

from weblate.addons.events import EVENT_DAILY, EVENT_POST_UPDATE
from weblate.addons.utils import adjust_addon_events


def update_addon(apps, schema_editor):
    """Update the repo_scope flag."""
    adjust_addon_events(
        apps,
        schema_editor,
        ["weblate.consistency.languages"],
        [EVENT_DAILY],
        [EVENT_POST_UPDATE],
    )


class Migration(migrations.Migration):

    dependencies = [("addons", "0015_flags")]

    operations = [
        migrations.RunPython(update_addon, migrations.RunPython.noop, elidable=True)
    ]
